/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.atmosphere;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.living.LivingEvent;
import zmaster587.advancedRocketry.api.AreaBlob;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.event.AtmosphereEvent;
import zmaster587.advancedRocketry.api.util.IBlobHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.network.PacketAtmSync;
import zmaster587.advancedRocketry.util.AtmosphereBlob;
import zmaster587.advancedRocketry.util.SealableBlockHandler;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.BlockPosition;

public class AtmosphereHandler {
    public static final DamageSource vacuumDamage = new DamageSource("Vacuum").func_76348_h().func_151518_m();
    public static long lastSuffocationTime = Integer.MIN_VALUE;
    private static final int MAX_BLOB_RADIUS = (Configuration.atmosphereHandleBitMask & 1) == 1 ? 256 : Configuration.oxygenVentSize;
    private static HashMap<Integer, AtmosphereHandler> dimensionOxygen = new HashMap();
    private static HashMap<EntityPlayer, IAtmosphere> prevAtmosphere = new HashMap();
    private HashMap<IBlobHandler, AreaBlob> blobs;
    int dimId;
    public static IAtmosphere currentAtm;
    public static int currentPressure;

    public static void registerWorld(int dimId) {
        if (Configuration.enableOxygen && (Configuration.overrideGCAir || dimId != Configuration.MoonId || DimensionManager.getInstance().getDimensionProperties((int)dimId).isNativeDimension)) {
            dimensionOxygen.put(dimId, new AtmosphereHandler(dimId));
            MinecraftForge.EVENT_BUS.register((Object)dimensionOxygen.get(dimId));
            FMLCommonHandler.instance().bus().register((Object)dimensionOxygen.get(dimId));
        }
    }

    public static void unregisterWorld(int dimId) {
        AtmosphereHandler handler = dimensionOxygen.remove(dimId);
        if (Configuration.enableOxygen && handler != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)handler);
            FMLCommonHandler.instance().bus().unregister((Object)handler);
        }
    }

    private AtmosphereHandler(int dimId) {
        this.dimId = dimId;
        this.blobs = new HashMap();
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingUpdateEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity.field_70170_p.field_73011_w.field_76574_g == this.dimId) {
            IAtmosphere atmosType = this.getAtmosphereType(event.entity);
            if (event.entity instanceof EntityPlayer && atmosType != prevAtmosphere.get(event.entity)) {
                PacketHandler.sendToPlayer((BasePacket)new PacketAtmSync(atmosType.getUnlocalizedName(), this.getAtmospherePressure(event.entity)), (EntityPlayer)((EntityPlayer)event.entity));
                prevAtmosphere.put((EntityPlayer)event.entity, atmosType);
            }
            if (atmosType.canTick()) {
                AtmosphereEvent.AtmosphereTickEvent event2 = new AtmosphereEvent.AtmosphereTickEvent(event.entity, atmosType);
                MinecraftForge.EVENT_BUS.post((Event)event2);
                if (!event2.isCanceled() && !Configuration.bypassEntity.contains(event.entity.getClass())) {
                    atmosType.onTick(event.entityLiving);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        prevAtmosphere.remove(event.player);
    }

    @SubscribeEvent
    public void onPlayerLogoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        prevAtmosphere.remove(event.player);
    }

    private void onBlockRemove(BlockPosition pos) {
        List<AreaBlob> blobs = this.getBlobWithinRadius(pos, MAX_BLOB_RADIUS);
        block0: for (AreaBlob blob : blobs) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!blob.contains(pos.getPositionAtOffset(dir.offsetX, dir.offsetY, dir.offsetZ))) continue;
                blob.addBlock(pos, blobs);
                continue block0;
            }
        }
    }

    public static boolean hasAtmosphereHandler(int dimId) {
        return dimensionOxygen.containsKey(dimId);
    }

    public static void onBlockMetaChange(World world, int x, int y, int z) {
        if (Configuration.enableOxygen && !world.field_72995_K && world.func_72938_d((int)x, (int)z).field_76636_d) {
            AtmosphereHandler handler = AtmosphereHandler.getOxygenHandler(world.field_73011_w.field_76574_g);
            BlockPosition pos = new BlockPosition(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (handler == null) {
                return;
            }
            List<AreaBlob> nearbyBlobs = handler.getBlobWithinRadius(pos, MAX_BLOB_RADIUS);
            for (AreaBlob blob : nearbyBlobs) {
                if (!((double)blob.getBlobMaxRadius() > pos.getDistance(blob.getRootPosition()))) continue;
                if (blob.contains(pos) && !blob.isPositionAllowed(world, pos, nearbyBlobs)) {
                    blob.removeBlock(x, y, z);
                    continue;
                }
                if (!blob.contains(pos) && blob.isPositionAllowed(world, pos, nearbyBlobs)) {
                    handler.onBlockRemove(pos);
                    continue;
                }
                if (blob.contains(pos) || blob.isPositionAllowed(world, pos, nearbyBlobs) || blob.getBlobSize() != 0) continue;
                blob.addBlock(blob.getRootPosition(), nearbyBlobs);
            }
        }
    }

    public static void onBlockChange(World world, int x, int y, int z) {
        if (Configuration.enableOxygen && !world.field_72995_K && world.func_72938_d((int)x, (int)z).field_76636_d) {
            BlockPosition pos = new BlockPosition(x, y, z);
            AtmosphereHandler handler = AtmosphereHandler.getOxygenHandler(world.field_73011_w.field_76574_g);
            if (handler == null) {
                return;
            }
            List<AreaBlob> nearbyBlobs = handler.getBlobWithinRadius(pos, MAX_BLOB_RADIUS);
            for (AreaBlob blob : nearbyBlobs) {
                if (world.func_147437_c(x, y, z)) {
                    handler.onBlockRemove(pos);
                    continue;
                }
                if (blob.contains(pos) && SealableBlockHandler.isFulBlock(world, pos)) {
                    blob.removeBlock(x, y, z);
                    continue;
                }
                if (blob.contains(blob.getRootPosition())) continue;
                blob.addBlock(blob.getRootPosition(), nearbyBlobs);
            }
        }
    }

    protected List<AreaBlob> getBlobWithinRadius(BlockPosition pos, int radius) {
        LinkedList<AreaBlob> list = new LinkedList<AreaBlob>();
        for (AreaBlob blob : this.blobs.values()) {
            if (!(blob.getRootPosition().getDistance(pos) - (double)radius <= 0.0)) continue;
            list.add(blob);
        }
        return list;
    }

    public static AtmosphereHandler getOxygenHandler(int dimNumber) {
        return dimensionOxygen.get(dimNumber);
    }

    public void registerBlob(IBlobHandler handler, int x, int y, int z) {
        AreaBlob blob = this.blobs.get(handler);
        if (blob == null) {
            blob = new AtmosphereBlob(handler);
            this.blobs.put(handler, blob);
            blob.setData(AtmosphereType.PRESSURIZEDAIR);
        }
    }

    public void registerBlob(IBlobHandler handler, int x, int y, int z, AreaBlob blob2) {
        AreaBlob blob = this.blobs.get(handler);
        if (blob == null) {
            blob = blob2;
            this.blobs.put(handler, blob);
            blob.setData(AtmosphereType.PRESSURIZEDAIR);
        }
    }

    public void unregisterBlob(IBlobHandler handler) {
        this.blobs.remove(handler);
    }

    public void clearBlob(IBlobHandler handler) {
        if (this.blobs.containsKey(handler)) {
            this.blobs.get(handler).clearBlob();
        }
    }

    public void addBlock(IBlobHandler handler, int x, int y, int z) {
        this.addBlock(handler, new BlockPosition(x, y, z));
    }

    public void addBlock(IBlobHandler handler, BlockPosition pos) {
        AreaBlob blob = this.blobs.get(handler);
        blob.addBlock(pos, this.getBlobWithinRadius(pos, MAX_BLOB_RADIUS));
    }

    public IAtmosphere getAtmosphereType(int x, int y, int z) {
        if (Configuration.enableOxygen) {
            BlockPosition pos = new BlockPosition(x, y, z);
            for (AreaBlob blob : this.blobs.values()) {
                if (!blob.contains(pos)) continue;
                return (IAtmosphere)blob.getData();
            }
            return DimensionManager.getInstance().getDimensionProperties(this.dimId).getAtmosphere();
        }
        return AtmosphereType.AIR;
    }

    public IAtmosphere getAtmosphereType(Entity entity) {
        if (Configuration.enableOxygen) {
            BlockPosition pos = new BlockPosition((int)Math.floor(entity.field_70165_t), (int)Math.ceil(entity.field_70163_u), (int)Math.floor(entity.field_70161_v));
            for (AreaBlob blob : this.blobs.values()) {
                if (!blob.contains(pos)) continue;
                return (IAtmosphere)blob.getData();
            }
            return DimensionManager.getInstance().getDimensionProperties(this.dimId).getAtmosphere();
        }
        return AtmosphereType.AIR;
    }

    public IAtmosphere getDefaultAtmosphereType() {
        return DimensionManager.getInstance().getDimensionProperties(this.dimId).getAtmosphere();
    }

    public int getAtmospherePressure(Entity entity) {
        if (Configuration.enableOxygen) {
            BlockPosition pos = new BlockPosition((int)entity.field_70165_t, (int)Math.ceil(entity.field_70163_u), (int)entity.field_70161_v);
            for (AreaBlob blob : this.blobs.values()) {
                if (!blob.contains(pos) || !(blob instanceof AtmosphereBlob)) continue;
                return ((AtmosphereBlob)blob).getPressure();
            }
        }
        return -1;
    }

    public boolean canEntityBreathe(EntityLiving entity) {
        if (Configuration.enableOxygen) {
            BlockPosition pos = new BlockPosition((int)Math.floor(entity.field_70165_t), (int)Math.ceil(entity.field_70163_u), (int)Math.floor(entity.field_70161_v));
            for (AreaBlob blob : this.blobs.values()) {
                if (!blob.contains(pos) || !((IAtmosphere)blob.getData()).isImmune((EntityLivingBase)entity)) continue;
                return true;
            }
            return DimensionManager.getInstance().getDimensionProperties(this.dimId).getAtmosphere().isImmune((EntityLivingBase)entity);
        }
        return true;
    }

    public int getBlobSize(IBlobHandler handler) {
        return this.blobs.get(handler).getBlobSize();
    }

    public void setAtmosphereType(IBlobHandler handler, IAtmosphere data) {
        this.blobs.get(handler).setData(data);
    }

    public IAtmosphere getAtmosphereType(IBlobHandler handler) {
        return (IAtmosphere)this.blobs.get(handler).getData();
    }
}

