/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.api.util.IBlobHandler;
import zmaster587.libVulpes.util.AdjacencyGraph;
import zmaster587.libVulpes.util.BlockPosition;

public class AreaBlob {
    protected AdjacencyGraph<BlockPosition> graph;
    protected IBlobHandler blobHandler;
    Object data;

    public AreaBlob(IBlobHandler blobHandler) {
        this.blobHandler = blobHandler;
        this.graph = new AdjacencyGraph();
        this.data = null;
    }

    public void setData(Object obj) {
        this.data = obj;
    }

    public boolean isPositionAllowed(World world, BlockPosition pos, List<AreaBlob> otherBlobs) {
        return true;
    }

    public Object getData() {
        return this.data;
    }

    public int getBlobMaxRadius() {
        return this.blobHandler.getMaxBlobRadius();
    }

    public void addBlock(int x, int y, int z, List<AreaBlob> otherBlobs) {
        BlockPosition blockPos = new BlockPosition(x, y, z);
        this.addBlock(blockPos, otherBlobs);
    }

    public void addBlock(BlockPosition blockPos, List<AreaBlob> otherBlobs) {
        if (!this.graph.contains((Object)blockPos) && this.blobHandler.canFormBlob()) {
            this.graph.add((Object)blockPos, this.getPositionsToAdd(blockPos));
        }
    }

    public BlockPosition getRootPosition() {
        return this.blobHandler.getRootPosition();
    }

    protected HashSet<BlockPosition> getPositionsToAdd(BlockPosition blockPos) {
        HashSet<BlockPosition> set = new HashSet<BlockPosition>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            BlockPosition offset = blockPos.getPositionAtOffset(direction.offsetX, direction.offsetY, direction.offsetZ);
            if (!this.graph.contains((Object)offset)) continue;
            set.add(offset);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(BlockPosition position) {
        boolean contains = false;
        AdjacencyGraph<BlockPosition> adjacencyGraph = this.graph;
        synchronized (adjacencyGraph) {
            contains = this.graph.contains((Object)position);
        }
        return contains;
    }

    public boolean contains(int x, int y, int z) {
        return this.contains(new BlockPosition(x, y, z));
    }

    public boolean canBlobsOverlap(int x, int y, int z, AreaBlob otherBlob) {
        return this.blobHandler.canBlobsOverlap(new BlockPosition(x, y, z), otherBlob);
    }

    public void removeBlock(int x, int y, int z) {
        BlockPosition blockPos = new BlockPosition(x, y, z);
        this.graph.remove((Object)blockPos);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            BlockPosition newBlock = blockPos.getPositionAtOffset(direction.offsetX, direction.offsetY, direction.offsetZ);
            if (!this.graph.contains((Object)newBlock) || this.graph.doesPathExist((Object)newBlock, (Object)this.blobHandler.getRootPosition())) continue;
            this.graph.removeAllNodesConnectedTo((Object)newBlock);
        }
    }

    public void clearBlob() {
        this.graph.clear();
    }

    public Set<BlockPosition> getLocations() {
        return this.graph.getKeys();
    }

    public int getBlobSize() {
        return this.graph.size();
    }
}

