/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.crate;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.item.tile.ItemTileBetterStorage;
import net.mcft.copy.betterstorage.misc.ConnectedTexture;
import net.mcft.copy.betterstorage.tile.TileContainerBetterStorage;
import net.mcft.copy.betterstorage.tile.crate.TileEntityCrate;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import vazkii.botania.api.mana.ILaputaImmobile;

@Optional.Interface(modid="Botania", iface="vazkii.botania.api.mana.ILaputaImmobile", striprefs=true)
public class TileCrate
extends TileContainerBetterStorage
implements ILaputaImmobile {
    private ConnectedTexture texture = new ConnectedTextureCrate();

    public TileCrate() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149766_f);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemTileBetterStorage.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.texture.registerIcons(iconRegister, "betterstorage:crate/%s");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.texture.getIcon("all");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return this.texture.getConnectedIcon(world, x, y, z, ForgeDirection.getOrientation((int)side));
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityCrate();
    }

    public void onBlockPlacedExtended(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, EntityLivingBase entity, ItemStack stack) {
        TileEntityCrate crate = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityCrate.class);
        if (stack.func_82837_s()) {
            crate.setCustomTitle(stack.func_82833_r());
        }
        crate.attemptConnect(ForgeDirection.getOrientation((int)side).getOpposite());
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityCrate.class).openGui(player);
        return true;
    }

    public boolean func_149740_M() {
        return true;
    }

    public boolean canMove(World world, int x, int y, int z) {
        return false;
    }

    private class ConnectedTextureCrate
    extends ConnectedTexture {
        private ConnectedTextureCrate() {
        }

        @Override
        public boolean canConnect(IBlockAccess world, int x, int y, int z, ForgeDirection side, ForgeDirection connected) {
            if (world.func_147439_a(x, y, z) != TileCrate.this) {
                return false;
            }
            int offX = x + connected.offsetX;
            int offY = y + connected.offsetY;
            int offZ = z + connected.offsetZ;
            TileEntityCrate connectedCrate = WorldUtils.get(world, offX, offY, offZ, TileEntityCrate.class);
            if (connectedCrate == null) {
                return false;
            }
            TileEntityCrate crate = WorldUtils.get(world, x, y, z, TileEntityCrate.class);
            return crate.getID() == connectedCrate.getID();
        }
    }
}

