/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.proxy;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.api.stand.BetterStorageArmorStand;
import net.mcft.copy.betterstorage.api.stand.EnumArmorStandRegion;
import net.mcft.copy.betterstorage.attachment.EnumAttachmentInteraction;
import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.entity.EntityCluckington;
import net.mcft.copy.betterstorage.item.IDyeableItem;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.item.ItemBucketSlime;
import net.mcft.copy.betterstorage.item.cardboard.ICardboardItem;
import net.mcft.copy.betterstorage.item.cardboard.ItemCardboardSheet;
import net.mcft.copy.betterstorage.misc.ChristmasEventHandler;
import net.mcft.copy.betterstorage.misc.handlers.BackpackHandler;
import net.mcft.copy.betterstorage.misc.handlers.CraftingHandler;
import net.mcft.copy.betterstorage.tile.crate.CratePileCollection;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLockableDoor;
import net.mcft.copy.betterstorage.tile.stand.VanillaArmorStandEquipHandler;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;

public class CommonProxy {
    private boolean preventSlimeBucketUse = false;

    public void initialize() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        new BackpackHandler();
        new CraftingHandler();
        if (BetterStorage.globalConfig.getBoolean("general.enableChristmasEvent")) {
            new ChristmasEventHandler();
        }
        this.registerArmorStandHandlers();
    }

    protected void registerArmorStandHandlers() {
        BetterStorageArmorStand.helmet = new VanillaArmorStandEquipHandler(EnumArmorStandRegion.HEAD);
        BetterStorageArmorStand.chestplate = new VanillaArmorStandEquipHandler(EnumArmorStandRegion.CHEST);
        BetterStorageArmorStand.leggins = new VanillaArmorStandEquipHandler(EnumArmorStandRegion.LEGS);
        BetterStorageArmorStand.boots = new VanillaArmorStandEquipHandler(EnumArmorStandRegion.FEET);
        BetterStorageArmorStand.registerEquipHandler(BetterStorageArmorStand.helmet);
        BetterStorageArmorStand.registerEquipHandler(BetterStorageArmorStand.chestplate);
        BetterStorageArmorStand.registerEquipHandler(BetterStorageArmorStand.leggins);
        BetterStorageArmorStand.registerEquipHandler(BetterStorageArmorStand.boots);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        CratePileCollection.unload(event.world);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        MovingObjectPosition target;
        int metadata;
        IHasAttachments hasAttachments;
        boolean rightClick;
        World world = event.entity.field_70170_p;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        EntityPlayer player = event.entityPlayer;
        ItemStack holding = player.func_71045_bC();
        Block block = world.func_147439_a(x, y, z);
        boolean leftClick = event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK;
        boolean bl = rightClick = event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK;
        if ((leftClick || rightClick) && (hasAttachments = WorldUtils.get((IBlockAccess)world, x, y, z, IHasAttachments.class)) != null) {
            EnumAttachmentInteraction interactionType;
            EnumAttachmentInteraction enumAttachmentInteraction = interactionType = event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK ? EnumAttachmentInteraction.attack : EnumAttachmentInteraction.use;
            if (hasAttachments.getAttachments().interact(WorldUtils.rayTrace(player, 1.0f), player, interactionType)) {
                event.useBlock = Event.Result.DENY;
                event.useItem = Event.Result.DENY;
            }
        }
        if (rightClick && block == Blocks.field_150383_bp && (metadata = world.func_72805_g(x, y, z)) > 0) {
            IDyeableItem dyeable;
            IDyeableItem iDyeableItem = dyeable = holding != null && holding.func_77973_b() instanceof IDyeableItem ? (IDyeableItem)holding.func_77973_b() : null;
            if (dyeable != null && dyeable.canDye(holding)) {
                StackUtils.remove(holding, "display", "color");
                world.func_72921_c(x, y, z, metadata - 1, 2);
                world.func_147453_f(x, y, z, block);
                event.useBlock = Event.Result.DENY;
                event.useItem = Event.Result.DENY;
            }
        }
        if (leftClick && holding != null && holding.func_77973_b() instanceof ICardboardItem && !ItemCardboardSheet.isEffective(holding)) {
            event.useItem = Event.Result.DENY;
        }
        if (!world.field_72995_K && BetterStorageTiles.lockableDoor != null && rightClick && block == Blocks.field_150454_av && (target = WorldUtils.rayTrace(player, 1.0f)) != null && this.getIronDoorHightlightBox(player, world, x, y, z, target.field_72307_f, block) != null) {
            ForgeDirection orientation;
            boolean isMirrored;
            int meta = world.func_72805_g(x, y, z);
            if (meta >= 8) {
                isMirrored = meta == 9;
                meta = world.func_72805_g(x, --y, z);
            } else {
                isMirrored = world.func_72805_g(x, y + 1, z) == 9;
            }
            int rotation = meta & 3;
            ForgeDirection forgeDirection = rotation == 0 ? ForgeDirection.WEST : (rotation == 1 ? ForgeDirection.NORTH : (orientation = rotation == 2 ? ForgeDirection.EAST : ForgeDirection.SOUTH));
            orientation = isMirrored ? (orientation == ForgeDirection.WEST ? ForgeDirection.SOUTH : (orientation == ForgeDirection.NORTH ? ForgeDirection.WEST : (orientation == ForgeDirection.EAST ? ForgeDirection.NORTH : ForgeDirection.EAST))) : orientation;
            world.func_147465_d(x, y, z, (Block)BetterStorageTiles.lockableDoor, 0, 2);
            world.func_147465_d(x, y + 1, z, (Block)BetterStorageTiles.lockableDoor, 8, 2);
            TileEntityLockableDoor te = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockableDoor.class);
            te.orientation = orientation;
            te.isOpen = isMirrored;
            te.isMirrored = isMirrored;
            te.setLock(holding);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
        }
        if (this.preventSlimeBucketUse) {
            event.setCanceled(true);
            this.preventSlimeBucketUse = false;
        }
    }

    protected AxisAlignedBB getIronDoorHightlightBox(EntityPlayer player, World world, int x, int y, int z, Vec3 hitVec, Block block) {
        AxisAlignedBB box;
        boolean isMirrored;
        if (!StackUtils.isLock(player.func_71045_bC())) {
            return null;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 8) {
            isMirrored = meta == 9;
            meta = world.func_72805_g(x, --y, z);
        } else {
            isMirrored = world.func_72805_g(x, y + 1, z) == 9;
        }
        boolean isOpen = (meta & 4) == 4;
        int rotation = meta & 3;
        int n = isMirrored ? (rotation == 0 ? 3 : (rotation == 1 ? 0 : (rotation == 2 ? 1 : 2))) : (rotation = rotation);
        isOpen = isMirrored ? !isOpen : isOpen;
        switch (rotation) {
            case 0: {
                if (!isOpen) {
                    box = AxisAlignedBB.func_72330_a((double)((double)x - 3.125E-4), (double)((double)y + 0.90625), (double)((float)z + 0.625f), (double)((double)x + 0.1878125), (double)((double)y + 1.28125), (double)((float)z + 0.9375f));
                    break;
                }
                box = AxisAlignedBB.func_72330_a((double)((float)x + 0.625f), (double)((double)y + 0.90625), (double)((double)z - 3.125E-4), (double)((float)x + 0.9375f), (double)((double)y + 1.28125), (double)((double)z + 0.1878125));
                break;
            }
            case 1: {
                if (!isOpen) {
                    box = AxisAlignedBB.func_72330_a((double)((float)x + 0.0625f), (double)((double)y + 0.90625), (double)((double)z - 3.125E-4), (double)((float)x + 0.375f), (double)((double)y + 1.28125), (double)((double)z + 0.1878125));
                    break;
                }
                box = AxisAlignedBB.func_72330_a((double)((double)x + 0.8121875), (double)((double)y + 0.90625), (double)((float)z + 0.625f), (double)((double)x + 1.0003125), (double)((double)y + 1.28125), (double)((float)z + 0.9375f));
                break;
            }
            case 2: {
                if (!isOpen) {
                    box = AxisAlignedBB.func_72330_a((double)((double)x + 0.8121875), (double)((double)y + 0.90625), (double)((float)z + 0.0625f), (double)((double)x + 1.0003125), (double)((double)y + 1.28125), (double)((float)z + 0.375f));
                    break;
                }
                box = AxisAlignedBB.func_72330_a((double)((float)x + 0.0625f), (double)((double)y + 0.90625), (double)((double)z + 0.8121875), (double)((float)x + 0.375f), (double)((double)y + 1.28125), (double)((double)z + 1.0003125));
                break;
            }
            default: {
                box = !isOpen ? AxisAlignedBB.func_72330_a((double)((float)x + 0.625f), (double)((double)y + 0.90625), (double)((double)z + 0.8121875), (double)((float)x + 0.9375f), (double)((double)y + 1.28125), (double)((double)z + 1.0003125)) : AxisAlignedBB.func_72330_a((double)((double)x - 3.125E-4), (double)((double)y + 0.90625), (double)((float)z + 0.0625f), (double)((double)x + 0.1878125), (double)((double)y + 1.28125), (double)((float)z + 0.375f));
            }
        }
        return box.func_72318_a(hitVec) ? box : null;
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.entityPlayer;
        ItemStack holding = player.func_71045_bC();
        if (holding != null && holding.func_77973_b() instanceof ICardboardItem && !ItemCardboardSheet.isEffective(holding)) {
            event.newSpeed = -1.0f;
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.entity.field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        Entity target = event.target;
        ItemStack holding = player.func_71045_bC();
        if (target.getClass() == EntityChicken.class && holding != null && holding.func_77973_b() == Items.field_151057_cb) {
            EntityChicken chicken = (EntityChicken)target;
            if (!chicken.field_70128_L && !chicken.func_70631_g_() && "Cluckington".equals(holding.func_82833_r())) {
                EntityCluckington.spawn(chicken);
            }
        }
        if (BetterStorageItems.slimeBucket != null && target instanceof EntityLiving && holding != null && holding.func_77973_b() == Items.field_151133_ar) {
            ItemBucketSlime.pickUpSlime(player, (EntityLiving)target);
            if (player.func_71045_bC().func_77973_b() instanceof ItemBucketSlime) {
                this.preventSlimeBucketUse = true;
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER) {
            CratePileCollection.getCollection(event.world).onTick();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            ItemStack stack = event.player.func_71124_b(3);
            if (stack != null && stack.func_77973_b() instanceof ItemBackpack && !BetterStorage.globalConfig.getBoolean("general.backpackChestplate")) {
                event.player.func_70062_b(3, null);
                ItemBackpack.setBackpack((EntityLivingBase)event.player, stack, ItemBackpack.getBackpackData((EntityLivingBase)event.player).contents);
            } else if ((stack == null || stack.func_77973_b() != null && !(stack.func_77973_b() instanceof ItemBackpack)) && ItemBackpack.getBackpackData((EntityLivingBase)event.player).backpack != null && BetterStorage.globalConfig.getBoolean("general.backpackChestplate")) {
                ItemStack backpack = ItemBackpack.getBackpack((EntityLivingBase)event.player);
                ItemBackpack.getBackpackData((EntityLivingBase)event.player).backpack = null;
                if (stack != null) {
                    WorldUtils.dropStackFromEntity((Entity)event.player, stack, 4.0f);
                }
                event.player.func_70062_b(3, backpack);
            }
        }
    }
}

