/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.container;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import invtweaks.api.container.ChestContainer;
import net.mcft.copy.betterstorage.client.gui.GuiBetterStorage;
import net.mcft.copy.betterstorage.container.SlotBetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

@ChestContainer(isLargeChest=true)
public class ContainerBetterStorage
extends Container {
    private final int columns;
    private final int rows;
    public final EntityPlayer player;
    public final IInventory inventory;
    public final int separation;
    private int startHotbar = -1;
    @SideOnly(value=Side.CLIENT)
    public GuiBetterStorage updateGui;

    @ChestContainer.RowSizeCallback
    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public ContainerBetterStorage(EntityPlayer player, IInventory inventory, int columns, int rows, int seperation) {
        this.player = player;
        this.inventory = inventory;
        this.columns = columns;
        this.rows = rows;
        this.separation = seperation;
        this.setupInventoryContainer();
        this.setupInventoryPlayer();
        inventory.func_70295_k_();
    }

    public ContainerBetterStorage(EntityPlayer player, IInventory inventory, int columns, int rows) {
        this(player, inventory, columns, rows, 14);
    }

    public ContainerBetterStorage(EntityPlayer player, InventoryTileEntity inventory) {
        this(player, inventory, inventory.columns, inventory.rows);
    }

    @SideOnly(value=Side.CLIENT)
    public ContainerBetterStorage(EntityPlayer player, IInventory inventory, int columns, int rows, GuiBetterStorage gui) {
        this(player, inventory, columns, rows);
        this.setUpdateGui(gui);
    }

    public int getHeight() {
        return (this.getRows() + 4) * 18 + this.separation + 29;
    }

    protected void setupInventoryContainer() {
        for (int y = 0; y < this.getRows(); ++y) {
            for (int x = 0; x < this.getColumns(); ++x) {
                this.func_75146_a(new SlotBetterStorage(this, this.inventory, x + y * this.getColumns(), 8 + x * 18, 18 + y * 18));
            }
        }
    }

    protected void setupInventoryPlayer() {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new SlotBetterStorage(this, (IInventory)this.player.field_71071_by, 9 + x + y * 9, 8 + x * 18 + (this.getColumns() - 9) * 9, this.getHeight() - 83 + y * 18));
            }
        }
        this.setHotbarStart();
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new SlotBetterStorage(this, (IInventory)this.player.field_71071_by, x, 8 + x * 18 + (this.getColumns() - 9) * 9, this.getHeight() - 25));
        }
    }

    protected void setHotbarStart() {
        this.startHotbar = this.field_75151_b.size();
    }

    protected boolean inInventory(int slot) {
        return slot < this.inventory.func_70302_i_();
    }

    protected int transferStart(int slot) {
        return this.inInventory(slot) ? this.inventory.func_70302_i_() : 0;
    }

    protected int transferEnd(int slot) {
        return this.inInventory(slot) ? this.field_75151_b.size() : this.inventory.func_70302_i_();
    }

    protected boolean transferDirection(int slot) {
        return this.inInventory(slot);
    }

    public void onSlotChanged(int slot) {
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotId) {
        ItemStack stack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (!this.func_75135_a(slotStack, this.transferStart(slotId), this.transferEnd(slotId), this.transferDirection(slotId))) {
                return null;
            }
            if (slotStack.field_77994_a != 0) {
                slot.func_75218_e();
            } else {
                slot.func_75215_d(null);
            }
        }
        return stack;
    }

    protected boolean func_75135_a(ItemStack stack, int start, int end, boolean backwards) {
        int maxStackSize;
        ItemStack slotStack;
        Slot slot;
        int index;
        int i;
        boolean success = false;
        if (stack.func_77985_e()) {
            for (i = 0; i < end - start; ++i) {
                int amount;
                ItemStack testStack;
                index = start + (backwards ? end - start - 1 - i : i);
                slot = (Slot)this.field_75151_b.get(index);
                slotStack = slot.func_75211_c();
                maxStackSize = Math.min(stack.func_77976_d(), slot.field_75224_c.func_70297_j_());
                if (StackUtils.matches(stack, slotStack) && slotStack.field_77994_a < maxStackSize && slot.func_75214_a(testStack = StackUtils.copyStack(stack, amount = Math.min(slotStack.field_77994_a + stack.field_77994_a, maxStackSize))) && slot.field_75224_c.func_94041_b(slot.field_75222_d, testStack)) {
                    stack.field_77994_a -= testStack.field_77994_a - slotStack.field_77994_a;
                    slot.func_75215_d(testStack);
                    success = true;
                }
                if (stack.field_77994_a > 0) continue;
                return success;
            }
        }
        for (i = 0; i < end - start; ++i) {
            ItemStack testStack;
            index = start + (backwards ? end - start - 1 - i : i);
            slot = (Slot)this.field_75151_b.get(index);
            slotStack = slot.func_75211_c();
            if (slotStack == null && slot.func_75214_a(testStack = StackUtils.copyStack(stack, Math.min(stack.field_77994_a, maxStackSize = Math.min(stack.func_77976_d(), slot.field_75224_c.func_70297_j_())))) && slot.field_75224_c.func_94041_b(slot.field_75222_d, testStack)) {
                stack.field_77994_a -= testStack.field_77994_a;
                slot.func_75215_d(testStack);
                success = true;
            }
            if (stack.field_77994_a <= 0) break;
        }
        return success;
    }

    public ItemStack func_75144_a(int slotId, int button, int special, EntityPlayer player) {
        Slot slot = null;
        if (slotId >= 0 && slotId < this.field_75151_b.size()) {
            slot = (Slot)this.field_75151_b.get(slotId);
        }
        if (slot != null) {
            if (special == 0) {
                if (button == 0 || button == 1) {
                    ItemStack slotStack = slot.func_75211_c();
                    ItemStack holding = player.field_71071_by.func_70445_o();
                    if (slotStack != null && holding != null && (holding == null ? slot.func_82869_a(player) : slot.func_75214_a(holding)) && StackUtils.matches(slotStack, holding)) {
                        int amount = button == 0 ? holding.field_77994_a : 1;
                        amount = Math.min(amount, slot.func_75219_a() - slotStack.field_77994_a);
                        if ((amount = Math.min(amount, slotStack.func_77976_d() - slotStack.field_77994_a)) > 0) {
                            if ((holding.field_77994_a -= amount) <= 0) {
                                player.field_71071_by.func_70437_b(null);
                            }
                            slot.func_75215_d(StackUtils.copyStack(slotStack, slotStack.field_77994_a + amount));
                        }
                        return slotStack;
                    }
                }
            } else {
                if (special == 1) {
                    return slot.func_82869_a(player) ? this.func_82846_b(player, slotId) : null;
                }
                if (special == 2 && button >= 0 && button < 9) {
                    if (this.startHotbar < 0) {
                        return null;
                    }
                    Slot slot2 = (Slot)this.field_75151_b.get(this.startHotbar + button);
                    ItemStack stack = slot.func_75211_c();
                    if (!slot2.func_82869_a(player) || stack != null && !slot2.func_75214_a(stack)) {
                        return null;
                    }
                }
            }
        }
        return super.func_75144_a(slotId, button, special, player);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.inventory.func_70305_f();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int val) {
        if (this.updateGui != null) {
            this.updateGui.update(id, val);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setUpdateGui(GuiBetterStorage gui) {
        this.updateGui = gui;
    }

    public void sendUpdate(int id, int value) {
        for (Object c : this.field_75149_d) {
            ((ICrafting)c).func_71112_a((Container)this, id, value);
        }
    }

    public void sendUpdateIfChanged(int id, int value, int previousValue) {
        if (value != previousValue) {
            this.sendUpdate(id, value);
        }
    }
}

