/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.client.renderer;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.attachment.LockAttachment;
import net.mcft.copy.betterstorage.client.model.ModelLargeLocker;
import net.mcft.copy.betterstorage.client.model.ModelLocker;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLocker;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityLockerRenderer
extends TileEntitySpecialRenderer {
    private ModelLocker lockerModel = new ModelLocker();
    private ModelLocker largeLockerModel = new ModelLargeLocker();

    public void renderTileEntityAt(TileEntityLocker locker, double x, double y, double z, float partialTicks) {
        float scale = 0.0625f;
        boolean large = locker.isConnected();
        if (large && !locker.isMain()) {
            return;
        }
        boolean index = locker.mirror;
        ModelLocker model = large ? this.largeLockerModel : this.lockerModel;
        this.func_147499_a(locker.getResource());
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        float angle = locker.prevLidAngle + (locker.lidAngle - locker.prevLidAngle) * partialTicks;
        angle = 1.0f - angle;
        angle = 1.0f - angle * angle * angle;
        angle *= 90.0f;
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        int rotation = DirectionUtils.getRotation(locker.getOrientation());
        GL11.glRotatef((float)(-rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        model.renderAll(locker.mirror, angle);
        GL11.glPopMatrix();
        if (locker.canHaveLock()) {
            if (angle > 0.0f) {
                double seven = 0.4375;
                GL11.glTranslated((double)(locker.mirror ? seven : -seven), (double)0.0, (double)seven);
                GL11.glRotatef((float)(locker.mirror ? angle : -angle), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)(locker.mirror ? -seven : seven), (double)0.0, (double)(-seven));
            }
            LockAttachment a = locker.lockAttachment;
            GL11.glTranslated((double)(0.5 - a.getX()), (double)(0.5 - a.getY()), (double)(0.5 - a.getZ()));
            a.getRenderer().render(a, partialTicks);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity entity, double x, double y, double z, float par8) {
        this.renderTileEntityAt((TileEntityLocker)entity, x, y, z, par8);
    }
}

