/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.attachment;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.api.BetterStorageEnchantment;
import net.mcft.copy.betterstorage.api.lock.EnumLockInteraction;
import net.mcft.copy.betterstorage.api.lock.IKey;
import net.mcft.copy.betterstorage.api.lock.ILock;
import net.mcft.copy.betterstorage.api.lock.ILockable;
import net.mcft.copy.betterstorage.attachment.EnumAttachmentInteraction;
import net.mcft.copy.betterstorage.attachment.IAttachmentRenderer;
import net.mcft.copy.betterstorage.attachment.ItemAttachment;
import net.mcft.copy.betterstorage.attachment.LockAttachmentRenderer;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.item.ItemBetterStorage;
import net.mcft.copy.betterstorage.network.packet.PacketLockHit;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class LockAttachment
extends ItemAttachment {
    public int hit = 0;
    public int breakProgress = 0;
    public float wiggle = 0.0f;
    public float wiggleStrength = 0.0f;

    public LockAttachment(TileEntity tileEntity, int subId) {
        super(tileEntity, subId);
        if (!(tileEntity instanceof ILockable)) {
            throw new IllegalArgumentException("tileEntity must be ILockable.");
        }
    }

    @Override
    public boolean boxVisible(EntityPlayer player) {
        ItemStack holding = player != null ? player.func_71045_bC() : null;
        return this.item != null || StackUtils.isLock(holding);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IAttachmentRenderer getRenderer() {
        return LockAttachmentRenderer.instance;
    }

    @Override
    public void update() {
        this.hit = Math.max(-20, this.hit - 1);
        if (this.hit <= -20) {
            this.breakProgress = Math.max(0, this.breakProgress - 1);
        }
        if (this.tileEntity.func_145831_w().field_72995_K) {
            this.wiggle += 1.0f;
            this.wiggleStrength = Math.max(0.0f, this.wiggleStrength * 0.9f - 0.1f);
        }
    }

    @Override
    public boolean interact(EntityPlayer player, EnumAttachmentInteraction type) {
        ItemStack holding = player.func_71045_bC();
        return type == EnumAttachmentInteraction.attack ? this.attack(player, holding) : this.use(player, holding);
    }

    @Override
    public ItemStack pick() {
        int fullColor;
        if (this.item == null) {
            return null;
        }
        ItemStack key = new ItemStack((Item)BetterStorageItems.key);
        ItemBetterStorage.setID(key, ItemBetterStorage.getID(this.item));
        int color = ItemBetterStorage.getColor(this.item);
        if (color >= 0) {
            ItemBetterStorage.setColor(key, color);
        }
        if ((fullColor = ItemBetterStorage.getFullColor(this.item)) >= 0) {
            ItemBetterStorage.setFullColor(key, fullColor);
        }
        return key;
    }

    private boolean attack(EntityPlayer player, ItemStack holding) {
        boolean canHurt;
        ILockable lockable = (ILockable)this.tileEntity;
        ItemStack lock = lockable.getLock();
        if (lock == null) {
            return false;
        }
        boolean bl = canHurt = this.hit <= 0 && this.canHurtLock(holding);
        if (canHurt) {
            holding.func_77972_a(2, (EntityLivingBase)player);
            if (holding.field_77994_a <= 0) {
                player.func_71028_bD();
            }
        }
        if (!player.field_70170_p.field_72995_K) {
            if (canHurt) {
                this.hit = 10;
                int damage = (int)((AttributeModifier)holding.func_111283_C().get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).iterator().next()).func_111164_d();
                int sharpness = EnchantmentHelper.func_77506_a((int)Enchantment.field_77338_j.field_77352_x, (ItemStack)holding);
                int efficiency = EnchantmentHelper.func_77506_a((int)Enchantment.field_77349_p.field_77352_x, (ItemStack)holding);
                this.breakProgress += Math.min(damage, 10) / 2 + Math.min(Math.max(sharpness, efficiency), 5);
                int persistance = BetterStorageEnchantment.getLevel(lock, "persistance");
                if (this.breakProgress > 100 * (1 + persistance)) {
                    int unbreaking = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)lock);
                    lock.func_77964_b(lock.func_77960_j() + 10 / (1 + unbreaking));
                    if (lock.func_77960_j() < lock.func_77958_k()) {
                        AxisAlignedBB box = this.getHighlightBox();
                        double x = (box.field_72340_a + box.field_72336_d) / 2.0;
                        double y = (box.field_72338_b + box.field_72337_e) / 2.0;
                        double z = (box.field_72339_c + box.field_72334_f) / 2.0;
                        EntityItem item = WorldUtils.spawnItem(this.tileEntity.func_145831_w(), x, y, z, lock);
                    }
                    lockable.setLock(null);
                    this.breakProgress = 0;
                }
                ((ILock)lock.func_77973_b()).applyEffects(lock, lockable, player, EnumLockInteraction.ATTACK);
            }
            BetterStorage.networkChannel.sendToAllAround(new PacketLockHit(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e, canHurt), this.tileEntity.func_145831_w(), this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e, 32.0);
        } else {
            this.hit(canHurt);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void hit(boolean damage) {
        this.wiggleStrength = Math.min(20.0f, this.wiggleStrength + 12.0f);
        if (damage) {
            this.hit = 10;
            AxisAlignedBB box = this.getHighlightBox();
            double x = (box.field_72340_a + box.field_72336_d) / 2.0;
            double y = (box.field_72338_b + box.field_72337_e) / 2.0;
            double z = (box.field_72339_c + box.field_72334_f) / 2.0;
            this.tileEntity.func_145831_w().func_72980_b(x, y, z, "random.break", 0.5f, 2.5f, false);
        }
    }

    private boolean use(EntityPlayer player, ItemStack holding) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        ILockable lockable = (ILockable)this.tileEntity;
        ItemStack lock = lockable.getLock();
        if (lock == null) {
            if (StackUtils.isLock(holding) && lockable.isLockValid(holding)) {
                lockable.setLock(holding);
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                return true;
            }
        } else if (StackUtils.isKey(holding)) {
            IKey keyType = (IKey)holding.func_77973_b();
            ILock lockType = (ILock)lock.func_77973_b();
            boolean success = keyType.unlock(holding, lock, true);
            lockType.onUnlock(lock, holding, lockable, player, success);
            if (!success) {
                return true;
            }
            if (player.func_70093_af()) {
                AxisAlignedBB box = this.getHighlightBox();
                double x = (box.field_72340_a + box.field_72336_d) / 2.0;
                double y = (box.field_72338_b + box.field_72337_e) / 2.0;
                double z = (box.field_72339_c + box.field_72334_f) / 2.0;
                EntityItem item = WorldUtils.spawnItem(player.field_70170_p, x, y, z, lock);
                lockable.setLock(null);
            } else {
                lockable.useUnlocked(player);
            }
            return true;
        }
        return false;
    }

    private boolean canHurtLock(ItemStack stack) {
        if (stack == null || !BetterStorage.globalConfig.getBoolean("general.lockBreakable")) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item instanceof ItemSword || item instanceof ItemPickaxe || item instanceof ItemAxe;
    }
}

