/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.api.stand;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mcft.copy.betterstorage.api.stand.ArmorStandEquipHandler;
import net.mcft.copy.betterstorage.api.stand.EnumArmorStandRegion;
import net.mcft.copy.betterstorage.api.stand.IArmorStandRenderHandler;

public final class BetterStorageArmorStand {
    private static final Map<EnumArmorStandRegion, List<ArmorStandEquipHandler>> handlersByPriority = new HashMap<EnumArmorStandRegion, List<ArmorStandEquipHandler>>();
    private static final Map<EnumArmorStandRegion, Map<String, ArmorStandEquipHandler>> handlersById = new HashMap<EnumArmorStandRegion, Map<String, ArmorStandEquipHandler>>();
    private static final List<IArmorStandRenderHandler> renderHandlers = new ArrayList<IArmorStandRenderHandler>();
    public static ArmorStandEquipHandler helmet;
    public static ArmorStandEquipHandler chestplate;
    public static ArmorStandEquipHandler leggins;
    public static ArmorStandEquipHandler boots;

    private BetterStorageArmorStand() {
    }

    public static void registerEquipHandler(ArmorStandEquipHandler handler) {
        List<ArmorStandEquipHandler> list = handlersByPriority.get((Object)handler.region);
        list.add(handler);
        Collections.sort(list);
        handlersById.get((Object)handler.region).put(handler.id, handler);
    }

    public static Iterable<ArmorStandEquipHandler> getEquipHandlers(EnumArmorStandRegion region) {
        return handlersByPriority.get((Object)region);
    }

    public static ArmorStandEquipHandler getEquipHandler(EnumArmorStandRegion region, String id) {
        return handlersById.get((Object)region).get(id);
    }

    public static void registerRenderHandler(IArmorStandRenderHandler renderHandler) {
        renderHandlers.add(renderHandler);
    }

    public static Iterable<IArmorStandRenderHandler> getRenderHandlers() {
        return renderHandlers;
    }

    static {
        for (EnumArmorStandRegion region : EnumArmorStandRegion.values()) {
            handlersByPriority.put(region, new ArrayList());
            handlersById.put(region, new HashMap());
        }
    }
}

