/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerInventoryLevel
extends BCStatement
implements ITriggerExternal {
    public TriggerType type;

    public TriggerInventoryLevel(TriggerType type) {
        super("buildcraft:inventorylevel." + type.name().toLowerCase(Locale.ENGLISH), "buildcraft.inventorylevel." + type.name().toLowerCase(Locale.ENGLISH), "buildcraft.filteredBuffer." + type.name().toLowerCase(Locale.ENGLISH));
        this.type = type;
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public int minParameters() {
        return 1;
    }

    @Override
    public String getDescription() {
        return String.format(StringUtils.localize("gate.trigger.inventorylevel.below"), (int)(this.type.level * 100.0f));
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, ForgeDirection side, IStatementContainer container, IStatementParameter[] parameters) {
        if (parameters == null || parameters.length < 1 || parameters[0] == null) {
            return false;
        }
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            ItemStack searchStack = parameters[0].getItemStack();
            if (searchStack == null) {
                return false;
            }
            int stackSpace = 0;
            int foundItems = 0;
            for (IInvSlot slot : InventoryIterator.getIterable(inventory, side.getOpposite())) {
                ItemStack stackInSlot;
                if (!slot.canPutStackInSlot(searchStack) || (stackInSlot = slot.getStackInSlot()) != null && !StackHelper.canStacksOrListsMerge(stackInSlot, searchStack)) continue;
                ++stackSpace;
                foundItems += stackInSlot == null ? 0 : stackInSlot.field_77994_a;
            }
            if (stackSpace > 0) {
                float percentage = (float)foundItems / ((float)stackSpace * (float)Math.min(searchStack.func_77976_d(), inventory.func_70297_j_()));
                return percentage < this.type.level;
            }
        }
        return false;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        this.icon = register.func_94245_a("buildcraftcore:triggers/trigger_inventory_" + this.type.name().toLowerCase());
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    public static enum TriggerType {
        BELOW25(0.25f),
        BELOW50(0.5f),
        BELOW75(0.75f);

        public final float level;

        private TriggerType(float level) {
            this.level = level;
        }
    }
}

