/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network.command;

import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.command.CommandTarget;
import buildcraft.core.lib.network.command.CommandTargetContainer;
import buildcraft.core.lib.network.command.CommandTargetEntity;
import buildcraft.core.lib.network.command.CommandTargetTile;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.utils.NetworkUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;

public class PacketCommand
extends Packet {
    public static final ArrayList<CommandTarget> targets = new ArrayList();
    public ByteBuf stream;
    public String command;
    public Object target;
    public CommandTarget handler;
    private CommandWriter writer;

    public PacketCommand() {
    }

    public PacketCommand(Object target, String command, CommandWriter writer) {
        this.target = target;
        this.command = command;
        this.writer = writer;
        this.isChunkDataPacket = true;
        for (CommandTarget c : targets) {
            if (!c.getHandledClass().isAssignableFrom(target.getClass())) continue;
            this.handler = c;
            break;
        }
    }

    public void handle(EntityPlayer player) {
        ICommandReceiver receiver;
        if (this.handler != null && (receiver = this.handler.handle(player, this.stream, player.field_70170_p)) != null) {
            receiver.receiveCommand(this.command, FMLCommonHandler.instance().getEffectiveSide(), player, this.stream);
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        NetworkUtils.writeUTF(data, this.command);
        data.writeByte(targets.indexOf(this.handler));
        this.handler.write(data, this.target);
        if (this.writer != null) {
            this.writer.write(data);
        }
    }

    @Override
    public void readData(ByteBuf data) {
        this.command = NetworkUtils.readUTF(data);
        this.handler = targets.get(data.readUnsignedByte());
        this.stream = data;
    }

    @Override
    public int getID() {
        return 1;
    }

    static {
        targets.add(new CommandTargetTile());
        targets.add(new CommandTargetEntity());
        targets.add(new CommandTargetContainer());
    }
}

