/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.vec;

import cofh.repack.codechicken.lib.util.Copyable;
import cofh.repack.codechicken.lib.vec.BlockCoord;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Vector3;
import java.util.Iterator;
import net.minecraft.util.AxisAlignedBB;

public class CuboidCoord
implements Iterable<BlockCoord>,
Copyable<CuboidCoord> {
    public BlockCoord min;
    public BlockCoord max;

    public CuboidCoord() {
        this.min = new BlockCoord();
        this.max = new BlockCoord();
    }

    public CuboidCoord(BlockCoord blockCoord, BlockCoord blockCoord2) {
        this.min = blockCoord;
        this.max = blockCoord2;
    }

    public CuboidCoord(BlockCoord blockCoord) {
        this(blockCoord, blockCoord.copy());
    }

    public CuboidCoord(int[] nArray) {
        this(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
    }

    public CuboidCoord(int n, int n2, int n3, int n4, int n5, int n6) {
        this(new BlockCoord(n, n2, n3), new BlockCoord(n4, n5, n6));
    }

    public CuboidCoord expand(int n) {
        return this.expand(n, n, n);
    }

    public CuboidCoord expand(int n, int n2, int n3) {
        this.max.add(n, n2, n3);
        this.min.sub(n, n2, n3);
        return this;
    }

    public CuboidCoord expand(int n, int n2) {
        if (n % 2 == 0) {
            this.min = this.min.offset(n, n2);
        } else {
            this.max = this.max.offset(n, n2);
        }
        return this;
    }

    public int size(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return this.max.y - this.min.y + 1;
            }
            case 2: 
            case 3: {
                return this.max.z - this.min.z + 1;
            }
            case 4: 
            case 5: {
                return this.max.x - this.min.x + 1;
            }
        }
        return 0;
    }

    public int getSide(int n) {
        switch (n) {
            case 0: {
                return this.min.y;
            }
            case 1: {
                return this.max.y;
            }
            case 2: {
                return this.min.z;
            }
            case 3: {
                return this.max.z;
            }
            case 4: {
                return this.min.x;
            }
            case 5: {
                return this.max.x;
            }
        }
        throw new IndexOutOfBoundsException("Switch Falloff");
    }

    public CuboidCoord setSide(int n, int n2) {
        switch (n) {
            case 0: {
                this.min.y = n2;
                break;
            }
            case 1: {
                this.max.y = n2;
                break;
            }
            case 2: {
                this.min.z = n2;
                break;
            }
            case 3: {
                this.max.z = n2;
                break;
            }
            case 4: {
                this.min.x = n2;
                break;
            }
            case 5: {
                this.max.x = n2;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Switch Falloff");
            }
        }
        return this;
    }

    public int getVolume() {
        return (this.max.x - this.min.x + 1) * (this.max.y - this.min.y + 1) * (this.max.z - this.min.z + 1);
    }

    public Vector3 getCenterVec() {
        return new Vector3((double)this.min.x + (double)(this.max.x - this.min.x + 1) / 2.0, (double)this.min.y + (double)(this.max.y - this.min.y + 1) / 2.0, (double)this.min.z + (double)(this.max.z - this.min.z + 1) / 2.0);
    }

    public BlockCoord getCenter(BlockCoord blockCoord) {
        blockCoord.set(this.min.x + (this.max.x - this.min.x) / 2, this.min.y + (this.max.y - this.min.y) / 2, this.min.z + (this.max.z - this.min.z) / 2);
        return blockCoord;
    }

    public boolean contains(BlockCoord blockCoord) {
        return this.contains(blockCoord.x, blockCoord.y, blockCoord.z);
    }

    public boolean contains(int n, int n2, int n3) {
        return n >= this.min.x && n <= this.max.x && n2 >= this.min.y && n2 <= this.max.y && n3 >= this.min.z && n3 <= this.max.z;
    }

    public int[] intArray() {
        return new int[]{this.min.x, this.min.y, this.min.z, this.max.x, this.max.y, this.max.z};
    }

    @Override
    public CuboidCoord copy() {
        return new CuboidCoord(this.min.copy(), this.max.copy());
    }

    public Cuboid6 bounds() {
        return new Cuboid6(this.min.x, this.min.y, this.min.z, this.max.x + 1, this.max.y + 1, this.max.z + 1);
    }

    public AxisAlignedBB toAABB() {
        return this.bounds().toAABB();
    }

    public void set(BlockCoord blockCoord, BlockCoord blockCoord2) {
        this.min.set(blockCoord);
        this.max.set(blockCoord2);
    }

    public CuboidCoord set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.min.set(n, n2, n3);
        this.max.set(n4, n5, n6);
        return this;
    }

    public CuboidCoord set(BlockCoord blockCoord) {
        this.min.set(blockCoord);
        this.max.set(blockCoord);
        return this;
    }

    public CuboidCoord set(int[] nArray) {
        return this.set(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
    }

    public CuboidCoord include(BlockCoord blockCoord) {
        return this.include(blockCoord.x, blockCoord.y, blockCoord.z);
    }

    public CuboidCoord include(int n, int n2, int n3) {
        if (n < this.min.x) {
            this.min.x = n;
        } else if (n > this.max.x) {
            this.max.x = n;
        }
        if (n2 < this.min.y) {
            this.min.y = n2;
        } else if (n2 > this.max.y) {
            this.max.y = n2;
        }
        if (n3 < this.min.z) {
            this.min.z = n3;
        } else if (n3 > this.max.z) {
            this.max.z = n3;
        }
        return this;
    }

    @Override
    public Iterator<BlockCoord> iterator() {
        return new Iterator<BlockCoord>(){
            BlockCoord b = null;

            @Override
            public boolean hasNext() {
                return this.b == null || !this.b.equals(CuboidCoord.this.max);
            }

            @Override
            public BlockCoord next() {
                if (this.b == null) {
                    this.b = CuboidCoord.this.min.copy();
                } else if (this.b.z != CuboidCoord.this.max.z) {
                    ++this.b.z;
                } else {
                    this.b.z = CuboidCoord.this.min.z;
                    if (this.b.y != CuboidCoord.this.max.y) {
                        ++this.b.y;
                    } else {
                        this.b.y = CuboidCoord.this.min.y;
                        ++this.b.x;
                    }
                }
                return this.b.copy();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

