/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.asm;

import cofh.repack.codechicken.lib.asm.ASMBlock;
import cofh.repack.codechicken.lib.asm.ASMHelper;
import cofh.repack.codechicken.lib.asm.InsnComparator;
import cofh.repack.codechicken.lib.asm.InsnListSection;
import cofh.repack.codechicken.lib.asm.LocalVariablesSorterVisitor;
import cofh.repack.codechicken.lib.asm.ObfMapping;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class ModularASMTransformer {
    public HashMap<String, ClassNodeTransformerList> transformers = new HashMap();

    public void add(ClassNodeTransformer classNodeTransformer) {
        ClassNodeTransformerList classNodeTransformerList = this.transformers.get(classNodeTransformer.className());
        if (classNodeTransformerList == null) {
            classNodeTransformerList = new ClassNodeTransformerList();
            this.transformers.put(classNodeTransformer.className(), classNodeTransformerList);
        }
        classNodeTransformerList.add(classNodeTransformer);
    }

    public byte[] transform(String string, byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        ClassNodeTransformerList classNodeTransformerList = this.transformers.get(string);
        return classNodeTransformerList == null ? byArray : classNodeTransformerList.transform(byArray);
    }

    public static class FieldWriter
    extends ClassNodeTransformer {
        public final ObfMapping field;
        public final int access;
        public final Object value;

        public FieldWriter(int n, ObfMapping obfMapping, Object object) {
            this.field = obfMapping.toClassloading();
            this.access = n;
            this.value = object;
        }

        public FieldWriter(int n, ObfMapping obfMapping) {
            this(n, obfMapping, null);
        }

        @Override
        public String className() {
            return this.field.javaClass();
        }

        @Override
        public void transform(ClassNode classNode) {
            this.field.visitField((ClassVisitor)classNode, this.access, this.value);
        }
    }

    public static class MethodReplacer
    extends MethodTransformer {
        public ASMBlock needle;
        public ASMBlock replacement;

        public MethodReplacer(ObfMapping obfMapping, ASMBlock aSMBlock, ASMBlock aSMBlock2) {
            super(obfMapping);
            this.needle = aSMBlock;
            this.replacement = aSMBlock2;
        }

        public MethodReplacer(ObfMapping obfMapping, InsnList insnList, InsnList insnList2) {
            this(obfMapping, new ASMBlock(insnList), new ASMBlock(insnList2));
        }

        @Override
        public void addMethodsToSort(Set<ObfMapping> set) {
            set.add(this.method);
        }

        @Override
        public void transform(MethodNode methodNode) {
            for (InsnListSection insnListSection : InsnComparator.findN(methodNode.instructions, this.needle.list)) {
                ASMHelper.logger.debug("Replacing method " + this.method + " @ " + insnListSection.start + " - " + insnListSection.end);
                ASMBlock aSMBlock = this.replacement.copy().pullLabels(this.needle.applyLabels(insnListSection));
                insnListSection.insert(aSMBlock.list.list);
            }
        }
    }

    public static class MethodInjector
    extends MethodTransformer {
        public ASMBlock needle;
        public ASMBlock injection;
        public boolean before;

        public MethodInjector(ObfMapping obfMapping, ASMBlock aSMBlock, ASMBlock aSMBlock2, boolean bl) {
            super(obfMapping);
            this.needle = aSMBlock;
            this.injection = aSMBlock2;
            this.before = bl;
        }

        public MethodInjector(ObfMapping obfMapping, ASMBlock aSMBlock, boolean bl) {
            this(obfMapping, null, aSMBlock, bl);
        }

        public MethodInjector(ObfMapping obfMapping, InsnList insnList, InsnList insnList2, boolean bl) {
            this(obfMapping, new ASMBlock(insnList), new ASMBlock(insnList2), bl);
        }

        public MethodInjector(ObfMapping obfMapping, InsnList insnList, boolean bl) {
            this(obfMapping, null, new ASMBlock(insnList), bl);
        }

        @Override
        public void addMethodsToSort(Set<ObfMapping> set) {
            set.add(this.method);
        }

        @Override
        public void transform(MethodNode methodNode) {
            if (this.needle == null) {
                ASMHelper.logger.debug("Injecting " + (this.before ? "before" : "after") + " method " + this.method);
                if (this.before) {
                    methodNode.instructions.insert(this.injection.rawListCopy());
                } else {
                    methodNode.instructions.add(this.injection.rawListCopy());
                }
            } else {
                for (InsnListSection insnListSection : InsnComparator.findN(methodNode.instructions, this.needle.list)) {
                    ASMHelper.logger.debug("Injecting " + (this.before ? "before" : "after") + " method " + this.method + " @ " + insnListSection.start + " - " + insnListSection.end);
                    ASMBlock aSMBlock = this.injection.copy().mergeLabels(this.needle.applyLabels(insnListSection));
                    if (this.before) {
                        insnListSection.insertBefore(aSMBlock.list.list);
                        continue;
                    }
                    insnListSection.insert(aSMBlock.list.list);
                }
            }
        }
    }

    public static class MethodWriter
    extends ClassNodeTransformer {
        public final int access;
        public final ObfMapping method;
        public final String[] exceptions;
        public InsnList list;

        public MethodWriter(int n, ObfMapping obfMapping) {
            this(n, obfMapping, null, (InsnList)null);
        }

        public MethodWriter(int n, ObfMapping obfMapping, InsnList insnList) {
            this(n, obfMapping, null, insnList);
        }

        public MethodWriter(int n, ObfMapping obfMapping, ASMBlock aSMBlock) {
            this(n, obfMapping, null, aSMBlock);
        }

        public MethodWriter(int n, ObfMapping obfMapping, String[] stringArray) {
            this(n, obfMapping, stringArray, (InsnList)null);
        }

        public MethodWriter(int n, ObfMapping obfMapping, String[] stringArray, InsnList insnList) {
            this.access = n;
            this.method = obfMapping.toClassloading();
            this.exceptions = stringArray;
            this.list = insnList;
        }

        public MethodWriter(int n, ObfMapping obfMapping, String[] stringArray, ASMBlock aSMBlock) {
            this(n, obfMapping, stringArray, aSMBlock.rawListCopy());
        }

        @Override
        public String className() {
            return this.method.javaClass();
        }

        @Override
        public void transform(ClassNode classNode) {
            MethodNode methodNode = ASMHelper.findMethod(this.method, classNode);
            if (methodNode == null) {
                methodNode = (MethodNode)this.method.visitMethod((ClassVisitor)classNode, this.access, this.exceptions);
            } else {
                methodNode.access = this.access;
                methodNode.instructions.clear();
                if (methodNode.localVariables != null) {
                    methodNode.localVariables.clear();
                }
                if (methodNode.tryCatchBlocks != null) {
                    methodNode.tryCatchBlocks.clear();
                }
            }
            this.write(methodNode);
        }

        public void write(MethodNode methodNode) {
            ASMHelper.logger.debug("Writing method " + this.method);
            this.list.accept((MethodVisitor)methodNode);
        }
    }

    public static abstract class MethodTransformer
    extends ClassNodeTransformer {
        public final ObfMapping method;

        public MethodTransformer(ObfMapping obfMapping) {
            this.method = obfMapping.toClassloading();
        }

        @Override
        public String className() {
            return this.method.javaClass();
        }

        @Override
        public void transform(ClassNode classNode) {
            MethodNode methodNode = ASMHelper.findMethod(this.method, classNode);
            if (methodNode == null) {
                throw new RuntimeException("Method not found: " + this.method);
            }
            try {
                this.transform(methodNode);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error transforming method: " + this.method, exception);
            }
        }

        public abstract void transform(MethodNode var1);
    }

    public static abstract class ClassNodeTransformer {
        public int writeFlags;

        public ClassNodeTransformer(int n) {
            this.writeFlags = n;
        }

        public ClassNodeTransformer() {
            this(3);
        }

        public abstract String className();

        public abstract void transform(ClassNode var1);

        public void addMethodsToSort(Set<ObfMapping> set) {
        }
    }

    public static class ClassNodeTransformerList {
        List<ClassNodeTransformer> transformers = new LinkedList<ClassNodeTransformer>();
        HashSet<ObfMapping> methodsToSort = new HashSet();

        public void add(ClassNodeTransformer classNodeTransformer) {
            this.transformers.add(classNodeTransformer);
            classNodeTransformer.addMethodsToSort(this.methodsToSort);
        }

        public byte[] transform(byte[] byArray) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(byArray);
            Object object = classNode;
            if (!this.methodsToSort.isEmpty()) {
                object = new LocalVariablesSorterVisitor(this.methodsToSort, (ClassVisitor)object);
            }
            classReader.accept((ClassVisitor)object, 8);
            try {
                int n = 0;
                for (ClassNodeTransformer classNodeTransformer : this.transformers) {
                    classNodeTransformer.transform(classNode);
                    n |= classNodeTransformer.writeFlags;
                }
                byArray = ASMHelper.createBytes(classNode, n);
                if (ASMHelper.config.getTag("dump_asm").getBooleanValue(true)) {
                    ASMHelper.dump(byArray, new File("asm/ccl_modular/" + classNode.name.replace('/', '#') + ".txt"), false, false);
                }
                return byArray;
            }
            catch (RuntimeException runtimeException) {
                ASMHelper.dump(byArray, new File("asm/ccl_modular/" + classNode.name.replace('/', '#') + ".txt"), false, false);
                throw runtimeException;
            }
        }
    }
}

