/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.asm;

import cofh.asm.LoadingPlugin;
import cofh.repack.codechicken.lib.asm.CC_ClassWriter;
import cofh.repack.codechicken.lib.asm.ImportantInsnVisitor;
import cofh.repack.codechicken.lib.asm.InsnListSection;
import cofh.repack.codechicken.lib.asm.LocalVariablesSorterVisitor;
import cofh.repack.codechicken.lib.asm.ObfMapping;
import cofh.repack.codechicken.lib.config.ConfigFile;
import cofh.repack.codechicken.lib.config.DefaultingConfigFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.util.ASMifier;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;

public class ASMHelper {
    public static ConfigFile config = ASMHelper.loadConfig();
    public static Logger logger = LogManager.getLogger((String)"CCL ASM");

    private static ConfigFile loadConfig() {
        try {
            File file = (File)((Object[])Class.forName("cpw.mods.fml.relauncher.FMLInjectionData").getMethod("data", new Class[0]).invoke(null, new Object[0]))[6];
            File file2 = new File(file, "config/CodeChickenLib.cfg");
            if (LoadingPlugin.obfuscated) {
                return new DefaultingConfigFile(file2);
            }
            return new ConfigFile(file2).setComment("CodeChickenLib development configuration file.");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static MethodNode findMethod(ObfMapping obfMapping, ClassNode classNode) {
        for (MethodNode methodNode : classNode.methods) {
            if (!obfMapping.matches(methodNode)) continue;
            return methodNode;
        }
        return null;
    }

    public static FieldNode findField(ObfMapping obfMapping, ClassNode classNode) {
        for (FieldNode fieldNode : classNode.fields) {
            if (!obfMapping.matches(fieldNode)) continue;
            return fieldNode;
        }
        return null;
    }

    public static ClassNode createClassNode(byte[] byArray) {
        return ASMHelper.createClassNode(byArray, 0);
    }

    public static ClassNode createClassNode(byte[] byArray, int n) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(byArray);
        classReader.accept((ClassVisitor)classNode, n);
        return classNode;
    }

    public static byte[] createBytes(ClassNode classNode, int n) {
        CC_ClassWriter cC_ClassWriter = new CC_ClassWriter(n);
        classNode.accept((ClassVisitor)cC_ClassWriter);
        return cC_ClassWriter.toByteArray();
    }

    public static Map<LabelNode, LabelNode> cloneLabels(InsnList insnList) {
        return new InsnListSection(insnList).cloneLabels();
    }

    public static InsnList cloneInsnList(InsnList insnList) {
        return new InsnListSection((InsnList)insnList).copy().list;
    }

    public static InsnList cloneInsnList(Map<LabelNode, LabelNode> map, InsnList insnList) {
        return new InsnListSection((InsnList)insnList).copy(map).list;
    }

    public static List<TryCatchBlockNode> cloneTryCatchBlocks(Map<LabelNode, LabelNode> map, List<TryCatchBlockNode> list) {
        ArrayList<TryCatchBlockNode> arrayList = new ArrayList<TryCatchBlockNode>();
        for (TryCatchBlockNode tryCatchBlockNode : list) {
            arrayList.add(new TryCatchBlockNode(map.get(tryCatchBlockNode.start), map.get(tryCatchBlockNode.end), map.get(tryCatchBlockNode.handler), tryCatchBlockNode.type));
        }
        return arrayList;
    }

    public static List<LocalVariableNode> cloneLocals(Map<LabelNode, LabelNode> map, List<LocalVariableNode> list) {
        ArrayList<LocalVariableNode> arrayList = new ArrayList<LocalVariableNode>(list.size());
        for (LocalVariableNode localVariableNode : list) {
            arrayList.add(new LocalVariableNode(localVariableNode.name, localVariableNode.desc, localVariableNode.signature, map.get(localVariableNode.start), map.get(localVariableNode.end), localVariableNode.index));
        }
        return arrayList;
    }

    public static void copy(MethodNode methodNode, MethodNode methodNode2) {
        Map<LabelNode, LabelNode> map = ASMHelper.cloneLabels(methodNode.instructions);
        methodNode2.instructions = ASMHelper.cloneInsnList(map, methodNode.instructions);
        methodNode2.tryCatchBlocks = ASMHelper.cloneTryCatchBlocks(map, methodNode.tryCatchBlocks);
        if (methodNode.localVariables != null) {
            methodNode2.localVariables = ASMHelper.cloneLocals(map, methodNode.localVariables);
        }
        methodNode2.visibleAnnotations = methodNode.visibleAnnotations;
        methodNode2.invisibleAnnotations = methodNode.invisibleAnnotations;
        methodNode2.visitMaxs(methodNode.maxStack, methodNode.maxLocals);
    }

    public static String toString(InsnList insnList) {
        return new InsnListSection(insnList).toString();
    }

    public static int getLocal(List<LocalVariableNode> list, String string) {
        int n = -1;
        for (LocalVariableNode localVariableNode : list) {
            if (!localVariableNode.name.equals(string)) continue;
            if (n >= 0) {
                throw new RuntimeException("Duplicate local variable: " + string + " not coded to handle this scenario.");
            }
            n = localVariableNode.index;
        }
        return n;
    }

    public static void replaceMethod(MethodNode methodNode, MethodNode methodNode2) {
        methodNode.instructions.clear();
        if (methodNode.localVariables != null) {
            methodNode.localVariables.clear();
        }
        if (methodNode.tryCatchBlocks != null) {
            methodNode.tryCatchBlocks.clear();
        }
        methodNode2.accept((MethodVisitor)methodNode);
    }

    public static void dump(Acceptor acceptor, File file, boolean bl, boolean bl2, boolean bl3) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            PrintWriter printWriter = new PrintWriter(file);
            Object object = new TraceClassVisitor(null, (Printer)(bl3 ? new Textifier() : new ASMifier()), printWriter);
            if (bl) {
                object = new ImportantInsnVisitor((ClassVisitor)object);
            }
            if (bl2) {
                object = new LocalVariablesSorterVisitor((ClassVisitor)object);
            }
            acceptor.accept((ClassVisitor)object);
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void dump(Acceptor acceptor, File file, boolean bl, boolean bl2) {
        ASMHelper.dump(acceptor, file, bl, bl2, config.getTag("textify").getBooleanValue(true));
    }

    public static void dump(final byte[] byArray, File file, boolean bl, boolean bl2) {
        ASMHelper.dump(new Acceptor(){

            @Override
            public void accept(ClassVisitor classVisitor) {
                new ClassReader(byArray).accept(classVisitor, 8);
            }
        }, file, bl, bl2);
    }

    public static void dump(final InputStream inputStream, File file, boolean bl, boolean bl2) {
        ASMHelper.dump(new Acceptor(){

            @Override
            public void accept(ClassVisitor classVisitor) throws IOException {
                new ClassReader(inputStream).accept(classVisitor, 8);
            }
        }, file, bl, bl2);
    }

    public static void dump(final ClassNode classNode, File file, boolean bl, boolean bl2) {
        ASMHelper.dump(new Acceptor(){

            @Override
            public void accept(ClassVisitor classVisitor) {
                classNode.accept(classVisitor);
            }
        }, file, bl, bl2);
    }

    public static interface Acceptor {
        public void accept(ClassVisitor var1) throws IOException;
    }
}

