/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.utils;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.Arrays;
import mods.battlegear2.Battlegear;
import mods.battlegear2.api.quiver.DispenseQuiverArrow;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.api.shield.ShieldType;
import mods.battlegear2.enchantments.BaseEnchantment;
import mods.battlegear2.heraldry.BlockFlagPole;
import mods.battlegear2.heraldry.ItemBlockFlagPole;
import mods.battlegear2.heraldry.KnightArmourRecipie;
import mods.battlegear2.heraldry.TileEntityFlagPole;
import mods.battlegear2.inventory.CreativeTabMB_B_2;
import mods.battlegear2.items.HeraldryCrest;
import mods.battlegear2.items.ItemDagger;
import mods.battlegear2.items.ItemKnightArmour;
import mods.battlegear2.items.ItemMBArrow;
import mods.battlegear2.items.ItemMace;
import mods.battlegear2.items.ItemQuiver;
import mods.battlegear2.items.ItemShield;
import mods.battlegear2.items.ItemSpear;
import mods.battlegear2.items.ItemWaraxe;
import mods.battlegear2.items.ItemWeapon;
import mods.battlegear2.recipies.DyeRecipie;
import mods.battlegear2.recipies.QuiverRecipie2;
import mods.battlegear2.recipies.ShieldRemoveArrowRecipie;
import mods.battlegear2.utils.Sheath;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BattlegearConfig {
    public static final String MODID = "battlegear2:";
    private static Configuration file;
    public static CreativeTabs customTab;
    public static Sheath forceSheath;
    public static int updateRate;
    public static boolean arrowForceRendered;
    public static boolean enableSkeletonQuiver;
    public static boolean enableGUIKeys;
    public static boolean enableGuiButtons;
    public static boolean forceHUD;
    public static final String[] itemNames;
    public static final String[] renderNames;
    public static final String[] toolTypes;
    public static final String[] shieldTypes;
    public static final String[] armourTypes;
    public static final String[] enchantsName;
    public static ItemWeapon[] dagger;
    public static ItemWeapon[] warAxe;
    public static ItemWeapon[] mace;
    public static ItemWeapon[] spear;
    public static ItemShield[] shield;
    public static Item chain;
    public static Item quiver;
    public static Item heradricItem;
    public static Item MbArrows;
    public static BlockFlagPole banner;
    public static ItemArmor[] knightArmor;
    private static String[] comments;
    public static String[] disabledItems;
    public static String[] disabledRecipies;
    public static String[] disabledRenderers;
    public static double[] skeletonArrowSpawnRate;
    public static int[] quiverBarOffset;
    public static int[] shieldBarOffset;
    public static int[] battleBarOffset;

    public static void getConfig(Configuration config) {
        int i;
        int i2;
        file = config;
        enableGUIKeys = config.get("general", "Enable GUI Keys", enableGUIKeys).getBoolean();
        enableGuiButtons = config.get("general", "Enable GUI Buttons", enableGuiButtons).getBoolean();
        updateRate = config.getInt("Update packet rate", "Server", updateRate, 1, 20000, "How often packets are sent over the network to update the battle inventory slots. Lower for faster updates, but more packets to deal for each client.");
        config.get("Coremod", "ASM debug Mode", false, "Only use for advanced bug reporting when asked by a dev.").setRequiresMcRestart(true);
        String category = "Rendering";
        config.addCustomCategoryComment(category, "This category is client side, you don't have to sync its values with server in multiplayer.");
        StringBuffer sb = new StringBuffer();
        sb.append("This will disable the special rendering for the provided item.\n");
        sb.append("These should all be placed on separate lines between the provided '<' and '>'.  \n");
        sb.append("The valid values are: \n");
        for (String renderName : renderNames) {
            sb.append(renderName);
            sb.append(", ");
        }
        BattlegearConfig.comments[2] = sb.toString();
        disabledRenderers = config.get(category, "Disabled Renderers", new String[0], comments[2]).getStringList();
        Arrays.sort(disabledRenderers);
        BattlegearConfig.comments[3] = "Change to move this bar in your gui";
        String[] pos = new String[]{"horizontal", "vertical"};
        for (i2 = 0; i2 < 2; ++i2) {
            BattlegearConfig.quiverBarOffset[i2] = config.get(category, "Quiver hotbar relative " + pos[i2] + " position", 0, comments[3]).getInt();
            BattlegearConfig.shieldBarOffset[i2] = config.get(category, "Shield bar relative " + pos[i2] + " position", 0, comments[3]).getInt();
            BattlegearConfig.battleBarOffset[i2] = config.get(category, "Offhand hotbar relative " + pos[i2] + " position", 0, comments[3]).getInt();
            BattlegearConfig.battleBarOffset[i2 + 2] = config.get(category, "Mainhand hotbar relative " + pos[i2] + " position", 0, comments[3]).getInt();
        }
        arrowForceRendered = config.get(category, "Render arrow with bow uncharged", arrowForceRendered).getBoolean();
        forceSheath = Sheath.from(config.get(category, "Default Sheath", forceSheath.toString(), "Where sheathed items are going by default", Sheath.names()).getString());
        enableSkeletonQuiver = config.get(category, "Render quiver on skeleton back", enableSkeletonQuiver).getBoolean();
        forceHUD = config.get(category, "Force screen components rendering", forceHUD).getBoolean();
        category = "Skeleton CustomArrow Spawn Rate";
        config.addCustomCategoryComment(category, "The spawn rate (between 0 & 1) that Skeletons will spawn with Arrows provided from this mod");
        for (i2 = 0; i2 < ItemMBArrow.names.length; ++i2) {
            BattlegearConfig.skeletonArrowSpawnRate[i2] = config.get(category, ItemMBArrow.names[i2], i2 != 1 && i2 != 5 ? 0.1 : 0.0, "", 0.0, 1.0).setRequiresMcRestart(true).getDouble();
        }
        sb = new StringBuffer();
        sb.append("This will disable completely the provided item, along with their renderers and recipes including them.\n");
        sb.append("These should all be placed on separate lines between the provided '<' and '>'.  \n");
        sb.append("The valid values are: \n");
        int count = 0;
        for (String itemName : itemNames) {
            sb.append(itemName);
            sb.append(", ");
            if (++count % 5 != 0) continue;
            sb.append("\n");
        }
        BattlegearConfig.comments[0] = sb.toString();
        disabledItems = config.get("general", "Disabled Items", new String[0], comments[0]).setRequiresMcRestart(true).getStringList();
        if (Arrays.deepEquals(disabledItems, itemNames)) {
            return;
        }
        Arrays.sort(disabledItems);
        customTab = new CreativeTabMB_B_2("Battlegear2");
        if (Arrays.binarySearch(disabledItems, itemNames[0]) < 0) {
            heradricItem = new HeraldryCrest().func_77637_a(customTab).func_77655_b(MODID + itemNames[0]).func_111206_d("battlegear2:bg-icon");
        }
        if (Arrays.binarySearch(disabledItems, itemNames[10]) < 0) {
            banner = (BlockFlagPole)new BlockFlagPole().func_149647_a(customTab).func_149663_c(MODID + itemNames[10]);
            GameRegistry.registerBlock((Block)banner, ItemBlockFlagPole.class, (String)itemNames[10]);
            GameRegistry.registerTileEntity(TileEntityFlagPole.class, (String)(MODID + itemNames[10]));
        }
        if (Arrays.binarySearch(disabledItems, itemNames[1]) < 0) {
            chain = new Item().func_77655_b(MODID + itemNames[1]).func_111206_d(MODID + itemNames[1]).func_77637_a(customTab);
        }
        if (Arrays.binarySearch(disabledItems, itemNames[2]) < 0) {
            quiver = new ItemQuiver().func_77655_b(MODID + itemNames[2]).func_111206_d("battlegear2:quiver/" + itemNames[2]).func_77637_a(customTab);
            BlockDispenser.field_149943_a.func_82595_a((Object)quiver, (Object)new DispenseQuiverArrow((Item)Items.field_151031_f, 1.0f));
        }
        if (Arrays.binarySearch(disabledItems, itemNames[9]) < 0) {
            MbArrows = new ItemMBArrow().func_77655_b(MODID + itemNames[9]).func_111206_d(MODID + itemNames[9]).func_77637_a(customTab).func_77642_a(Items.field_151032_g);
            for (int i3 = 0; i3 < ItemMBArrow.arrows.length; ++i3) {
                QuiverArrowRegistry.addArrowToRegistry(MbArrows, i3, ItemMBArrow.arrows[i3]);
            }
            BlockDispenser.field_149943_a.func_82595_a((Object)MbArrows, (Object)ItemMBArrow.dispensable);
        }
        sb = new StringBuffer();
        sb.append("This will disable the crafting recipe for the provided item/blocks.\n");
        sb.append("It should be noted that this WILL NOT remove the item from the game, it will only disable the recipe.\n");
        sb.append("In this way the items may still be obtained through creative mode and cheats, but players will be unable to craft them.\n");
        sb.append("These should all be placed on separate lines between the provided '<' and '>'. The valid values are: \n");
        count = 0;
        for (i = 1; i < itemNames.length; ++i) {
            if (i == 9) continue;
            sb.append(itemNames[i]);
            sb.append(", ");
            if (++count % 5 != 0) continue;
            sb.append("\n");
        }
        for (i = 0; i < ItemMBArrow.names.length; ++i) {
            sb.append(itemNames[9]);
            sb.append('.');
            sb.append(ItemMBArrow.names[i]);
            sb.append(", ");
            if (++count % 5 != 0) continue;
            sb.append("\n");
        }
        sb.append("chain.armour");
        BattlegearConfig.comments[1] = sb.toString();
        disabledRecipies = config.get("general", "Disabled Recipies", new String[0], comments[1]).setRequiresMcRestart(true).getStringList();
        Arrays.sort(disabledRecipies);
        ShieldType[] types = new ShieldType[]{ShieldType.WOOD, ShieldType.HIDE, ShieldType.IRON, ShieldType.DIAMOND, ShieldType.GOLD};
        for (int i4 = 0; i4 < 5; ++i4) {
            Item.ToolMaterial material = Item.ToolMaterial.values()[i4];
            if (Arrays.binarySearch(disabledItems, itemNames[4]) < 0) {
                BattlegearConfig.warAxe[i4] = new ItemWaraxe(material, itemNames[4], i4 == 4 ? 2 : 1);
            }
            if (Arrays.binarySearch(disabledItems, itemNames[3]) < 0) {
                BattlegearConfig.dagger[i4] = new ItemDagger(material, itemNames[3], 0.5f, -2.0f);
            }
            if (Arrays.binarySearch(disabledItems, itemNames[5]) < 0) {
                BattlegearConfig.mace[i4] = new ItemMace(material, itemNames[5], 0.05f + 0.05f * (float)i4);
            }
            if (Arrays.binarySearch(disabledItems, itemNames[6]) < 0) {
                BattlegearConfig.spear[i4] = new ItemSpear(material, itemNames[6], 3, 2.0f);
            }
            if (Arrays.binarySearch(disabledItems, itemNames[7]) < 0) {
                BattlegearConfig.shield[i4] = new ItemShield(types[i4]);
                if (i4 == 0) {
                    GameRegistry.registerFuelHandler((IFuelHandler)shield[i4]);
                }
            }
            if (i4 == 4 || Arrays.binarySearch(disabledItems, itemNames[8]) >= 0) continue;
            BattlegearConfig.knightArmor[i4] = new ItemKnightArmour(i4);
        }
        try {
            for (Field f : BattlegearConfig.class.getFields()) {
                Item it;
                if (!Item.class.isAssignableFrom(f.getType()) || (it = (Item)f.get(null)) == null) continue;
                GameRegistry.registerItem((Item)it, (String)it.func_77658_a().replace("item.", "").replace(MODID, "").trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerRecipes() {
        int i;
        file.addCustomCategoryComment("EnchantmentsID", "Values should be between 0 and " + (Enchantment.field_77331_b.length - 1) + ", or the enchantment will be disabled");
        Property[] props = new Property[enchantsName.length];
        for (int i2 = 0; i2 < enchantsName.length; ++i2) {
            props[i2] = file.get("EnchantmentsID", enchantsName[i2], 125 + i2).setRequiresMcRestart(true);
        }
        BaseEnchantment.initBase(props);
        if (file.hasChanged()) {
            file.save();
        }
        if (chain != null) {
            if (Arrays.binarySearch(disabledRecipies, itemNames[1]) < 0) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(chain, 3), new Object[]{"I", "I", Character.valueOf('I'), "ingotIron"}));
            }
            if (Arrays.binarySearch(disabledRecipies, "chain.armour") < 0) {
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151020_U), (Object[])new Object[]{"LLL", "L L", Character.valueOf('L'), chain});
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151023_V), (Object[])new Object[]{"L L", "LLL", "LLL", Character.valueOf('L'), chain});
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151022_W), (Object[])new Object[]{"LLL", "L L", "L L", Character.valueOf('L'), chain});
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151029_X), (Object[])new Object[]{"L L", "L L", Character.valueOf('L'), chain});
            }
        }
        if (quiver != null) {
            if (Arrays.binarySearch(disabledRecipies, itemNames[2]) < 0) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(quiver), new Object[]{"X X", "X X", "XXX", Character.valueOf('X'), Items.field_151116_aA}));
            }
            RecipeSorter.register((String)"battlegear:quiverfilling", QuiverRecipie2.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            GameRegistry.addRecipe((IRecipe)new QuiverRecipie2());
        }
        RecipeSorter.register((String)"battlegear:dyeing", DyeRecipie.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        GameRegistry.addRecipe((IRecipe)new DyeRecipie());
        String woodStack = "plankWood";
        for (i = 0; i < 5; ++i) {
            ItemStack craftingMaterial = new ItemStack(Item.ToolMaterial.values()[i].func_150995_f(), 1, Short.MAX_VALUE);
            if (dagger[i] != null && Arrays.binarySearch(disabledRecipies, itemNames[3]) < 0) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)dagger[i]), new Object[]{"L", "S", Character.valueOf('S'), "stickWood", Character.valueOf('L'), i != 0 ? craftingMaterial : woodStack}));
            }
            if (warAxe[i] != null && Arrays.binarySearch(disabledRecipies, itemNames[4]) < 0) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)warAxe[i]), new Object[]{"L L", "LSL", " S ", Character.valueOf('S'), "stickWood", Character.valueOf('L'), i != 0 ? craftingMaterial : woodStack}));
            }
            if (mace[i] != null && Arrays.binarySearch(disabledRecipies, itemNames[5]) < 0) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)mace[i]), new Object[]{" LL", " LL", "S  ", Character.valueOf('S'), "stickWood", Character.valueOf('L'), i != 0 ? craftingMaterial : woodStack}));
            }
            if (spear[i] == null || Arrays.binarySearch(disabledRecipies, itemNames[6]) >= 0) continue;
            if (i == 0) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)spear[i]), new Object[]{"  S", " S ", "S  ", Character.valueOf('S'), "stickWood"}));
                continue;
            }
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)spear[i]), (Object[])new Object[]{" L", "S ", Character.valueOf('S'), spear[0], Character.valueOf('L'), craftingMaterial});
        }
        if (Arrays.binarySearch(disabledItems, itemNames[7]) < 0 && Arrays.binarySearch(disabledRecipies, itemNames[7]) < 0) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)shield[0]), new Object[]{" W ", "WWW", " W ", Character.valueOf('W'), woodStack}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)shield[1]), new Object[]{" H ", "HWH", " H ", Character.valueOf('W'), woodStack, Character.valueOf('H'), Items.field_151116_aA}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)shield[2]), new Object[]{"I I", "IWI", " I ", Character.valueOf('W'), woodStack, Character.valueOf('I'), "ingotIron"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)shield[3]), new Object[]{"I I", "IWI", " I ", Character.valueOf('W'), woodStack, Character.valueOf('I'), "gemDiamond"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)shield[4]), new Object[]{"I I", "IWI", " I ", Character.valueOf('W'), woodStack, Character.valueOf('I'), "ingotGold"}));
            RecipeSorter.register((String)"battlegear:shieldarrowtaking", ShieldRemoveArrowRecipie.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            GameRegistry.addRecipe((IRecipe)new ShieldRemoveArrowRecipie());
        }
        if (Arrays.binarySearch(disabledItems, itemNames[8]) < 0 && Arrays.binarySearch(disabledRecipies, itemNames[8]) < 0) {
            RecipeSorter.register((String)"battlegear:knightarmor", KnightArmourRecipie.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            for (i = 0; i < 4; ++i) {
                GameRegistry.addRecipe((IRecipe)new KnightArmourRecipie(i));
            }
        }
        if (MbArrows != null) {
            for (i = 0; i < ItemMBArrow.component.length; ++i) {
                if (Arrays.binarySearch(disabledRecipies, itemNames[9] + "." + ItemMBArrow.names[i]) >= 0) continue;
                GameRegistry.addRecipe((ItemStack)new ItemStack(MbArrows, 1, i), (Object[])new Object[]{"G", "A", Character.valueOf('G'), ItemMBArrow.component[i], Character.valueOf('A'), Items.field_151032_g});
                if (i == 2 || i == 3) continue;
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(ItemMBArrow.component[i]), (Object[])new Object[]{new ItemStack(MbArrows, 1, i)});
            }
        }
        if (banner != null && Arrays.binarySearch(disabledRecipies, itemNames[10]) < 0) {
            for (i = 0; i < 7; ++i) {
                Object temp = i < 4 ? new ItemStack(Blocks.field_150364_r, 1, i) : (i == 4 ? "ingotIron" : new ItemStack(Blocks.field_150363_s, 1, i - 5));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)banner, 4, i), new Object[]{"W", "W", "W", Character.valueOf('W'), temp}));
            }
        }
    }

    public static void refreshConfig() {
        try {
            Arrays.sort(disabledRenderers);
            file.get("Rendering", "Disabled Renderers", new String[0], comments[2]).set(disabledRenderers);
            file.get("Rendering", "Render arrow with bow uncharged", true).set(arrowForceRendered);
            file.get("Rendering", "Default Sheath", Sheath.HIP.toString()).set(forceSheath.toString());
            file.get("Rendering", "Render quiver on skeleton back", true).set(enableSkeletonQuiver);
            file.get("Rendering", "Force screen components rendering", false).set(forceHUD);
            file.get("general", "Enable GUI Keys", false).set(enableGUIKeys);
            file.get("general", "Enable GUI Buttons", true).set(enableGuiButtons);
            file.save();
            Battlegear.proxy.registerItemRenderers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void refreshGuiValues() {
        try {
            String[] pos = new String[]{"horizontal", "vertical"};
            for (int i = 0; i < 2; ++i) {
                file.get("Rendering", "Quiver hotbar relative " + pos[i] + " position", 0, comments[3]).set(quiverBarOffset[i]);
                file.get("Rendering", "Shield bar relative " + pos[i] + " position", 0, comments[3]).set(shieldBarOffset[i]);
                file.get("Rendering", "Offhand hotbar relative " + pos[i] + " position", 0, comments[3]).set(battleBarOffset[i]);
                file.get("Rendering", "Mainhand hotbar relative " + pos[i] + " position", 0, comments[3]).set(battleBarOffset[i + 2]);
            }
            file.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean remap(FMLMissingMappingsEvent.MissingMapping mapping) {
        if (mapping.type == GameRegistry.Type.ITEM && mapping.name.contains("item.battlegear2:")) {
            for (ItemShield itemShield : shield) {
                if (itemShield == null || !mapping.name.contains(itemShield.func_77658_a().substring(5))) continue;
                mapping.remap((Item)itemShield);
                return true;
            }
            for (ItemShield itemShield : knightArmor) {
                if (itemShield == null || !mapping.name.contains(itemShield.func_77658_a().substring(5))) continue;
                mapping.remap((Item)itemShield);
                return true;
            }
            try {
                for (Field field : BattlegearConfig.class.getFields()) {
                    Item it;
                    if (!Item.class.isAssignableFrom(field.getType()) || (it = (Item)field.get(null)) == null || !mapping.name.contains(it.func_77658_a().substring(5))) continue;
                    mapping.remap(it);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mapping.name.contains("battlegear2:battlegear2:flagpole") && banner != null) {
            if (mapping.type == GameRegistry.Type.ITEM) {
                mapping.remap(Item.func_150898_a((Block)banner));
            } else {
                mapping.remap((Block)banner);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean initItemFromNBT(NBTTagCompound nbtValue) {
        if (!nbtValue.func_74764_b("Item") || !nbtValue.func_74764_b("Material") || !nbtValue.func_74764_b("Name")) return false;
        String type = nbtValue.func_74779_i("Item");
        String name = nbtValue.func_74779_i("Name");
        if (type.equals("") || name.equals("")) {
            return false;
        }
        try {
            void var3_9;
            Object var3_3 = null;
            if (type.equalsIgnoreCase("Shield")) {
                ShieldType shieldType = null;
                if (nbtValue.func_150297_b("Material", 10)) {
                    shieldType = ShieldType.fromNBT(nbtValue.func_74775_l("Material"));
                }
                if (shieldType == null) return false;
                ItemShield itemShield = new ItemShield(shieldType);
            } else if (nbtValue.func_150297_b("Material", 8)) {
                Item.ToolMaterial material = Item.ToolMaterial.valueOf((String)nbtValue.func_74779_i("Material"));
                if (type.equalsIgnoreCase("Dagger")) {
                    float hitTime = nbtValue.func_74760_g("Time");
                    float reach = nbtValue.func_74760_g("Reach");
                    ItemDagger itemDagger = new ItemDagger(material, name, hitTime, reach);
                } else if (type.equalsIgnoreCase("Mace")) {
                    float stun = nbtValue.func_74760_g("Stun");
                    ItemMace itemMace = new ItemMace(material, name, stun);
                } else if (type.equalsIgnoreCase("Spear")) {
                    int mount = nbtValue.func_74762_e("Mount");
                    float reach = nbtValue.func_74760_g("Reach");
                    ItemSpear itemSpear = new ItemSpear(material, name, mount, reach);
                } else if (type.equalsIgnoreCase("Waraxe")) {
                    int penetrate = nbtValue.func_74762_e("Penetration");
                    ItemWaraxe itemWaraxe = new ItemWaraxe(material, name, penetrate);
                }
            }
            if (var3_9 == null) return false;
            if (nbtValue.func_74764_b("UnlocalizedName")) {
                var3_9.func_77655_b(nbtValue.func_74779_i("UnlocalizedName"));
            }
            if (nbtValue.func_74764_b("TextureName")) {
                var3_9.func_111206_d(nbtValue.func_74779_i("TextureName"));
            }
            if (nbtValue.func_74764_b("MaxDamage")) {
                var3_9.func_77656_e(nbtValue.func_74762_e("MaxDamage"));
            }
            if (!nbtValue.func_74764_b("StackSize")) return true;
            var3_9.func_77625_d(nbtValue.func_74762_e("StackSize"));
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static Item findNonNullItemIcon() {
        if (heradricItem != null) {
            return heradricItem;
        }
        if (chain != null) {
            return chain;
        }
        if (quiver != null) {
            return quiver;
        }
        if (MbArrows != null) {
            return MbArrows;
        }
        for (ItemShield i : shield) {
            if (i == null) continue;
            return i;
        }
        return Items.field_151031_f;
    }

    static {
        forceSheath = Sheath.HIP;
        updateRate = 20;
        arrowForceRendered = true;
        enableSkeletonQuiver = true;
        enableGUIKeys = false;
        enableGuiButtons = true;
        forceHUD = false;
        itemNames = new String[]{"heraldric", "chain", "quiver", "dagger", "waraxe", "mace", "spear", "shield", "knight.armour", "mb.arrow", "flagpole"};
        renderNames = new String[]{"spear", "shield", "bow", "quiver", "flagpole"};
        toolTypes = new String[]{"wood", "stone", "iron", "diamond", "gold"};
        shieldTypes = new String[]{"wood", "hide", "iron", "diamond", "gold"};
        armourTypes = new String[]{"helmet", "plate", "legs", "boots"};
        enchantsName = new String[]{"BashWeight", "BashPower", "BashDamage", "ShieldUsage", "ShieldRecovery", "BowLoot", "BowCharge"};
        dagger = new ItemWeapon[toolTypes.length];
        warAxe = new ItemWeapon[toolTypes.length];
        mace = new ItemWeapon[toolTypes.length];
        spear = new ItemWeapon[toolTypes.length];
        shield = new ItemShield[shieldTypes.length];
        knightArmor = new ItemArmor[armourTypes.length];
        comments = new String[4];
        disabledItems = new String[0];
        disabledRecipies = new String[0];
        disabledRenderers = new String[0];
        skeletonArrowSpawnRate = new double[ItemMBArrow.names.length];
        quiverBarOffset = new int[2];
        shieldBarOffset = new int[2];
        battleBarOffset = new int[4];
    }
}

