/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.item;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.energy.subgrid.SubTileEnergyEnder;
import cofh.thermaldynamics.duct.item.TileItemDuct;
import cofh.thermaldynamics.duct.item.TileItemDuctPowered;
import cofh.thermaldynamics.duct.item.TravelingItem;
import net.minecraft.tileentity.TileEntity;

public class TileItemDuctEnder
extends TileItemDuctPowered {
    public boolean powered = false;
    final SubTileEnergyEnder enderEnergy = new SubTileEnergyEnder(this);

    public TileItemDuctEnder() {
        this.setSubEnergy(this.enderEnergy);
    }

    @Override
    public void transferItem(TravelingItem travelingItem) {
        super.transferItem(travelingItem);
    }

    @Override
    public int getPipeLength() {
        return this.isPowered() ? 1 : 60;
    }

    @Override
    public int getPipeHalfLength() {
        return this.isPowered() ? 1 : 30;
    }

    @Override
    public float[][] getSideCoordsModifier() {
        return TileItemDuct._SIDE_MODS[this.isPowered() ? 3 : 2];
    }

    @Override
    public boolean acceptingItems() {
        return this.enderEnergy.internalGrid != null && this.enderEnergy.internalGrid.isPowered();
    }

    @Override
    public boolean isSubNode() {
        return true;
    }

    @Override
    public void tickItems() {
        if (this.itemsToAdd.size() > 0) {
            for (TravelingItem travelingItem : this.itemsToAdd) {
                this.myItems.add(travelingItem);
            }
            this.itemsToAdd.clear();
            this.hasChanged = true;
        }
        if (this.myItems.size() > 0) {
            for (TravelingItem travelingItem : this.myItems) {
                if (this.internalGrid.repoll) {
                    this.internalGrid.poll(travelingItem);
                }
                if (travelingItem.reRoute || travelingItem.myPath == null) {
                    travelingItem.bounceItem(this);
                    continue;
                }
                if (this.energy.energyGrid != null && this.energy.energyGrid.myStorage.getEnergyStored() >= 50 && this.energy.energyGrid.myStorage.extractEnergy(50, true) >= 50) {
                    this.energy.energyGrid.myStorage.extractEnergy(50, false);
                    this.multiAdvance(travelingItem, false);
                    continue;
                }
                travelingItem.tickForward(this);
            }
            if (this.itemsToRemove.size() > 0) {
                this.myItems.removeAll(this.itemsToRemove);
                this.itemsToRemove.clear();
                this.hasChanged = true;
            }
        }
        if (this.hasChanged) {
            this.internalGrid.shouldRepoll = true;
        }
        this.updateRender();
    }

    @Override
    public void insertNewItem(TravelingItem travelingItem) {
        if (this.energy.energyGrid != null && this.energy.energyGrid.myStorage.getEnergyStored() >= 50 && this.energy.energyGrid.myStorage.extractEnergy(50, true) >= 50) {
            this.energy.energyGrid.myStorage.extractEnergy(50, false);
            this.multiAdvance(travelingItem, true);
        } else {
            super.insertNewItem(travelingItem);
        }
    }

    public void multiAdvance(TravelingItem travelingItem, boolean bl) {
        TileItemDuct tileItemDuct;
        block6: {
            block7: {
                tileItemDuct = this;
                do {
                    tileItemDuct.pulseLine(travelingItem.direction, (byte)(travelingItem.oldDirection ^ 1));
                    if (tileItemDuct.neighborTypes[travelingItem.direction] != TileTDBase.NeighborTypes.MULTIBLOCK) break block6;
                    TileItemDuct tileItemDuct2 = (TileItemDuct)tileItemDuct.getConnectedSide(travelingItem.direction);
                    if (tileItemDuct2 == null || tileItemDuct2.neighborTypes[travelingItem.direction ^ 1] != TileTDBase.NeighborTypes.MULTIBLOCK) break block7;
                    tileItemDuct = tileItemDuct2;
                    if (!travelingItem.myPath.hasNextDirection()) {
                        travelingItem.reRoute = true;
                        this.transferItem(travelingItem, tileItemDuct, bl);
                        return;
                    }
                    travelingItem.oldDirection = travelingItem.direction;
                    travelingItem.direction = travelingItem.myPath.getNextDirection();
                } while (tileItemDuct.getClass() == TileItemDuctEnder.class);
                this.transferItem(travelingItem, tileItemDuct, bl);
                return;
            }
            travelingItem.reRoute = true;
            this.transferItem(travelingItem, tileItemDuct, bl);
            return;
        }
        if (tileItemDuct.neighborTypes[travelingItem.direction] == TileTDBase.NeighborTypes.OUTPUT) {
            travelingItem.stack.field_77994_a = tileItemDuct.insertIntoInventory(travelingItem.stack, travelingItem.direction);
            if (travelingItem.stack.field_77994_a > 0) {
                travelingItem.reRoute = true;
                this.transferItem(travelingItem, tileItemDuct, bl);
            } else if (!bl) {
                this.itemsToRemove.add(travelingItem);
            }
            return;
        }
        travelingItem.reRoute = true;
        this.transferItem(travelingItem, tileItemDuct, bl);
    }

    public void transferItem(TravelingItem travelingItem, TileItemDuct tileItemDuct, boolean bl) {
        if (bl) {
            this.internalGrid.shouldRepoll = true;
            tileItemDuct.transferItem(travelingItem);
        } else if (tileItemDuct != this) {
            tileItemDuct.transferItem(travelingItem);
            this.itemsToRemove.add(travelingItem);
        }
    }

    public void sendPowerPacket() {
        PacketTileInfo packetTileInfo = PacketTileInfo.newPacket((TileEntity)this);
        packetTileInfo.addByte(0);
        packetTileInfo.addByte((byte)6);
        packetTileInfo.addBool(this.powered);
        PacketHandler.sendToAllAround((PacketBase)packetTileInfo, (TileEntity)this);
    }

    @Override
    public void handlePacketType(PacketCoFHBase packetCoFHBase, int n) {
        if (n == 6) {
            this.powered = packetCoFHBase.getBool();
            this.centerLine = 0;
            for (int i = 0; i < this.centerLineSub.length; ++i) {
                this.centerLineSub[i] = 0;
            }
        } else {
            super.handlePacketType(packetCoFHBase, n);
        }
    }

    @Override
    public boolean shouldRenderInPass(int n) {
        return n == 0 && (this.powered || super.shouldRenderInPass(n));
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addBool(this.isPowered());
        return packetCoFHBase;
    }

    public boolean isPowered() {
        return this.enderEnergy.internalGrid != null ? this.enderEnergy.internalGrid.isPowered() : this.powered;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.powered = packetCoFHBase.getBool();
    }

    public void updateRender() {
        if (this.enderEnergy.internalGrid != null && this.enderEnergy.internalGrid.isPowered() != this.powered) {
            this.powered = this.enderEnergy.internalGrid.isPowered();
            this.sendPowerPacket();
        }
        if (!this.powered && this.hasChanged) {
            this.hasChanged = false;
            this.sendTravelingItemsPacket();
        }
    }
}

