/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.energy;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.energy.EnergyGrid;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyDuct
extends TileTDBase
implements IEnergyHandler {
    public int energyForGrid = 0;
    public int lastStoredValue = 0;
    EnergyGrid internalGrid;
    IEnergyReceiver[] cache;

    @Override
    public void setGrid(MultiBlockGrid multiBlockGrid) {
        super.setGrid(multiBlockGrid);
        this.internalGrid = (EnergyGrid)multiBlockGrid;
    }

    @Override
    public MultiBlockGrid getNewGrid() {
        return new EnergyGrid(((TileEntity)this).field_145850_b, this.getDuctType().type);
    }

    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        return this.connectionTypes[forgeDirection.ordinal()] != TileTDBase.ConnectionTypes.BLOCKED;
    }

    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.internalGrid != null && this.canConnectEnergy(forgeDirection) ? this.internalGrid.myStorage.receiveEnergy(n, bl) : 0;
    }

    public int extractEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.internalGrid != null && this.canConnectEnergy(forgeDirection) ? this.internalGrid.myStorage.extractEnergy(n, bl) : 0;
    }

    public int getEnergyStored(ForgeDirection forgeDirection) {
        return this.internalGrid != null ? this.internalGrid.myStorage.getEnergyStored() : 0;
    }

    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return this.internalGrid != null ? this.internalGrid.myStorage.getMaxEnergyStored() : 0;
    }

    @Override
    public boolean isConnectable(TileEntity tileEntity, int n) {
        return tileEntity instanceof TileEnergyDuct && ((TileEnergyDuct)tileEntity).getDuctType().type == this.getDuctType().type;
    }

    @Override
    public boolean isSignificantTile(TileEntity tileEntity, int n) {
        return tileEntity instanceof IEnergyConnection && ((IEnergyConnection)tileEntity).canConnectEnergy(ForgeDirection.VALID_DIRECTIONS[n ^ 1]);
    }

    @Override
    public void tileUnloading() {
        if (this.isNode) {
            this.internalGrid.myStorage.extractEnergy(this.lastStoredValue, false);
        }
    }

    @Override
    public boolean tickPass(int n) {
        if (!super.tickPass(n)) {
            return false;
        }
        int n2 = this.internalGrid.getSendableEnergy();
        int n3 = this.transmitEnergy(n2, false);
        this.internalGrid.useEnergy(n3);
        return true;
    }

    public int transmitEnergy(int n, boolean bl) {
        byte by;
        int n2 = 0;
        if (!this.cachesExist()) {
            return n2;
        }
        for (by = this.internalSideCounter; by < this.neighborTypes.length && n2 < n; by = (byte)(by + 1)) {
            if (this.neighborTypes[by] != TileTDBase.NeighborTypes.OUTPUT || this.connectionTypes[by] != TileTDBase.ConnectionTypes.NORMAL || this.cache[by] == null) continue;
            if (this.cache[by].canConnectEnergy(ForgeDirection.VALID_DIRECTIONS[by ^ 1])) {
                n2 += this.cache[by].receiveEnergy(ForgeDirection.VALID_DIRECTIONS[by ^ 1], n - n2, bl);
            }
            if (bl || n2 < n) continue;
            this.tickInternalSideCounter(by + 1);
            break;
        }
        for (by = 0; by < this.internalSideCounter && n2 < n; by = (byte)(by + 1)) {
            if (this.neighborTypes[by] != TileTDBase.NeighborTypes.OUTPUT || this.connectionTypes[by] != TileTDBase.ConnectionTypes.NORMAL || this.cache[by] == null) continue;
            if (this.cache[by].canConnectEnergy(ForgeDirection.VALID_DIRECTIONS[by ^ 1])) {
                n2 += this.cache[by].receiveEnergy(ForgeDirection.VALID_DIRECTIONS[by ^ 1], n - n2, bl);
            }
            if (bl || n2 < n) continue;
            this.tickInternalSideCounter(by + 1);
            break;
        }
        return n2;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.energyForGrid = nBTTagCompound.func_74762_e("Energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        if (this.internalGrid != null) {
            if (this.isNode) {
                this.lastStoredValue = this.internalGrid.getNodeShare(this);
                nBTTagCompound.func_74768_a("Energy", this.lastStoredValue);
            }
        } else if (this.energyForGrid > 0) {
            nBTTagCompound.func_74768_a("Energy", this.energyForGrid);
        } else {
            this.energyForGrid = 0;
        }
    }

    @Override
    public boolean cachesExist() {
        return this.cache != null;
    }

    @Override
    public void cacheImportant(TileEntity tileEntity, int n) {
        if (tileEntity instanceof IEnergyReceiver) {
            this.cache[n] = (IEnergyReceiver)tileEntity;
        }
    }

    @Override
    public void createCaches() {
        this.cache = new IEnergyReceiver[6];
    }

    @Override
    public void clearCache(int n) {
        this.cache[n] = null;
    }
}

