/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.core;

import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import net.minecraft.world.World;

public class WorldGridList {
    public World worldObj;
    public LinkedHashSet<MultiBlockGrid> tickingGrids = new LinkedHashSet();
    public LinkedHashSet<IMultiBlock> tickingBlocks = new LinkedHashSet();
    public LinkedHashSet<MultiBlockGrid> gridsToRecreate = new LinkedHashSet();
    public LinkedHashSet<MultiBlockGrid> newGrids = new LinkedHashSet();
    public LinkedHashSet<MultiBlockGrid> oldGrids = new LinkedHashSet();

    public WorldGridList(World world) {
        this.worldObj = world;
    }

    public void tickStart() {
        if (!this.newGrids.isEmpty()) {
            this.tickingGrids.addAll(this.newGrids);
            this.newGrids.clear();
        }
        if (!this.oldGrids.isEmpty()) {
            this.tickingGrids.removeAll(this.oldGrids);
            this.oldGrids.clear();
        }
    }

    public void tickEnd() {
        if (!this.gridsToRecreate.isEmpty()) {
            this.tickingGrids.removeAll(this.gridsToRecreate);
            for (MultiBlockGrid object : this.gridsToRecreate) {
                for (IMultiBlock iMultiBlock : object.idleSet) {
                    this.tickingBlocks.add(iMultiBlock);
                    object.destroyNode(iMultiBlock);
                }
                for (IMultiBlock iMultiBlock : object.nodeSet) {
                    this.tickingBlocks.add(iMultiBlock);
                    object.destroyNode(iMultiBlock);
                }
            }
            this.gridsToRecreate.clear();
        }
        ArrayList arrayList = new ArrayList();
        for (MultiBlockGrid multiBlockGrid : this.tickingGrids) {
            multiBlockGrid.tickGrid();
            if (!multiBlockGrid.isTickProcessing()) continue;
            arrayList.add(multiBlockGrid);
        }
        if (!arrayList.isEmpty()) {
            long iterator = System.nanoTime() + 100000L;
            int n = arrayList.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                ((MultiBlockGrid)arrayList.get(i)).doTickProcessing(iterator);
                if (n2++ != 7) continue;
                if (System.nanoTime() > iterator) break;
                n2 = 0;
            }
        }
        if (!this.tickingBlocks.isEmpty()) {
            Iterator iterator = this.tickingBlocks.iterator();
            while (iterator.hasNext()) {
                IMultiBlock iMultiBlock = (IMultiBlock)iterator.next();
                if (!iMultiBlock.existsYet()) continue;
                iMultiBlock.tickMultiBlock();
                iterator.remove();
            }
        }
    }
}

