/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.recipe.NumberedOreDictStack;
import zmaster587.libVulpes.recipe.RecipesMachine;
import zmaster587.libVulpes.tile.TileEntityMachine;

public class XMLRecipeLoader {
    Document doc = null;
    String fileName = "";

    public boolean loadFile(File xmlFile) throws IOException {
        DocumentBuilder docBuilder;
        this.doc = null;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        try {
            this.doc = docBuilder.parse(xmlFile);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        this.fileName = xmlFile.getAbsolutePath();
        return true;
    }

    public void registerRecipes(Class<? extends TileEntityMachine> clazz) {
        Node defaultNode;
        Node masterNode = this.doc.getElementsByTagName("Recipes").item(0);
        int recipeNum = 1;
        if (masterNode.hasAttributes() && (defaultNode = masterNode.getAttributes().getNamedItem("useDefault")) != null && defaultNode.getNodeValue().equals("false")) {
            RecipesMachine.getInstance().clearRecipes(clazz);
        }
        masterNode = masterNode.getChildNodes().item(1);
        while (masterNode != null) {
            try {
                int time = 200;
                int energy = 0;
                if (masterNode.getNodeType() != 1) {
                    masterNode = masterNode.getNextSibling();
                    continue;
                }
                if (!masterNode.getNodeName().equals("Recipe")) {
                    LibVulpes.logger.warning("Expected \"Recipe\" Node in " + this.fileName + ", found " + masterNode.getNodeName() + "!  Skipping.");
                    masterNode = masterNode.getNextSibling();
                    continue;
                }
                Node inputNode = null;
                Node outputNode = null;
                for (int i = 0; i < masterNode.getChildNodes().getLength(); ++i) {
                    Node node = masterNode.getChildNodes().item(i);
                    if (node.getNodeName().equals("input")) {
                        inputNode = node;
                        continue;
                    }
                    if (!node.getNodeName().equals("output")) continue;
                    outputNode = node;
                }
                if (outputNode == null) {
                    masterNode = masterNode.getNextSibling();
                    LibVulpes.logger.warning("Missing \"output\" Node in recipe " + recipeNum + " in " + this.fileName + "!  Skipping.");
                    ++recipeNum;
                    continue;
                }
                if (inputNode == null) {
                    masterNode = masterNode.getNextSibling();
                    LibVulpes.logger.warning("Missing \"input\" Node in recipe " + recipeNum + " in " + this.fileName + "!  Skipping.");
                    ++recipeNum;
                    continue;
                }
                LinkedList<Object> inputList = new LinkedList<Object>();
                for (int i = 0; i < inputNode.getChildNodes().getLength(); ++i) {
                    Node node = inputNode.getChildNodes().item(i);
                    if (node.getNodeType() != 1) continue;
                    Object obj = this.parseItemType(node, false);
                    if (obj == null) {
                        LibVulpes.logger.warning("Invalid item \"input\" (" + node.getNodeName() + " " + node.getTextContent() + ") in recipe " + recipeNum + " in " + this.fileName + "!  Skipping.");
                        continue;
                    }
                    inputList.add(obj);
                }
                LinkedList<Object> outputList = new LinkedList<Object>();
                for (int i = 0; i < outputNode.getChildNodes().getLength(); ++i) {
                    Node node = outputNode.getChildNodes().item(i);
                    if (node.getNodeType() != 1) continue;
                    Object obj = this.parseItemType(node, true);
                    if (obj == null) {
                        LibVulpes.logger.warning("Invalid item \"output\" (" + node.getNodeName() + " " + node.getTextContent() + ") in recipe " + recipeNum + " in " + this.fileName + "!  Skipping.");
                        continue;
                    }
                    outputList.add(obj);
                }
                if (masterNode.hasAttributes()) {
                    Node node = masterNode.getAttributes().getNamedItem("timeRequired");
                    if (node != null && !node.getNodeValue().isEmpty()) {
                        try {
                            time = Integer.parseInt(node.getNodeValue());
                        }
                        catch (NumberFormatException e) {
                            LibVulpes.logger.warning("Recipe " + recipeNum + " has no time value");
                        }
                    }
                    if ((node = masterNode.getAttributes().getNamedItem("power")) != null && !node.getNodeValue().isEmpty()) {
                        try {
                            energy = Integer.parseInt(node.getNodeValue());
                        }
                        catch (NumberFormatException e) {
                            LibVulpes.logger.warning("Recipe " + recipeNum + " has no power value");
                        }
                    }
                } else {
                    LibVulpes.logger.info("Recipe " + recipeNum + " has no time or power consumption");
                }
                if (outputList.isEmpty()) {
                    LibVulpes.logger.info("Output List emtpy in recipe " + recipeNum);
                } else {
                    LibVulpes.logger.info("Sucessfully added recipe to " + clazz.getName() + " for " + ((Object)inputList).toString() + " -> " + ((Object)outputList).toString());
                    RecipesMachine.getInstance().addRecipe(clazz, outputList, time, energy, inputList);
                }
            }
            catch (Exception e) {
                LibVulpes.logger.warning("Recipe entry #" + recipeNum + " load failed for '" + clazz.getCanonicalName() + "'!");
            }
            ++recipeNum;
            masterNode = masterNode.getNextSibling();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object parseItemType(Node node, boolean output) {
        if (node.getNodeName().equals("itemStack")) {
            String text = node.getTextContent();
            String[] splitStr = text.split(" ");
            int meta = 0;
            int size = 1;
            if (splitStr.length > 1) {
                try {
                    size = Integer.parseInt(splitStr[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (splitStr.length > 2) {
                try {
                    meta = Integer.parseInt(splitStr[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ItemStack stack = null;
            Block block = Block.func_149684_b((String)splitStr[0]);
            if (block != null) return new ItemStack(block, size, meta);
            Item item = (Item)Item.field_150901_e.func_82594_a(splitStr[0]);
            if (item != null) {
                return new ItemStack(item, size, meta);
            }
            try {
                item = Item.func_150899_d((int)Integer.parseInt(splitStr[0]));
                if (item == null) return stack;
                return new ItemStack(item, size, meta);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (node.getNodeName().equals("oreDict")) {
            String[] splitStr = node.getTextContent().split(" ");
            if (!OreDictionary.doesOreNameExist((String)splitStr[0])) return null;
            String ret = splitStr[0];
            int number = 1;
            if (splitStr.length > 1) {
                try {
                    number = Integer.parseInt(splitStr[1]);
                }
                catch (NumberFormatException size) {
                    // empty catch block
                }
            }
            if (splitStr.length < 1) return ret;
            if (!output) return new NumberedOreDictStack(splitStr[0], number);
            ArrayList list = OreDictionary.getOres((String)splitStr[0]);
            if (list.isEmpty()) return ret;
            ItemStack oreDict = (ItemStack)OreDictionary.getOres((String)splitStr[0]).get(0);
            return new ItemStack(oreDict.func_77973_b(), number, oreDict.func_77960_j());
        }
        if (!node.getNodeName().equals("fluidStack")) return null;
        String[] splitStr = node.getTextContent().split(" ");
        Fluid fluid = FluidRegistry.getFluid((String)splitStr[0]);
        if (fluid == null) return null;
        int amount = 1000;
        if (splitStr.length <= 1) return new FluidStack(fluid, amount);
        try {
            amount = Integer.parseInt(splitStr[1]);
            return new FluidStack(fluid, amount);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new FluidStack(fluid, amount);
    }

    public static String writeRecipe(IRecipe recipe) {
        int index = 0;
        String string = "\t<Recipe timeRequired=\"" + recipe.getTime() + "\" power =\"" + recipe.getPower() + "\">\n\t\t<input>\n";
        for (List list : recipe.getIngredients()) {
            String oreStr;
            if (list.isEmpty()) continue;
            ItemStack stack = (ItemStack)list.get(0);
            if ((oreStr = recipe.getOreDictString(index++)) != null) {
                string = string + "\t\t\t<oreDict>" + oreStr + (stack.field_77994_a > 1 ? " " + stack.field_77994_a : "") + "</oreDict>\n";
                continue;
            }
            string = string + "\t\t\t<itemStack>" + stack.func_77973_b().delegate.name() + (stack.field_77994_a > 1 ? " " + stack.field_77994_a : (stack.func_77960_j() > 0 ? " 1" : "")) + (stack.func_77960_j() > 0 ? " " + stack.func_77960_j() : "") + "</itemStack>\n";
        }
        for (FluidStack fluidStack : recipe.getFluidIngredients()) {
            string = string + "\t\t\t<fluidStack>" + FluidRegistry.getDefaultFluidName((Fluid)fluidStack.getFluid()).split(":")[1] + " " + fluidStack.amount + "</fluidStack>\n";
        }
        string = string + "\t\t</input>\n\t\t<output>\n";
        for (ItemStack itemStack : recipe.getOutput()) {
            string = string + "\t\t\t<itemStack>" + itemStack.func_77973_b().delegate.name() + (itemStack.field_77994_a > 1 ? " " + itemStack.field_77994_a : (itemStack.func_77960_j() > 0 ? " 1" : "")) + (itemStack.func_77960_j() > 0 ? " " + itemStack.func_77960_j() : "") + "</itemStack>\n";
        }
        for (FluidStack fluidStack : recipe.getFluidOutputs()) {
            string = string + "\t\t\t<fluidStack>" + FluidRegistry.getDefaultFluidName((Fluid)fluidStack.getFluid()).split(":")[1] + " " + fluidStack.amount + "</fluidStack>\n";
        }
        string = string + "\t\t</output>\n\t</Recipe>";
        return string;
    }
}

