/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.util;

import java.util.LinkedList;
import zmaster587.libVulpes.api.IUniversalEnergy;

public class MultiBattery
implements IUniversalEnergy {
    protected LinkedList<IUniversalEnergy> batteries = new LinkedList();

    public void addBattery(IUniversalEnergy battery) {
        this.batteries.add(battery);
    }

    public boolean removeBattery(IUniversalEnergy battery) {
        return this.batteries.remove(battery);
    }

    public void clear() {
        this.batteries.clear();
    }

    @Override
    public int extractEnergy(int amt, boolean simulate) {
        int amtExtracted = 0;
        for (IUniversalEnergy battery : this.batteries) {
            amtExtracted += battery.extractEnergy(amt, simulate);
        }
        return amtExtracted;
    }

    @Override
    public int getEnergyStored() {
        int energyStored = 0;
        for (IUniversalEnergy battery : this.batteries) {
            energyStored += battery.getEnergyStored();
        }
        return energyStored;
    }

    @Override
    public int getMaxEnergyStored() {
        int energyStored = 0;
        for (IUniversalEnergy battery : this.batteries) {
            energyStored += battery.getMaxEnergyStored();
        }
        return energyStored;
    }

    @Override
    public void setMaxEnergyStored(int max) {
        max /= this.batteries.size();
        for (IUniversalEnergy battery : this.batteries) {
            battery.setMaxEnergyStored(max);
        }
    }

    @Override
    public int acceptEnergy(int amt, boolean simulate) {
        int energyRecieved = 0;
        for (IUniversalEnergy battery : this.batteries) {
            energyRecieved += battery.acceptEnergy(amt - energyRecieved, simulate);
        }
        return energyRecieved;
    }

    @Override
    public void setEnergyStored(int amt) {
        block3: {
            int recieved;
            int amtAdded;
            int difference;
            block2: {
                int recieved2;
                difference = amt - this.getEnergyStored();
                if (difference <= 0) break block2;
                for (amtAdded = 0; amtAdded < difference && (recieved2 = this.acceptEnergy(difference, false)) != 0; amtAdded += recieved2) {
                }
                break block3;
            }
            if (difference >= 0) break block3;
            while (amtAdded < -difference && (recieved = this.extractEnergy(-difference, false)) != 0) {
                amtAdded += recieved;
            }
        }
    }
}

