/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile.multiblock;

import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import zmaster587.libVulpes.Configuration;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.ITimeModifier;
import zmaster587.libVulpes.api.IToggleableMachine;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.client.RepeatingSound;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.IToggleButton;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleToggleSwitch;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.TileMultiblockMachine;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.MultiBattery;

public class TileMultiPowerConsumer
extends TileMultiBlock
implements INetworkMachine,
IModularInventory,
IProgressBar,
IToggleButton,
IToggleableMachine {
    protected MultiBattery batteries = new MultiBattery();
    private float timeMultiplier = 1.0f;
    protected int completionTime = -1;
    protected int currentTime = -1;
    protected int powerPerTick;
    protected boolean enabled = false;
    protected ModuleToggleSwitch toggleSwitch = new ModuleToggleSwitch(160, 5, 0, "", this, TextureResources.buttonToggleImage, 11, 26, this.getMachineEnabled());
    boolean hadPowerLastTick = true;
    Object sound;

    public MultiBattery getBatteries() {
        return this.batteries;
    }

    @Override
    public int getProgress(int id) {
        return this.currentTime;
    }

    @Override
    public int getTotalProgress(int id) {
        return this.completionTime;
    }

    @Override
    public void setProgress(int id, int progress) {
        this.currentTime = progress;
    }

    @Override
    public void setTotalProgress(int id, int progress) {
        this.completionTime = progress;
    }

    @Override
    public float getNormallizedProgress(int id) {
        return this.completionTime > 0 ? (float)this.currentTime / (float)this.completionTime : 0.0f;
    }

    public boolean canUpdate() {
        return true;
    }

    public ResourceLocation getSound() {
        return null;
    }

    public int getSoundDuration() {
        return 1;
    }

    public float getPowerMultiplier() {
        return Configuration.powerMult;
    }

    public float getTimeMultiplierForBlock(Block block, int meta, TileEntity tile) {
        if (block instanceof ITimeModifier) {
            return ((ITimeModifier)block).getTimeMult();
        }
        return 1.0f;
    }

    public float getTimeMultiplier() {
        return this.timeMultiplier;
    }

    @Override
    protected void replaceStandardBlock(int x, int y, int z, Block block, int meta, TileEntity tile) {
        super.replaceStandardBlock(x, y, z, block, meta, tile);
        this.timeMultiplier *= this.getTimeMultiplierForBlock(block, meta, tile);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.timeAlive == 0) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.isComplete()) {
                    this.canRender = this.completeStructure = this.completeStructure();
                }
                this.onCreated();
            } else {
                ResourceLocation str = this.getSound();
                if (str != null) {
                    this.playMachineSound(this.getSound());
                }
            }
            this.timeAlive = 1;
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 1000L == 0L && !this.isComplete()) {
            this.attemptCompleteStructure();
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.isRunning()) {
            if (this.hasEnergy(this.requiredPowerPerTick()) || this.field_145850_b.field_72995_K && this.hadPowerLastTick) {
                this.onRunningPoweredTick();
                if (!this.field_145850_b.field_72995_K) {
                    if (!this.hadPowerLastTick) {
                        this.hadPowerLastTick = true;
                        this.func_70296_d();
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    this.useEnergy(this.usedPowerPerTick());
                }
            } else if (!this.field_145850_b.field_72995_K && this.hadPowerLastTick) {
                this.hadPowerLastTick = false;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    protected void onCreated() {
    }

    protected int requiredPowerPerTick() {
        return (int)Math.max((float)this.powerPerTick * this.getPowerMultiplier(), 1.0f);
    }

    protected int usedPowerPerTick() {
        return this.requiredPowerPerTick();
    }

    protected void onRunningPoweredTick() {
        ++this.currentTime;
        if (this.currentTime == this.completionTime) {
            this.processComplete();
        }
    }

    protected void playMachineSound(ResourceLocation str) {
        LibVulpes.proxy.playSound((Object)new RepeatingSound(str, this));
    }

    public void setMachineEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getMachineEnabled() {
        return this.enabled;
    }

    @Override
    public void resetCache() {
        this.batteries.clear();
        super.resetCache();
    }

    @Override
    public void deconstructMultiBlock(World world, int destroyedX, int destroyedY, int destroyedZ, boolean blockBroken) {
        this.resetCache();
        this.completionTime = 0;
        this.currentTime = 0;
        this.enabled = false;
        this.timeMultiplier = 1.0f;
        super.deconstructMultiBlock(world, destroyedX, destroyedY, destroyedZ, blockBroken);
    }

    protected void processComplete() {
        this.completionTime = 0;
        this.currentTime = 0;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean isRunning() {
        return this.completionTime > 0 && this.isComplete();
    }

    public void useEnergy(int amt) {
        this.batteries.extractEnergy(amt, false);
    }

    public boolean hasEnergy(int amt) {
        return this.batteries.getEnergyStored() >= amt;
    }

    public void setMachineRunning(boolean running) {
        if (running && this.func_145832_p() < 8) {
            this.field_145847_g = this.func_145832_p() | 8;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, 2);
        } else if (!running && this.field_145847_g >= 8) {
            this.field_145847_g = this.func_145832_p() & 7;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, 2);
        }
    }

    @Override
    protected void integrateTile(TileEntity tile) {
        super.integrateTile(tile);
        for (BlockMeta block : TileMultiBlock.getMapping('P')) {
            if (block.getBlock() != this.field_145850_b.func_147439_a(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) continue;
            this.batteries.addBattery((IUniversalEnergy)tile);
        }
    }

    @Override
    protected void writeNetworkData(NBTTagCompound nbt) {
        super.writeNetworkData(nbt);
        nbt.func_74768_a("completionTime", this.completionTime);
        nbt.func_74768_a("currentTime", this.currentTime);
        nbt.func_74768_a("powerPerTick", this.powerPerTick);
        nbt.func_74757_a("enabled", this.enabled);
        if (this.timeMultiplier != 1.0f) {
            nbt.func_74776_a("timeMult", this.timeMultiplier);
        }
    }

    @Override
    protected void readNetworkData(NBTTagCompound nbt) {
        super.readNetworkData(nbt);
        this.completionTime = nbt.func_74762_e("completionTime");
        this.currentTime = nbt.func_74762_e("currentTime");
        this.powerPerTick = nbt.func_74762_e("powerPerTick");
        this.enabled = nbt.func_74767_n("enabled");
        if (nbt.func_74764_b("timeMult")) {
            this.timeMultiplier = nbt.func_74760_g("timeMult");
        }
        this.toggleSwitch.setToggleState(this.enabled);
    }

    @Override
    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == TileMultiblockMachine.NetworkPackets.POWERERROR.ordinal()) {
            out.writeBoolean(this.hadPowerLastTick);
        } else if (id == TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()) {
            out.writeBoolean(this.enabled);
        }
    }

    @Override
    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == TileMultiblockMachine.NetworkPackets.POWERERROR.ordinal()) {
            nbt.func_74757_a("hadPowerLastTick", in.readBoolean());
        } else if (packetId == TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()) {
            nbt.func_74757_a("enabled", in.readBoolean());
        }
    }

    @Override
    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == TileMultiblockMachine.NetworkPackets.POWERERROR.ordinal()) {
            this.hadPowerLastTick = nbt.func_74767_n("hadPowerLastTick");
        } else if (id == TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()) {
            this.setMachineEnabled(nbt.func_74767_n("enabled"));
            this.toggleSwitch.setToggleState(this.getMachineEnabled());
            if (!this.field_145850_b.field_72995_K) {
                PacketHandler.sendToNearby(new PacketMachine(this, (byte)TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0);
            }
        }
    }

    @Override
    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add(new ModulePower(18, 20, this.getBatteries()));
        this.toggleSwitch = new ModuleToggleSwitch(160, 5, 0, "", this, TextureResources.buttonToggleImage, 11, 26, this.getMachineEnabled());
        modules.add(this.toggleSwitch);
        modules.add(new ModuleText(140, 40, String.format("Speed:\n%.2fx", Float.valueOf(1.0f / this.getTimeMultiplier())), 0x2D2D2D));
        modules.add(new ModuleText(140, 60, String.format("Power:\n%.2fx", Float.valueOf(1.0f)), 0x2D2D2D));
        return modules;
    }

    @Override
    public String getModularInventoryName() {
        return this.getMachineName();
    }

    @Override
    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId == 0) {
            this.setMachineEnabled(this.toggleSwitch.getState());
            PacketHandler.sendToServer(new PacketMachine(this, (byte)TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()));
        }
    }

    @Override
    public void stateUpdated(ModuleBase module) {
        if (module == this.toggleSwitch) {
            this.setMachineEnabled(this.toggleSwitch.getState());
        }
    }

    @Override
    public boolean canInteractWithContainer(EntityPlayer entity) {
        return this.isComplete();
    }
}

