/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile.multiblock;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.block.multiblock.BlockMultiBlockComponentVisible;
import zmaster587.libVulpes.block.multiblock.BlockMultiblockStructure;
import zmaster587.libVulpes.tile.IMultiblock;
import zmaster587.libVulpes.tile.TilePointer;
import zmaster587.libVulpes.tile.TileSchematic;
import zmaster587.libVulpes.tile.multiblock.TilePlaceholder;
import zmaster587.libVulpes.tile.multiblock.hatch.TileFluidHatch;
import zmaster587.libVulpes.tile.multiblock.hatch.TileInputHatch;
import zmaster587.libVulpes.tile.multiblock.hatch.TileOutputHatch;
import zmaster587.libVulpes.util.Vector3F;

public class TileMultiBlock
extends TileEntity {
    protected boolean completeStructure = false;
    protected boolean canRender = false;
    protected byte timeAlive = 0;
    protected LinkedList<IInventory> itemInPorts = new LinkedList();
    protected LinkedList<IInventory> itemOutPorts = new LinkedList();
    protected LinkedList<IFluidHandler> fluidInPorts = new LinkedList();
    protected LinkedList<IFluidHandler> fluidOutPorts = new LinkedList();
    protected static HashMap<Character, List<BlockMeta>> charMapping = new HashMap();

    public static void addMapping(char character, List<BlockMeta> listToAdd) {
        if (charMapping.containsKey(Character.valueOf(character))) {
            LibVulpes.logger.warning("Overwritting Multiblock mapping of \"" + character + "\"");
        }
        charMapping.put(Character.valueOf(character), listToAdd);
    }

    public static List<BlockMeta> getMapping(char character) {
        return charMapping.get(Character.valueOf(character));
    }

    public boolean isComplete() {
        return this.completeStructure;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRender() {
        return this.canRender;
    }

    public String getMachineName() {
        return "";
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < 64.0;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("canRender", this.canRender);
        this.writeNetworkData(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.canRender = nbt.func_74767_n("canRender");
        this.readNetworkData(nbt);
    }

    public void invalidateComponent(TileEntity tile) {
        this.setComplete(false);
    }

    public void onInventoryUpdated() {
    }

    public void deconstructMultiBlock(World world, int destroyedX, int destroyedY, int destroyedZ, boolean blockBroken) {
        this.completeStructure = false;
        this.canRender = false;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() & 7, 2);
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ForgeDirection front = this.getFrontDirection();
        Object[][][] structure = this.getStructure();
        Vector3F<Integer> offset = this.getControllerOffset(structure);
        for (int y = 0; y < structure.length; ++y) {
            for (int z = 0; z < structure[0].length; ++z) {
                for (int x = 0; x < structure[0][0].length; ++x) {
                    int globalX = this.field_145851_c + (x - (Integer)offset.x) * front.offsetZ - (z - (Integer)offset.z) * front.offsetX;
                    int globalY = this.field_145848_d - y + (Integer)offset.y;
                    int globalZ = this.field_145849_e - (x - (Integer)offset.x) * front.offsetX - (z - (Integer)offset.z) * front.offsetZ;
                    if (blockBroken && globalX == destroyedX && globalY == destroyedY && globalZ == destroyedZ) continue;
                    TileEntity tile = this.field_145850_b.func_147438_o(globalX, globalY, globalZ);
                    Block block = this.field_145850_b.func_147439_a(globalX, globalY, globalZ);
                    this.destroyBlockAt(globalX, globalY, globalZ, block, tile);
                }
            }
        }
        this.resetCache();
    }

    protected void destroyBlockAt(int x, int y, int z, Block block, TileEntity tile) {
        if (block instanceof BlockMultiblockStructure) {
            ((BlockMultiblockStructure)block).destroyStructure(this.field_145850_b, x, y, z, this.field_145850_b.func_72805_g(x, y, z));
        }
        if (tile instanceof TilePlaceholder && !(tile instanceof TileSchematic)) {
            TilePlaceholder placeholder = (TilePlaceholder)tile;
            placeholder.setIncomplete();
            this.field_145850_b.func_147465_d(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, placeholder.getReplacedBlock(), (int)placeholder.getReplacedBlockMeta(), 3);
            if (placeholder.getReplacedTileEntity() != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                placeholder.getReplacedTileEntity().func_145841_b(nbt);
                this.field_145850_b.func_147438_o(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e).func_145839_a(nbt);
            }
        } else if (tile instanceof IMultiblock) {
            ((IMultiblock)tile).setIncomplete();
        }
    }

    public ForgeDirection getFrontDirection() {
        return RotatableBlock.getFront(this.func_145832_p());
    }

    public Object[][][] getStructure() {
        return null;
    }

    public boolean attemptCompleteStructure() {
        this.canRender = this.completeStructure = this.completeStructure();
        return this.completeStructure;
    }

    public void setComplete(boolean complete) {
        this.completeStructure = complete;
    }

    public List<BlockMeta> getAllowableWildCardBlocks() {
        ArrayList<BlockMeta> list = new ArrayList<BlockMeta>();
        return list;
    }

    public void resetCache() {
        this.itemInPorts.clear();
        this.itemOutPorts.clear();
        this.fluidInPorts.clear();
        this.fluidOutPorts.clear();
    }

    protected boolean completeStructure() {
        int globalZ;
        int globalY;
        int globalX;
        int x;
        int z;
        int y;
        this.resetCache();
        Object[][][] structure = this.getStructure();
        Vector3F<Integer> offset = this.getControllerOffset(structure);
        ForgeDirection front = this.getFrontDirection();
        LinkedList<TileEntity> tiles = new LinkedList<TileEntity>();
        for (y = 0; y < structure.length; ++y) {
            for (z = 0; z < structure[0].length; ++z) {
                for (x = 0; x < structure[0][0].length; ++x) {
                    if (structure[y][z][x] == null) continue;
                    globalX = this.field_145851_c + (x - (Integer)offset.x) * front.offsetZ - (z - (Integer)offset.z) * front.offsetX;
                    globalY = this.field_145848_d - y + (Integer)offset.y;
                    globalZ = this.field_145849_e - (x - (Integer)offset.x) * front.offsetX - (z - (Integer)offset.z) * front.offsetZ;
                    if (!this.field_145850_b.func_72938_d((int)globalX, (int)globalZ).field_76636_d) {
                        return false;
                    }
                    TileEntity tile = this.field_145850_b.func_147438_o(globalX, globalY, globalZ);
                    Block block = this.field_145850_b.func_147439_a(globalX, globalY, globalZ);
                    int meta = this.field_145850_b.func_72805_g(globalX, globalY, globalZ);
                    if (block == LibVulpesBlocks.blockPhantom) {
                        return false;
                    }
                    if (tile != null) {
                        tiles.add(tile);
                    }
                    if (tile instanceof TilePointer && (!((IMultiblock)tile).hasMaster() || ((IMultiblock)tile).getMasterBlock() == this ? ((IMultiblock)tile).getMasterBlock() == this : ((IMultiblock)tile).getMasterBlock().field_145851_c == this.field_145851_c && ((IMultiblock)tile).getMasterBlock().field_145848_d == this.field_145848_d && ((IMultiblock)tile).getMasterBlock().field_145849_e == this.field_145849_e)) continue;
                    if (structure[y][z][x] instanceof Character && ((Character)structure[y][z][x]).charValue() == 'c' || structure[y][z][x] instanceof Block && (Block)structure[y][z][x] == Blocks.field_150350_a && this.field_145850_b.func_147437_c(globalX, globalY, globalZ) || this.getAllowableBlocks(structure[y][z][x]).contains(new BlockMeta(block, meta))) continue;
                    LibVulpes.proxy.spawnParticle("errorBox", this.field_145850_b, globalX, globalY, globalZ, 0.0, 0.0, 0.0);
                    return false;
                }
            }
        }
        for (y = 0; y < structure.length; ++y) {
            for (z = 0; z < structure[0].length; ++z) {
                for (x = 0; x < structure[0][0].length; ++x) {
                    globalX = this.field_145851_c + (x - (Integer)offset.x) * front.offsetZ - (z - (Integer)offset.z) * front.offsetX;
                    globalY = this.field_145848_d - y + (Integer)offset.y;
                    globalZ = this.field_145849_e - (x - (Integer)offset.x) * front.offsetX - (z - (Integer)offset.z) * front.offsetZ;
                    Block block = this.field_145850_b.func_147439_a(globalX, globalY, globalZ);
                    TileEntity tile = this.field_145850_b.func_147438_o(globalX, globalY, globalZ);
                    if (block instanceof BlockMultiBlockComponentVisible) {
                        ((BlockMultiBlockComponentVisible)block).hideBlock(this.field_145850_b, globalX, globalY, globalZ, this.field_145850_b.func_72805_g(globalX, globalY, globalZ));
                        tile = this.field_145850_b.func_147438_o(globalX, globalY, globalZ);
                        if (tile instanceof IMultiblock) {
                            ((IMultiblock)tile).setComplete(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    } else if (block instanceof BlockMultiblockStructure && this.shouldHideBlock(this.field_145850_b, globalX, globalY, globalZ, block)) {
                        ((BlockMultiblockStructure)block).hideBlock(this.field_145850_b, globalX, globalY, globalZ, this.field_145850_b.func_72805_g(globalX, globalY, globalZ));
                    }
                    if (structure[y][z][x] == null || block.isAir((IBlockAccess)this.field_145850_b, globalX, globalY, globalZ) || tile instanceof IMultiblock || tile instanceof TileMultiBlock) continue;
                    this.replaceStandardBlock(globalX, globalY, globalZ, block, this.field_145850_b.func_72805_g(globalX, globalY, globalZ), tile);
                }
            }
        }
        for (TileEntity tile : tiles) {
            this.integrateTile(tile);
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public List<BlockMeta> getAllowableBlocks(Object input) {
        if (input instanceof Character && ((Character)input).charValue() == '*') {
            return this.getAllowableWildCardBlocks();
        }
        if (input instanceof Character && charMapping.containsKey((Character)input)) {
            return charMapping.get((Character)input);
        }
        if (input instanceof String) {
            ArrayList stacks = OreDictionary.getOres((String)((String)input));
            LinkedList<BlockMeta> list = new LinkedList<BlockMeta>();
            for (ItemStack stack : stacks) {
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                if (block == null || block == Blocks.field_150350_a) continue;
                list.add(new BlockMeta(block, stack.func_77973_b().func_77647_b(stack.func_77960_j())));
            }
            return list;
        }
        if (input instanceof Block) {
            ArrayList<BlockMeta> list = new ArrayList<BlockMeta>();
            list.add(new BlockMeta((Block)input, -1));
            return list;
        }
        if (input instanceof BlockMeta) {
            ArrayList<BlockMeta> list = new ArrayList<BlockMeta>();
            list.add((BlockMeta)input);
            return list;
        }
        if (input instanceof Block[]) {
            ArrayList<BlockMeta> list = new ArrayList<BlockMeta>();
            for (Block b : (Block[])input) {
                list.add(new BlockMeta(b));
            }
            return list;
        }
        if (input instanceof List) {
            return (List)input;
        }
        ArrayList<BlockMeta> list = new ArrayList<BlockMeta>();
        return list;
    }

    public boolean shouldHideBlock(World world, int x, int y, int z, Block tile) {
        return false;
    }

    protected void replaceStandardBlock(int xCoord, int yCoord, int zCoord, Block block, int meta, TileEntity tile) {
        this.field_145850_b.func_147449_b(xCoord, yCoord, zCoord, LibVulpesBlocks.blockPlaceHolder);
        TilePlaceholder newTile = (TilePlaceholder)this.field_145850_b.func_147438_o(xCoord, yCoord, zCoord);
        newTile.setReplacedBlock(block);
        newTile.setReplacedBlockMeta((byte)meta);
        newTile.setReplacedTileEntity(tile);
        newTile.setMasterBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected void integrateTile(TileEntity tile) {
        if (tile instanceof IMultiblock) {
            ((IMultiblock)tile).setComplete(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (tile instanceof TileInputHatch) {
            this.itemInPorts.add((IInventory)tile);
        } else if (tile instanceof TileOutputHatch) {
            this.itemOutPorts.add((IInventory)tile);
        } else if (tile instanceof TileFluidHatch) {
            TileFluidHatch liquidHatch = (TileFluidHatch)tile;
            if (liquidHatch.isOutputOnly()) {
                this.fluidOutPorts.add(liquidHatch);
            } else {
                this.fluidInPorts.add(liquidHatch);
            }
        }
    }

    protected Vector3F<Integer> getControllerOffset(Object[][][] structure) {
        for (int y = 0; y < structure.length; ++y) {
            for (int z = 0; z < structure[0].length; ++z) {
                for (int x = 0; x < structure[0][0].length; ++x) {
                    if (!(structure[y][z][x] instanceof Character) || ((Character)structure[y][z][x]).charValue() != 'c') continue;
                    return new Vector3F<Integer>(x, y, z);
                }
            }
        }
        return null;
    }

    protected void writeNetworkData(NBTTagCompound nbt) {
    }

    protected void readNetworkData(NBTTagCompound nbt) {
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeNetworkData(nbt);
        nbt.func_74757_a("completeStructure", this.completeStructure);
        nbt.func_74757_a("canRender", this.canRender);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNetworkData(nbt);
        this.completeStructure = nbt.func_74767_n("completeStructure");
        this.canRender = nbt.func_74767_n("canRender");
    }
}

