/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile.energy;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.tile.IMultiblock;
import zmaster587.libVulpes.tile.TilePointer;
import zmaster587.libVulpes.util.UniversalBattery;

public abstract class TilePlugBase
extends TilePointer
implements IModularInventory,
IUniversalEnergy,
IMultiblock,
IInventory {
    protected UniversalBattery storage;
    protected int teir;

    public TilePlugBase() {
    }

    public TilePlugBase(int teir) {
        this.teir = teir;
        this.storage = new UniversalBattery(this.getMaxEnergy(teir));
    }

    protected int getMaxEnergy(int teir) {
        return (int)Math.pow(10.0, teir) * 10000;
    }

    @Override
    public void setMaxEnergyStored(int max) {
        this.storage.setMaxEnergyStored(max);
    }

    protected int getMaxDrainRate(int teir) {
        return 250 * (int)Math.pow(2.0, teir);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("teir", this.teir);
        this.storage.writeToNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.teir = nbt.func_74762_e("teir");
        this.storage = new UniversalBattery(this.getMaxEnergy(this.teir));
        this.storage.readFromNBT(nbt);
    }

    @Override
    public void setEnergyStored(int amt) {
        this.storage.setEnergyStored(amt);
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    @Override
    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add(new ModulePower(18, 20, this));
        return modules;
    }

    @Override
    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    @Override
    public int extractEnergy(int amt, boolean simulate) {
        return this.storage.extractEnergy(amt, simulate);
    }

    @Override
    public int getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public int acceptEnergy(int amt, boolean simulate) {
        return this.storage.acceptEnergy(amt, simulate);
    }
}

