/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.tile.IMultiblock;

public class TilePointer
extends TileEntity
implements IMultiblock,
ILinkableTile {
    int masterX;
    int masterY;
    int masterZ;
    TileEntity masterBlock;

    public TilePointer() {
        this.masterX = 0;
        this.masterY = -1;
        this.masterZ = 0;
    }

    public TilePointer(int x, int y, int z) {
        this.masterX = x;
        this.masterY = y;
        this.masterZ = z;
    }

    @Override
    public boolean onLinkStart(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        TileEntity master;
        if (this.hasMaster() && (master = this.getMasterBlock()) instanceof ILinkableTile) {
            return ((ILinkableTile)master).onLinkStart(item, master, player, world);
        }
        return false;
    }

    @Override
    public boolean onLinkComplete(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        TileEntity master;
        if (this.hasMaster() && (master = this.getMasterBlock()) instanceof ILinkableTile) {
            return ((ILinkableTile)master).onLinkComplete(item, master, player, world);
        }
        return false;
    }

    public boolean allowRedstoneOutputOnSide(ForgeDirection facing) {
        return true;
    }

    public boolean isSet() {
        return this.masterY != -1;
    }

    public int getX() {
        return this.masterX;
    }

    public int getY() {
        return this.masterY;
    }

    public int getZ() {
        return this.masterZ;
    }

    public void setX(int x) {
        this.masterX = x;
    }

    public void setY(int y) {
        this.masterY = y;
    }

    public void setZ(int z) {
        this.masterZ = z;
    }

    @Override
    public void setMasterBlock(int x, int y, int z) {
        this.setComplete(x, y, z);
    }

    public TileEntity getFinalPointedTile() {
        TileEntity pointedTile;
        try {
            pointedTile = this.field_145850_b.func_72899_e(this.masterX, this.masterY, this.masterZ) ? this.field_145850_b.func_147438_o(this.masterX, this.masterY, this.masterZ) : null;
        }
        catch (NullPointerException e) {
            return null;
        }
        if (pointedTile == null) {
            return null;
        }
        if (pointedTile instanceof TilePointer) {
            return ((TilePointer)pointedTile).getFinalPointedTile();
        }
        return pointedTile;
    }

    public Packet func_145844_m() {
        NBTTagCompound comp = new NBTTagCompound();
        this.writeToNBTHelper(comp);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, comp);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (this.field_145850_b.field_72995_K) {
            this.readFromNBTHelper(pkt.func_148857_g());
        }
    }

    @Override
    public boolean hasMaster() {
        return this.masterY != -1;
    }

    @Override
    public TileEntity getMasterBlock() {
        if (this.hasMaster()) {
            if (this.masterBlock == null || this.masterBlock.func_145837_r()) {
                this.masterBlock = this.field_145850_b.func_147438_o(this.masterX, this.masterY, this.masterZ);
            }
            return this.masterBlock;
        }
        return null;
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void setComplete(int x, int y, int z) {
        this.masterX = x;
        this.masterY = y;
        this.masterZ = z;
    }

    @Override
    public void setIncomplete() {
        this.masterX = -1;
        this.masterY = -1;
        this.masterZ = -1;
        this.masterBlock = null;
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.writeToNBTHelper(nbtTagCompound);
    }

    protected void writeToNBTHelper(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a("masterX", this.masterX);
        nbtTagCompound.func_74768_a("masterY", this.masterY);
        nbtTagCompound.func_74768_a("masterZ", this.masterZ);
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readFromNBTHelper(nbtTagCompound);
    }

    protected void readFromNBTHelper(NBTTagCompound nbtTagCompound) {
        this.masterX = nbtTagCompound.func_74762_e("masterX");
        this.masterY = nbtTagCompound.func_74762_e("masterY");
        this.masterZ = nbtTagCompound.func_74762_e("masterZ");
    }
}

