/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import net.minecraft.nbt.NBTTagCompound;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.tile.TileInventoriedForgeProducer;

public abstract class TileInventoriedForgePowerMachine
extends TileInventoriedForgeProducer
implements IProgressBar {
    protected int timeRemaining;
    protected int currentTime;
    protected int lastRFAmount;

    protected TileInventoriedForgePowerMachine(int energy, int invSize) {
        super(energy, invSize);
    }

    @Override
    public boolean canGeneratePower() {
        return this.timeRemaining > 0;
    }

    @Override
    public void onGeneratePower() {
    }

    protected void setState(boolean on) {
        if (on) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) | 8, 2);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 0xFFFFFFF7, 2);
        }
    }

    protected void onOperationFinish() {
        this.setState(false);
    }

    public int getLastAmtGenerated() {
        return this.lastRFAmount;
    }

    @Override
    public void func_145845_h() {
        this.lastRFAmount = 0;
        if (this.canGeneratePower()) {
            if (this.hasEnoughEnergyBuffer(this.getPowerPerOperation())) {
                this.lastRFAmount = this.getPowerPerOperation();
                if (!this.field_145850_b.field_72995_K) {
                    this.energy.acceptEnergy(this.lastRFAmount, false);
                }
                this.onGeneratePower();
                this.setState(true);
                if (this.timeRemaining < this.currentTime++) {
                    this.currentTime = 0;
                    this.timeRemaining = -1;
                    this.onOperationFinish();
                }
            } else {
                this.notEnoughBufferForFunction();
            }
        }
        this.transmitPower();
    }

    @Override
    public void notEnoughBufferForFunction() {
        this.setState(false);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("timeRemaining", this.timeRemaining);
        nbt.func_74768_a("currentTime", this.currentTime);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.timeRemaining = nbt.func_74762_e("timeRemaining");
        this.currentTime = nbt.func_74762_e("currentTime");
    }

    @Override
    public float getNormallizedProgress(int id) {
        return (float)(this.timeRemaining - this.currentTime) / (float)this.timeRemaining;
    }

    @Override
    public void setProgress(int id, int progress) {
        this.currentTime = progress;
    }

    @Override
    public int getProgress(int id) {
        return this.currentTime;
    }

    @Override
    public int getTotalProgress(int id) {
        return this.timeRemaining;
    }

    @Override
    public void setTotalProgress(int id, int progress) {
        this.timeRemaining = progress;
    }
}

