/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import cofh.api.energy.IEnergyHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.libVulpes.Configuration;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.util.UniversalBattery;

public abstract class TileEntityRFConsumer
extends TileEntity
implements IEnergyHandler,
IUniversalEnergy {
    protected UniversalBattery energy;

    protected TileEntityRFConsumer(int energy) {
        this.energy = new UniversalBattery(energy);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection arg0) {
        return true;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.energy.writeToNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy.readFromNBT(nbt);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.acceptEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.extractEnergy(maxExtract, simulate);
    }

    public boolean hasEnoughEnergy(int amt) {
        return this.getEnergyStored() >= amt;
    }

    public int getPowerPerOperation() {
        return 0;
    }

    public abstract boolean canPerformFunction();

    public void func_145845_h() {
        super.func_145845_h();
        if (this.canPerformFunction()) {
            if (this.hasEnoughEnergy((int)Math.max(Configuration.powerMult * (float)this.getPowerPerOperation(), 1.0f))) {
                if (!this.field_145850_b.field_72995_K) {
                    this.energy.extractEnergy(this.getPowerPerOperation(), false);
                }
                this.performFunction();
            } else {
                this.notEnoughEnergyForFunction();
            }
        }
    }

    public abstract void performFunction();

    public void notEnoughEnergyForFunction() {
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energy.getMaxEnergyStored();
    }

    public boolean hasEnergy() {
        return this.energy.getEnergyStored() > 0;
    }

    @Override
    public void setEnergyStored(int value) {
        this.energy.setEnergyStored(value);
    }

    @Override
    public int extractEnergy(int amt, boolean simulate) {
        return this.energy.extractEnergy(amt, false);
    }

    @Override
    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public void setMaxEnergyStored(int max) {
        this.energy.setEnergyStored(max);
    }

    @Override
    public int acceptEnergy(int amt, boolean simulate) {
        return this.energy.acceptEnergy(amt, simulate);
    }
}

