/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.util.UniversalBattery;

public abstract class TileEntityForgeProducer
extends TileEntity
implements IModularInventory,
IEnergyHandler,
IUniversalEnergy {
    protected UniversalBattery energy;

    protected TileEntityForgeProducer(int energy) {
        this.energy = new UniversalBattery(energy);
    }

    @Override
    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add(new ModulePower(18, 20, this.energy));
        return modules;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection arg0) {
        return true;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.energy.writeToNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy.readFromNBT(nbt);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.acceptEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.extractEnergy(maxExtract, simulate);
    }

    public boolean hasEnoughEnergyBuffer(int amt) {
        return this.getMaxEnergyStored() - this.getEnergyStored() >= amt;
    }

    public int getPowerPerOperation() {
        return 0;
    }

    public abstract boolean canGeneratePower();

    public void func_145845_h() {
        if (this.canGeneratePower()) {
            if (this.hasEnoughEnergyBuffer(this.getPowerPerOperation())) {
                if (!this.field_145850_b.field_72995_K) {
                    this.energy.acceptEnergy(this.getPowerPerOperation(), false);
                }
                this.onGeneratePower();
            } else {
                this.notEnoughBufferForFunction();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.transmitPower();
        }
    }

    protected void transmitPower() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (!(tile instanceof IEnergyReceiver)) continue;
            IEnergyReceiver handle = (IEnergyReceiver)tile;
            this.energy.extractEnergy(handle.receiveEnergy(dir.getOpposite(), this.energy.getEnergyStored(), false), false);
        }
    }

    public abstract void onGeneratePower();

    public void notEnoughBufferForFunction() {
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energy.getMaxEnergyStored();
    }

    public boolean hasEnergy() {
        return this.energy.getEnergyStored() > 0;
    }

    @Override
    public void setEnergyStored(int value) {
        this.energy.setEnergyStored(value);
    }

    @Override
    public int extractEnergy(int amt, boolean simulate) {
        return this.energy.extractEnergy(amt, simulate);
    }

    @Override
    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public void setMaxEnergyStored(int max) {
        this.energy.setEnergyStored(max);
    }

    @Override
    public int acceptEnergy(int amt, boolean simulate) {
        return this.energy.acceptEnergy(amt, simulate);
    }
}

