/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.util.INetworkMachine;

public class PacketMachine
extends BasePacket {
    INetworkMachine machine;
    NBTTagCompound nbt = new NBTTagCompound();
    byte packetId;

    public PacketMachine() {
    }

    public PacketMachine(INetworkMachine machine, byte packetId) {
        this();
        this.machine = machine;
        this.packetId = packetId;
    }

    @Override
    public void write(ByteBuf outline) {
        outline.writeInt(((TileEntity)this.machine).func_145831_w().field_73011_w.field_76574_g);
        outline.writeInt(((TileEntity)this.machine).field_145851_c);
        outline.writeInt(((TileEntity)this.machine).field_145848_d);
        outline.writeInt(((TileEntity)this.machine).field_145849_e);
        outline.writeByte((int)this.packetId);
        this.machine.writeDataToNetwork(outline, this.packetId);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readClient(ByteBuf in) {
        in.readInt();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int x = in.readInt();
        int y = in.readInt();
        int z = in.readInt();
        this.packetId = in.readByte();
        TileEntity ent = world.func_147438_o(x, y, z);
        if (ent != null && ent instanceof INetworkMachine) {
            this.machine = (INetworkMachine)ent;
            this.machine.readDataFromNetwork(in, this.packetId, this.nbt);
        }
    }

    @Override
    public void read(ByteBuf in) {
        TileEntity ent;
        int temp = in.readInt();
        WorldServer world = DimensionManager.getWorld((int)temp);
        int x = in.readInt();
        int y = in.readInt();
        int z = in.readInt();
        this.packetId = in.readByte();
        Chunk chunk = world.func_72938_d(x, z);
        if (chunk != null && chunk.field_76636_d && (ent = world.func_147438_o(x, y, z)) != null && ent instanceof INetworkMachine) {
            this.machine = (INetworkMachine)ent;
            this.machine.readDataFromNetwork(in, this.packetId, this.nbt);
        }
    }

    @Override
    public void executeClient(EntityPlayer player) {
        if (this.machine != null) {
            this.machine.useNetworkData(player, Side.CLIENT, this.packetId, this.nbt);
        }
    }

    @Override
    public void executeServer(EntityPlayerMP player) {
        if (this.machine != null) {
            this.machine.useNetworkData((EntityPlayer)player, Side.SERVER, this.packetId, this.nbt);
        }
    }

    public void execute(EntityPlayer player, Side side) {
        if (this.machine != null) {
            this.machine.useNetworkData(player, side, this.packetId, this.nbt);
        }
    }
}

