/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.INetworkItem;

public class PacketItemModifcation
extends BasePacket {
    NBTTagCompound nbt = new NBTTagCompound();
    byte packetId;
    int entityId;
    EntityPlayer entity;
    INetworkItem machine;

    public PacketItemModifcation() {
    }

    public PacketItemModifcation(INetworkItem machine, EntityPlayer entity, byte packetId) {
        this();
        this.machine = machine;
        this.entity = entity;
        this.packetId = packetId;
        this.entityId = entity.func_145782_y();
    }

    public PacketItemModifcation(INetworkItem machine, EntityPlayer entity, byte packetId, NBTTagCompound nbt) {
        this(machine, entity, packetId);
        this.nbt = nbt;
    }

    @Override
    public void write(ByteBuf out) {
        PacketBuffer buffer = new PacketBuffer(out);
        this.write(buffer);
    }

    private void write(PacketBuffer out) {
        out.writeInt(this.entity.field_70170_p.field_73011_w.field_76574_g);
        out.writeInt(this.entity.func_145782_y());
        out.writeByte((int)this.packetId);
        out.writeBoolean(!this.nbt.func_82582_d());
        if (!this.nbt.func_82582_d()) {
            try {
                out.func_150786_a(this.nbt);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.machine.writeDataToNetwork((ByteBuf)out, this.packetId, this.entity.func_70694_bm());
    }

    @Override
    public void read(ByteBuf in) {
        PacketBuffer buffer = new PacketBuffer(in);
        this.read(buffer, true);
    }

    public void read(PacketBuffer in, boolean server) {
        ItemStack itemStack;
        WorldServer world = DimensionManager.getWorld((int)in.readInt());
        int entityId = in.readInt();
        this.packetId = in.readByte();
        Entity ent = world.func_73045_a(entityId);
        if (in.readBoolean()) {
            NBTTagCompound nbt = null;
            try {
                nbt = in.func_150793_b();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.nbt = nbt;
        }
        if (ent != null && ent instanceof EntityPlayer && (itemStack = ((EntityPlayer)ent).func_70694_bm()) != null && itemStack.func_77973_b() instanceof INetworkItem) {
            ((INetworkItem)itemStack.func_77973_b()).readDataFromNetwork((ByteBuf)in, this.packetId, this.nbt, itemStack);
        }
    }

    public void execute(EntityPlayer player, Side side) {
        ItemStack itemStack;
        if (player != null && (itemStack = player.func_70694_bm()) != null && itemStack.func_77973_b() instanceof INetworkItem) {
            ((INetworkItem)itemStack.func_77973_b()).useNetworkData(player, side, this.packetId, this.nbt, itemStack);
        }
    }

    @Override
    public void executeServer(EntityPlayerMP player) {
        this.execute((EntityPlayer)player, Side.SERVER);
    }

    @Override
    public void executeClient(EntityPlayer player) {
        this.execute(player, Side.CLIENT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readClient(ByteBuf in) {
        ItemStack itemStack;
        PacketBuffer buffer = new PacketBuffer(in);
        buffer.readInt();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int entityId = buffer.readInt();
        this.packetId = buffer.readByte();
        Entity ent = world.func_73045_a(entityId);
        if (buffer.readBoolean()) {
            NBTTagCompound nbt = null;
            try {
                nbt = buffer.func_150793_b();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.nbt = nbt;
        }
        if (ent != null && ent instanceof EntityPlayer && (itemStack = ((EntityPlayer)ent).func_70694_bm()) != null && itemStack.func_77973_b() instanceof INetworkItem) {
            ((INetworkItem)itemStack.func_77973_b()).readDataFromNetwork(in, this.packetId, this.nbt, itemStack);
        }
    }
}

