/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.network;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.world.WorldServer;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.network.BasePacket;

public class PacketHandler {
    public static final EnumMap<Side, FMLEmbeddedChannel> channels = Maps.newEnumMap(Side.class);
    private static int discriminatorNumber = 0;
    static Codec codec = new Codec();

    public static void init() {
        if (!channels.isEmpty()) {
            return;
        }
        channels.putAll(NetworkRegistry.INSTANCE.newChannel("libVulpes", new ChannelHandler[]{codec, new HandlerServer()}));
        if (FMLCommonHandler.instance().getSide().isClient()) {
            FMLEmbeddedChannel channel = channels.get(Side.CLIENT);
            String codecName = channel.findChannelHandlerNameForType(Codec.class);
            channel.pipeline().addAfter(codecName, "ClientHandler", (ChannelHandler)new HandlerClient());
        }
    }

    public static final void addDiscriminator(Class<? extends BasePacket> clazz) {
        if (codec != null) {
            codec.addDiscriminator(discriminatorNumber, clazz);
            ++discriminatorNumber;
        } else {
            LibVulpes.logger.warning("Trying to register " + clazz.getName() + " after preinit!!");
        }
    }

    public static final void sendToServer(BasePacket packet) {
        channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channels.get(Side.CLIENT).writeOutbound(new Object[]{packet});
    }

    public static final void sendToPlayersTrackingEntity(BasePacket packet, Entity entity) {
        for (EntityPlayer player : ((WorldServer)entity.field_70170_p).func_73039_n().getTrackingPlayers(entity)) {
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
        }
    }

    public static final void sendToAll(BasePacket packet) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    public static final void sendToPlayer(BasePacket packet, EntityPlayer player) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    public static final void sendToDispatcher(BasePacket packet, NetworkManager netman) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DISPATCHER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)NetworkDispatcher.get((NetworkManager)netman));
        channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    public static final void sendToNearby(BasePacket packet, int dimId, int x, int y, int z, double dist) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(dimId, (double)x, (double)y, (double)z, dist));
        channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    @ChannelHandler.Sharable
    private static final class HandlerServer
    extends SimpleChannelInboundHandler<BasePacket> {
        private HandlerServer() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, BasePacket packet) throws Exception {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                return;
            }
            EntityPlayerMP player = ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
            packet.executeServer(player);
        }
    }

    @ChannelHandler.Sharable
    @SideOnly(value=Side.CLIENT)
    private static final class HandlerClient
    extends SimpleChannelInboundHandler<BasePacket> {
        private HandlerClient() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, BasePacket packet) throws Exception {
            Minecraft mc = Minecraft.func_71410_x();
            packet.executeClient((EntityPlayer)mc.field_71439_g);
        }
    }

    private static final class Codec
    extends FMLIndexedMessageToMessageCodec<BasePacket> {
        private Codec() {
        }

        public void encodeInto(ChannelHandlerContext ctx, BasePacket msg, ByteBuf data) throws Exception {
            msg.write(data);
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf data, BasePacket packet) {
            switch (FMLCommonHandler.instance().getEffectiveSide()) {
                case CLIENT: {
                    packet.readClient(data);
                    break;
                }
                case SERVER: {
                    INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                    packet.read(data);
                }
            }
        }
    }
}

