/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.network.BasePacket;

public class PacketEntity
extends BasePacket {
    INetworkEntity entity;
    NBTTagCompound nbt = new NBTTagCompound();
    byte packetId;

    public PacketEntity() {
    }

    public PacketEntity(INetworkEntity machine, byte packetId) {
        this();
        this.entity = machine;
        this.packetId = packetId;
    }

    public PacketEntity(INetworkEntity entity, byte packetId, NBTTagCompound nbt) {
        this(entity, packetId);
        this.nbt = nbt;
    }

    @Override
    public void write(ByteBuf out) {
        PacketBuffer buffer = new PacketBuffer(out);
        this.write(buffer);
    }

    private void write(PacketBuffer out) {
        out.writeInt(((Entity)this.entity).field_70170_p.field_73011_w.field_76574_g);
        out.writeInt(((Entity)this.entity).func_145782_y());
        out.writeByte((int)this.packetId);
        out.writeBoolean(!this.nbt.func_82582_d());
        if (!this.nbt.func_82582_d()) {
            try {
                out.func_150786_a(this.nbt);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.entity.writeDataToNetwork((ByteBuf)out, this.packetId);
    }

    @Override
    public void read(ByteBuf in) {
        PacketBuffer buffer = new PacketBuffer(in);
        this.read(buffer, true);
    }

    public void read(PacketBuffer in, boolean server) {
        WorldServer world = DimensionManager.getWorld((int)in.readInt());
        int entityId = in.readInt();
        this.packetId = in.readByte();
        Entity ent = world.func_73045_a(entityId);
        if (in.readBoolean()) {
            NBTTagCompound nbt = null;
            try {
                nbt = in.func_150793_b();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.nbt = nbt;
        }
        if (ent != null && ent instanceof INetworkEntity) {
            this.entity = (INetworkEntity)ent;
            this.entity.readDataFromNetwork((ByteBuf)in, this.packetId, this.nbt);
        }
    }

    public void execute(EntityPlayer player, Side side) {
        if (this.entity != null) {
            this.entity.useNetworkData(player, side, this.packetId, this.nbt);
        }
    }

    @Override
    public void executeServer(EntityPlayerMP player) {
        this.execute((EntityPlayer)player, Side.SERVER);
    }

    @Override
    public void executeClient(EntityPlayer player) {
        this.execute(player, Side.CLIENT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readClient(ByteBuf in) {
        PacketBuffer buffer = new PacketBuffer(in);
        buffer.readInt();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int entityId = buffer.readInt();
        this.packetId = buffer.readByte();
        Entity ent = world.func_73045_a(entityId);
        if (buffer.readBoolean()) {
            NBTTagCompound nbt = null;
            try {
                nbt = buffer.func_150793_b();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.nbt = nbt;
        }
        if (ent != null && ent instanceof INetworkEntity) {
            this.entity = (INetworkEntity)ent;
            this.entity.readDataFromNetwork((ByteBuf)buffer, this.packetId, this.nbt);
        }
    }
}

