/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public abstract class BasePacket {
    public static final String CHANNEL = "advancedRocketry";
    private static final BiMap<Integer, Class<? extends BasePacket>> idMap;

    public static BasePacket constructPacket(int packetId) throws ProtocolException, InstantiationException, IllegalAccessException {
        Class clazz = (Class)idMap.get((Object)packetId);
        if (clazz == null) {
            throw new ProtocolException("Protocol Exception!  Unknown Packet Id!");
        }
        return (BasePacket)clazz.newInstance();
    }

    public final int getPacketId() {
        if (idMap.inverse().containsKey(this.getClass())) {
            return (Integer)idMap.inverse().get(this.getClass());
        }
        throw new RuntimeException("Packet " + this.getClass().getSimpleName() + " is a missing mapping!");
    }

    public abstract void write(ByteBuf var1);

    public abstract void readClient(ByteBuf var1);

    public abstract void read(ByteBuf var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void executeClient(EntityPlayer var1);

    public abstract void executeServer(EntityPlayerMP var1);

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        idMap = builder.build();
    }

    public static class ProtocolException
    extends Exception {
        public ProtocolException() {
        }

        public ProtocolException(String message, Throwable cause) {
            super(message, cause);
        }

        public ProtocolException(String message) {
            super(message);
        }

        public ProtocolException(Throwable cause) {
            super(cause);
        }
    }
}

