/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.items;

import com.mojang.realmsclient.gui.ChatFormatting;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.block.BlockTile;
import zmaster587.libVulpes.block.multiblock.BlockMultiblockMachine;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.network.INetworkItem;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketItemModifcation;
import zmaster587.libVulpes.tile.TileSchematic;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.TilePlaceholder;
import zmaster587.libVulpes.util.BlockPosition;
import zmaster587.libVulpes.util.Vector3F;
import zmaster587.libVulpes.util.ZUtils;

public class ItemProjector
extends Item
implements IModularInventory,
IButtonInventory,
INetworkItem {
    ArrayList<TileMultiBlock> machineList = new ArrayList();
    ArrayList<BlockTile> blockList = new ArrayList();
    ArrayList<String> descriptionList = new ArrayList();
    private static final String IDNAME = "machineId";

    public void registerMachine(TileMultiBlock multiblock, BlockTile mainBlock) {
        this.machineList.add(multiblock);
        this.blockList.add(mainBlock);
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        Object[][][] structure = multiblock.getStructure();
        for (int i = 0; i < structure.length; ++i) {
            for (int j = 0; j < structure[i].length; ++j) {
                for (int k = 0; k < structure[i][j].length; ++k) {
                    Object o = structure[i][j][k];
                    if (!map.containsKey(o)) {
                        map.put(o, 1);
                        continue;
                    }
                    map.put(o, (Integer)map.get(o) + 1);
                }
            }
        }
        String str = Item.func_150898_a((Block)mainBlock).func_77653_i(new ItemStack((Block)mainBlock)) + " x1\n";
        for (Map.Entry entry : map.entrySet()) {
            List<BlockMeta> blockMeta = multiblock.getAllowableBlocks(entry.getKey());
            if (blockMeta.isEmpty() || Item.func_150898_a((Block)blockMeta.get(0).getBlock()) == null) continue;
            for (int i = 0; i < blockMeta.size(); ++i) {
                String itemStr = Item.func_150898_a((Block)blockMeta.get(i).getBlock()).func_77653_i(new ItemStack(blockMeta.get(i).getBlock(), 1, (int)blockMeta.get(i).getMeta()));
                if (itemStr.contains("tile.")) continue;
                str = str + itemStr;
                str = str + " or ";
            }
            if (str.endsWith(" or ")) {
                str = str.substring(0, str.length() - 4);
            }
            str = str + " x" + entry.getValue() + "\n";
        }
        this.descriptionList.add(str);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void mouseEvent(MouseEvent event) {
        ItemStack stack;
        if (Minecraft.func_71410_x().field_71439_g.func_70093_af() && event.dwheel != 0 && (stack = Minecraft.func_71410_x().field_71439_g.func_70694_bm()) != null && stack.func_77973_b() == this && this.getMachineId(stack) != -1) {
            if (event.dwheel < 0) {
                this.setYLevel(stack, this.getYLevel(stack) + 1);
            } else {
                this.setYLevel(stack, this.getYLevel(stack) - 1);
            }
            event.setCanceled(true);
            PacketHandler.sendToServer(new PacketItemModifcation(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 1));
        }
    }

    private void clearStructure(World world, TileMultiBlock tile, ItemStack stack) {
        int id = this.getMachineId(stack);
        ForgeDirection direction = ForgeDirection.getOrientation((int)this.getDirection(stack));
        TileMultiBlock multiblock = this.machineList.get(id);
        int prevMachineId = this.getPrevMachineId(stack);
        if (prevMachineId >= 0 && prevMachineId < this.machineList.size()) {
            Object[][][] structure = this.machineList.get(prevMachineId).getStructure();
            Vector3F<Integer> basepos = this.getBasePosition(stack);
            for (int y = 0; y < structure.length; ++y) {
                for (int z = 0; z < structure[0].length; ++z) {
                    for (int x = 0; x < structure[0][0].length; ++x) {
                        int globalX = (Integer)basepos.x - x * direction.offsetZ + z * direction.offsetX;
                        int globalZ = (Integer)basepos.z + x * direction.offsetX + z * direction.offsetZ;
                        if (world.func_147439_a(globalX, (Integer)basepos.y + y, globalZ) != LibVulpesBlocks.blockPhantom) continue;
                        world.func_147468_f(globalX, (Integer)basepos.y + y, globalZ);
                    }
                }
            }
        }
    }

    private void RebuildStructure(World world, TileMultiBlock tile, ItemStack stack, int posX, int posY, int posZ, ForgeDirection orientation) {
        int endNumber;
        int startNumber;
        int id = this.getMachineId(stack);
        ForgeDirection direction = ForgeDirection.getOrientation((int)this.getDirection(stack));
        TileMultiBlock multiblock = this.machineList.get(id);
        this.clearStructure(world, tile, stack);
        Object[][][] structure = multiblock.getStructure();
        direction = orientation;
        int y = this.getYLevel(stack);
        if (y == -1) {
            startNumber = 0;
            endNumber = structure.length;
        } else {
            startNumber = y;
            endNumber = y + 1;
        }
        for (y = startNumber; y < endNumber; ++y) {
            for (int z = 0; z < structure[0].length; ++z) {
                for (int x = 0; x < structure[0][0].length; ++x) {
                    List<Object> block;
                    if (structure[y][z][x] instanceof Character && ((Character)structure[y][z][x]).charValue() == 'c') {
                        block = new ArrayList<BlockMeta>();
                        block.add(new BlockMeta(this.blockList.get(id), orientation.ordinal()));
                    } else {
                        if (multiblock.getAllowableBlocks(structure[y][z][x]).isEmpty()) continue;
                        block = multiblock.getAllowableBlocks(structure[y][z][x]);
                    }
                    int globalX = posX - x * direction.offsetZ + z * direction.offsetX;
                    int globalZ = posZ + x * direction.offsetX + z * direction.offsetZ;
                    int globalY = -y + structure.length + posY - 1;
                    if (!world.func_147437_c(globalX, globalY, globalZ) && !world.func_147439_a(globalX, globalY, globalZ).isReplaceable((IBlockAccess)world, globalX, globalY, globalZ) || ((BlockMeta)block.get(0)).getBlock().func_149688_o() == Material.field_151579_a) continue;
                    world.func_147465_d(globalX, globalY, globalZ, LibVulpesBlocks.blockPhantom, (int)((BlockMeta)block.get(0)).getMeta(), 3);
                    TileEntity newTile = world.func_147438_o(globalX, globalY, globalZ);
                    if (!(newTile instanceof TilePlaceholder)) continue;
                    ((TileSchematic)newTile).setReplacedBlock(block);
                    ((TilePlaceholder)newTile).setReplacedTileEntity(((BlockMeta)block.get(0)).getBlock().createTileEntity(null, 0));
                }
            }
        }
        this.setPrevMachineId(stack, id);
        this.setBasePosition(stack, posX, posY, posZ);
        this.setDirection(stack, orientation.ordinal());
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70093_af()) {
            player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARNOINV.ordinal(), world, -1, -1, 0);
            return super.func_77659_a(stack, world, player);
        }
        int id = this.getMachineId(stack);
        if (!player.func_70093_af() && id != -1 && world.field_72995_K) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)ZUtils.getDirectionFacing(player.field_70177_z - 180.0f));
            TileMultiBlock tile = this.machineList.get(this.getMachineId(stack));
            int x = tile.getStructure()[0][0].length;
            int z = tile.getStructure()[0].length;
            int globalX = (-x * dir.offsetZ + z * dir.offsetX) / 2;
            int globalZ = (x * dir.offsetX + z * dir.offsetZ) / 2;
            MovingObjectPosition pos = Minecraft.func_71410_x().field_71476_x;
            TileEntity tile2 = world.func_147438_o(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            if (tile2 instanceof TileMultiBlock) {
                for (TileMultiBlock tiles : this.machineList) {
                    if (tile2.getClass() != ((Object)((Object)tiles)).getClass()) continue;
                    this.setMachineId(stack, this.machineList.indexOf((Object)tiles));
                    Object[][][] structure = tiles.getStructure();
                    BlockPosition controller = this.getControllerOffset(structure);
                    dir = BlockMultiblockMachine.getFront(tile2.func_145832_p()).getOpposite();
                    controller.y = (short)(structure.length - controller.y);
                    globalX = -controller.x * dir.offsetZ + controller.z * dir.offsetX;
                    globalZ = controller.x * dir.offsetX + controller.z * dir.offsetZ;
                    this.setDirection(stack, dir.ordinal());
                    this.setBasePosition(stack, pos.field_72311_b - globalX, pos.field_72312_c - controller.y + 1, pos.field_72309_d - globalZ);
                    PacketHandler.sendToServer(new PacketItemModifcation(this, player, 0));
                    PacketHandler.sendToServer(new PacketItemModifcation(this, player, 2));
                    return super.func_77659_a(stack, world, player);
                }
            }
            if (pos.field_72310_e == 0) {
                this.setBasePosition(stack, pos.field_72311_b - globalX, pos.field_72312_c - tile.getStructure().length, pos.field_72309_d - globalZ);
            } else {
                this.setBasePosition(stack, pos.field_72311_b - globalX, pos.field_72312_c + 1, pos.field_72309_d - globalZ);
            }
            this.setDirection(stack, dir.ordinal());
            PacketHandler.sendToServer(new PacketItemModifcation(this, player, 2));
        }
        return super.func_77659_a(stack, world, player);
    }

    protected BlockPosition getControllerOffset(Object[][][] structure) {
        for (int y = 0; y < structure.length; ++y) {
            for (int z = 0; z < structure[0].length; ++z) {
                for (int x = 0; x < structure[0][0].length; ++x) {
                    if (!(structure[y][z][x] instanceof Character) || ((Character)structure[y][z][x]).charValue() != 'c') continue;
                    return new BlockPosition(x, y, z);
                }
            }
        }
        return null;
    }

    @Override
    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        LinkedList<ModuleBase> btns = new LinkedList<ModuleBase>();
        for (int i = 0; i < this.machineList.size(); ++i) {
            TileMultiBlock multiblock = this.machineList.get(i);
            btns.add(new ModuleButton(60, 4 + i * 24, i, LibVulpes.proxy.getLocalizedString(multiblock.getMachineName()), this, TextureResources.buttonBuild));
        }
        ModuleContainerPan panningContainer = new ModuleContainerPan(5, 20, btns, new LinkedList<ModuleBase>(), TextureResources.starryBG, 160, 100, 0, 500);
        modules.add(panningContainer);
        return modules;
    }

    @Override
    public String getModularInventoryName() {
        return "item.holoProjector.name";
    }

    @Override
    public boolean canInteractWithContainer(EntityPlayer entity) {
        return entity != null && !entity.field_70128_L && entity.func_70694_bm() != null && entity.func_70694_bm().func_77973_b() == this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onInventoryButtonPressed(int buttonId) {
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        if (stack != null && stack.func_77973_b() == this) {
            this.setMachineId(stack, buttonId);
            PacketHandler.sendToServer(new PacketItemModifcation(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0));
        }
    }

    private void setMachineId(ItemStack stack, int id) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a(IDNAME, id);
        stack.func_77982_d(nbt);
    }

    private int getMachineId(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e(IDNAME);
        }
        return -1;
    }

    private void setYLevel(ItemStack stack, int level) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TileMultiBlock machine = this.machineList.get(this.getMachineId(stack));
        if (level == -2) {
            level = machine.getStructure().length - 1;
        } else if (level == machine.getStructure().length) {
            level = -1;
        }
        nbt.func_74768_a("yOffset", level);
        stack.func_77982_d(nbt);
    }

    private int getYLevel(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("yOffset");
        }
        return -1;
    }

    private void setPrevMachineId(ItemStack stack, int id) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("machineIdPrev", id);
        stack.func_77982_d(nbt);
    }

    private int getPrevMachineId(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("machineIdPrev");
        }
        return -1;
    }

    private Vector3F<Integer> getBasePosition(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            Vector3F<Integer> vec = new Vector3F<Integer>(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
            return vec;
        }
        return null;
    }

    private void setBasePosition(ItemStack stack, int x, int y, int z) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("x", x);
        nbt.func_74768_a("y", y);
        nbt.func_74768_a("z", z);
        stack.func_77982_d(nbt);
    }

    public int getDirection(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("dir");
        }
        return -1;
    }

    public void setDirection(ItemStack stack, int dir) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("dir", dir);
        stack.func_77982_d(nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        super.func_77624_a(stack, player, list, bool);
        list.add("Shift right-click: opens machine selection interface");
        list.add("Shift-scroll: moves cross-section");
        int id = this.getMachineId(stack);
        if (id != -1) {
            String[] strList;
            list.add("");
            list.add(ChatFormatting.GREEN + LibVulpes.proxy.getLocalizedString(this.machineList.get(id).getMachineName()));
            String str = this.descriptionList.get(id);
            for (String s : strList = str.split("\n")) {
                list.add(s);
            }
        }
    }

    @Override
    public void writeDataToNetwork(ByteBuf out, byte id, ItemStack stack) {
        if (id == 0) {
            out.writeInt(this.getMachineId(stack));
        } else if (id == 1) {
            out.writeInt(this.getYLevel(stack));
        } else if (id == 2) {
            Vector3F<Integer> pos = this.getBasePosition(stack);
            out.writeInt(((Integer)pos.x).intValue());
            out.writeInt(((Integer)pos.y).intValue());
            out.writeInt(((Integer)pos.z).intValue());
            out.writeInt(this.getDirection(stack));
        }
    }

    @Override
    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt, ItemStack stack) {
        if (packetId == 0) {
            nbt.func_74768_a(IDNAME, in.readInt());
        } else if (packetId == 1) {
            nbt.func_74768_a("yLevel", in.readInt());
        } else if (packetId == 2) {
            nbt.func_74768_a("x", in.readInt());
            nbt.func_74768_a("y", in.readInt());
            nbt.func_74768_a("z", in.readInt());
            nbt.func_74768_a("dir", in.readInt());
        }
    }

    @Override
    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt, ItemStack stack) {
        if (id == 0) {
            int machineId = nbt.func_74762_e(IDNAME);
            this.setMachineId(stack, nbt.func_74762_e(IDNAME));
            TileMultiBlock tile = this.machineList.get(machineId);
            this.setYLevel(stack, tile.getStructure().length - 1);
        } else if (id == 1) {
            this.setYLevel(stack, nbt.func_74762_e("yLevel"));
            Vector3F<Integer> vec = this.getBasePosition(stack);
            this.RebuildStructure(player.field_70170_p, this.machineList.get(this.getMachineId(stack)), stack, (Integer)vec.x, (Integer)vec.y, (Integer)vec.z, ForgeDirection.getOrientation((int)this.getDirection(stack)));
        } else if (id == 2) {
            int x = nbt.func_74762_e("x");
            int y = nbt.func_74762_e("y");
            int z = nbt.func_74762_e("z");
            int dir = nbt.func_74762_e("dir");
            if (this.getMachineId(stack) != -1) {
                this.RebuildStructure(player.field_70170_p, this.machineList.get(this.getMachineId(stack)), stack, x, y, z, ForgeDirection.getOrientation((int)dir));
            }
        }
    }
}

