/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.items;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.util.BlockPosition;

public class ItemLinker
extends Item {
    protected int linkX;
    protected int linkY;
    protected int linkZ;
    protected int dimId;
    private static final int EMPTYSETTING = 0;

    public ItemLinker() {
        this.field_77777_bU = 1;
        this.func_77637_a(CreativeTabs.field_78029_e);
        this.dimId = 0;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        int y = ItemLinker.getMasterY(par1ItemStack);
        if (y == 0) {
            par3List.add("Coords unset!");
        } else {
            par3List.add("X: " + ItemLinker.getMasterX(par1ItemStack));
            par3List.add("Y: " + ItemLinker.getMasterY(par1ItemStack));
            par3List.add("Z: " + ItemLinker.getMasterZ(par1ItemStack));
            int dimId = ItemLinker.getDimId(par1ItemStack);
            if (dimId != -1) {
                par3List.add("Dim: " + dimId);
            }
        }
    }

    public static boolean isSet(ItemStack stack) {
        return ItemLinker.getMasterY(stack) != 0;
    }

    public static int getMasterX(ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        nbt = nbt.func_74775_l("MasterPos");
        return nbt.func_74762_e("MasterX");
    }

    public static int getMasterY(ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt == null) {
            return 0;
        }
        nbt = nbt.func_74775_l("MasterPos");
        return nbt.func_74762_e("MasterY");
    }

    public static int getMasterZ(ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        nbt = nbt.func_74775_l("MasterPos");
        return nbt.func_74762_e("MasterZ");
    }

    public static void setDimId(ItemStack itemStack, int id) {
        NBTTagCompound nbt;
        if (!itemStack.func_77942_o()) {
            nbt = new NBTTagCompound();
            itemStack.func_77982_d(nbt);
        } else {
            nbt = itemStack.func_77978_p();
        }
        nbt.func_74768_a("dimId", id);
    }

    public static int getDimId(ItemStack itemStack) {
        NBTTagCompound nbt = !itemStack.func_77942_o() ? new NBTTagCompound() : itemStack.func_77978_p();
        return nbt.func_74764_b("dimId") ? nbt.func_74762_e("dimId") : -1;
    }

    public static void setMasterX(ItemStack itemStack, int num) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        nbt = nbt.func_74775_l("MasterPos");
        nbt.func_74768_a("MasterX", num);
    }

    public static void setMasterY(ItemStack itemStack, int num) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        nbt = nbt.func_74775_l("MasterPos");
        nbt.func_74768_a("MasterY", num);
    }

    public static void setMasterZ(ItemStack itemStack, int num) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        nbt = nbt.func_74775_l("MasterPos");
        nbt.func_74768_a("MasterZ", num);
    }

    public static void setMasterCoords(ItemStack stack, int x, int y, int z) {
        if (!stack.func_77942_o()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("MasterPos", (NBTBase)new NBTTagCompound());
            stack.func_77982_d(nbt);
        }
        ItemLinker.setMasterX(stack, x);
        ItemLinker.setMasterY(stack, y);
        ItemLinker.setMasterZ(stack, z);
    }

    public static void resetPosition(ItemStack itemStack) {
        NBTTagCompound position = new NBTTagCompound();
        position.func_74768_a("MasterX", 0);
        position.func_74768_a("MasterY", 0);
        position.func_74768_a("MasterZ", 0);
        position.func_74768_a("dimId", -1);
        itemStack.func_77983_a("MasterPos", (NBTBase)position);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            ItemLinker.resetPosition(stack);
        }
        return super.func_77659_a(stack, world, player);
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        TileEntity entity = world.func_147438_o(par4, par5, par6);
        if (entity != null) {
            if (entity instanceof ILinkableTile) {
                this.applySettings(itemStack, (ILinkableTile)entity, player, world);
                return true;
            }
        } else if (player.func_70093_af()) {
            ItemLinker.resetPosition(itemStack);
            return true;
        }
        return false;
    }

    protected void applySettings(ItemStack itemStack, ILinkableTile pad, EntityPlayer player, World world) {
        if (!ItemLinker.isSet(itemStack)) {
            pad.onLinkStart(itemStack, (TileEntity)pad, player, world);
        } else {
            pad.onLinkComplete(itemStack, (TileEntity)pad, player, world);
        }
    }

    public static BlockPosition getMasterCoords(ItemStack item) {
        return new BlockPosition(ItemLinker.getMasterX(item), ItemLinker.getMasterY(item), ItemLinker.getMasterZ(item));
    }
}

