/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.util.ResourceLocation;
import zmaster587.libVulpes.gui.GuiToggleButtonImage;
import zmaster587.libVulpes.inventory.modules.IToggleButton;
import zmaster587.libVulpes.inventory.modules.ModuleButton;

public class ModuleToggleSwitch
extends ModuleButton {
    GuiToggleButtonImage enabledButton;
    boolean currentState;
    boolean prevState;
    IToggleButton tile;
    boolean enabled = true;

    public ModuleToggleSwitch(int offsetX, int offsetY, int buttonId, String text, IToggleButton tile, ResourceLocation[] buttonImages, boolean defaultState) {
        super(offsetX, offsetY, buttonId, text, tile, buttonImages);
        this.tile = tile;
        this.currentState = defaultState;
    }

    public ModuleToggleSwitch(int offsetX, int offsetY, int buttonId, String text, IToggleButton tile, ResourceLocation[] buttonImages, String tooltipText, boolean defaultState) {
        super(offsetX, offsetY, buttonId, text, tile, buttonImages, tooltipText);
        this.tile = tile;
        this.currentState = defaultState;
    }

    public ModuleToggleSwitch(int offsetX, int offsetY, int buttonId, String text, IToggleButton tile, ResourceLocation[] buttonImages, int sizeX, int sizeY, boolean defaultState) {
        super(offsetX, offsetY, buttonId, text, tile, buttonImages, sizeX, sizeY);
        this.tile = tile;
        this.currentState = defaultState;
    }

    public ModuleToggleSwitch(int offsetX, int offsetY, int buttonId, String text, IToggleButton tile, ResourceLocation[] buttonImages, String tooltipText, int sizeX, int sizeY, boolean defaultState) {
        super(offsetX, offsetY, buttonId, text, tile, buttonImages, tooltipText, sizeX, sizeY);
        this.tile = tile;
        this.currentState = defaultState;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiButton> addButtons(int x, int y) {
        LinkedList<GuiButton> list = new LinkedList<GuiButton>();
        this.enabledButton = new GuiToggleButtonImage(0, x + this.offsetX, y + this.offsetY, this.sizeX, this.sizeY, this.buttonImages);
        this.enabledButton.setState(this.currentState);
        list.add(this.enabledButton);
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionPerform(GuiButton button) {
        if (this.enabled && button == this.enabledButton) {
            this.currentState = !this.currentState;
            this.tile.onInventoryButtonPressed(this.buttonId);
        }
    }

    public void setToggleState(boolean state) {
        this.currentState = state;
    }

    public boolean getState() {
        return this.currentState;
    }

    @Override
    public boolean needsUpdate(int localId) {
        return this.prevState != this.currentState;
    }

    @Override
    public void onChangeRecieved(int slot, int value) {
        this.setToggleState(value == 1);
    }

    @Override
    protected void updatePreviousState(int localId) {
        this.prevState = this.currentState;
    }

    @Override
    public void sendChanges(Container container, ICrafting crafter, int variableId, int localId) {
        crafter.func_71112_a(container, variableId, this.currentState ? 1 : 0);
    }

    public boolean isButton(GuiButton button) {
        return button == this.enabledButton;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBackground(GuiContainer gui, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        super.renderBackground(gui, x, y, mouseX, mouseY, font);
        this.enabledButton.setState(this.currentState);
    }
}

