/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.lwjgl.opengl.GL11;
import zmaster587.libVulpes.inventory.modules.ModuleBase;

public class ModuleLiquidIndicator
extends ModuleBase {
    IFluidHandler tile;
    int prevLiquidUUID;
    int prevLiquidAmt;
    private static final int invalidFluid = -1;

    public ModuleLiquidIndicator(int offsetX, int offsetY, IFluidHandler progress) {
        super(offsetX, offsetY);
        this.tile = progress;
    }

    @Override
    public int numberOfChangesToSend() {
        return 3;
    }

    @Override
    public void sendChanges(Container container, ICrafting crafter, int variableId, int localId) {
        FluidTankInfo info = this.tile.getTankInfo(ForgeDirection.UNKNOWN)[0];
        if (localId == 0 && info.fluid != null) {
            crafter.func_71112_a(container, variableId, info.fluid.amount & 0xFFFF);
        } else if (localId == 1 && info.fluid != null) {
            crafter.func_71112_a(container, variableId, info.fluid.amount >>> 16 & 0xFFFF);
        } else if (localId == 2) {
            if (info.fluid == null) {
                crafter.func_71112_a(container, variableId, -1);
            } else {
                crafter.func_71112_a(container, variableId, info.fluid.getFluidID());
            }
        }
    }

    @Override
    public void onChangeRecieved(int slot, int value) {
        FluidTankInfo[] info = this.tile.getTankInfo(ForgeDirection.UNKNOWN);
        if (slot == 2) {
            if (info[0].fluid == null && value != -1) {
                this.tile.fill(ForgeDirection.UNKNOWN, new FluidStack(FluidRegistry.getFluid((int)value), 1), true);
            } else if (value == -1) {
                this.tile.drain(ForgeDirection.UNKNOWN, info[0].capacity, true);
            } else if (info[0].fluid != null && value != info[0].fluid.getFluidID()) {
                FluidStack stack = this.tile.drain(ForgeDirection.UNKNOWN, info[0].capacity, true);
                stack = new FluidStack(FluidRegistry.getFluid((int)stack.getFluidID()), stack.amount);
                this.tile.fill(ForgeDirection.UNKNOWN, stack, true);
            }
        } else if ((slot == 0 || slot == 1) && info[0].fluid != null) {
            int difference = slot == 0 ? (value & 0xFFFF) - (info[0].fluid.amount & 0xFFFF) : (value << 16 & 0xFFFF0000) - (info[0].fluid.amount & 0xFFFF0000);
            if (difference > 0) {
                this.tile.fill(ForgeDirection.UNKNOWN, new FluidStack(info[0].fluid.getFluid(), difference), true);
            } else {
                this.tile.drain(ForgeDirection.UNKNOWN, -difference, true);
            }
        }
    }

    @Override
    public boolean needsUpdate(int localId) {
        FluidTankInfo info = this.tile.getTankInfo(ForgeDirection.UNKNOWN)[0];
        if (localId == 0 || localId == 1) {
            return info.fluid != null && this.prevLiquidAmt != info.fluid.amount;
        }
        if (localId == 2) {
            if (info.fluid == null) {
                return this.prevLiquidUUID != -1;
            }
            return info.fluid.getFluidID() != this.prevLiquidUUID;
        }
        return false;
    }

    @Override
    protected void updatePreviousState(int localId) {
        FluidTankInfo info = this.tile.getTankInfo(ForgeDirection.UNKNOWN)[0];
        if (localId == 0 && info.fluid != null) {
            this.prevLiquidAmt = info.fluid.amount;
        } else if (localId == 1) {
            this.prevLiquidUUID = info.fluid == null ? -1 : info.fluid.getFluidID();
        }
    }

    protected float getProgress() {
        FluidTankInfo[] info = this.tile.getTankInfo(ForgeDirection.UNKNOWN);
        int capacity = 0;
        int fillAmount = 0;
        for (FluidTankInfo fluidInfo : info) {
            capacity += fluidInfo.capacity;
            if (fluidInfo.fluid == null) continue;
            fillAmount += fluidInfo.fluid.amount;
        }
        return (float)fillAmount / (float)capacity;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderForeground(int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, GuiContainer gui, FontRenderer font) {
        int relativeX = mouseX - this.offsetX;
        int relativeY = mouseY - this.offsetY;
        int ySize = 52;
        int xSize = 12;
        if (relativeX > 0 && relativeX < xSize && relativeY > 0 && relativeY < ySize) {
            LinkedList<String> list = new LinkedList<String>();
            FluidStack fluidStack = this.tile.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
            if (fluidStack != null) {
                list.add(fluidStack.getLocalizedName() + ": " + fluidStack.amount + " / " + this.tile.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].capacity + " mB");
            } else {
                list.add("Empty");
            }
            this.drawTooltip(gui, list, mouseX, mouseY, zLevel, font);
        }
    }

    @Override
    public void renderBackground(GuiContainer gui, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        super.renderBackground(gui, x, y, mouseX, mouseY, font);
        gui.func_73729_b(x + this.offsetX, y + this.offsetY, 176, 58, 14, 54);
        FluidTankInfo info = this.tile.getTankInfo(ForgeDirection.UNKNOWN)[0];
        if (info.fluid != null) {
            IIcon fluidIcon = info.fluid.getFluid().getIcon();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            int color = info.fluid.getFluid().getColor(info.fluid);
            GL11.glColor3b((byte)((byte)(color >> 16 & 0x7F)), (byte)((byte)(color >> 8 & 0x7F)), (byte)((byte)(color & 0x7F)));
            float percent = this.getProgress();
            int ySize = 52;
            int xSize = 12;
            if (fluidIcon != null) {
                gui.func_94065_a(this.offsetX + x + 1, this.offsetY + y + 1 + (ySize - (int)(percent * (float)ySize)), fluidIcon, xSize, (int)(percent * (float)ySize));
            }
            GL11.glColor3b((byte)127, (byte)127, (byte)127);
        }
    }
}

