/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import zmaster587.libVulpes.inventory.GuiModular;
import zmaster587.libVulpes.inventory.modules.ModuleBase;

public class ModuleContainerPan
extends ModuleBase {
    protected int currentPosX;
    protected int currentPosY;
    protected int screenSizeX;
    protected int screenSizeY;
    protected int containerSizeX;
    protected int containerSizeY;
    protected List<ModuleBase> moduleList;
    protected List<ModuleBase> staticModuleList;
    protected List<GuiButton> buttonList;
    protected List<GuiButton> staticButtonList;
    protected List<Slot> slotList;
    protected int mouseLastX;
    protected int mouseLastY;
    boolean outofBounds;
    ResourceLocation backdrop;
    protected int internalOffsetX;
    protected int internalOffsetY;

    public ModuleContainerPan(int offsetX, int offsetY, List<ModuleBase> moduleList, List<ModuleBase> staticModules, ResourceLocation backdrop, int screenSizeX, int screenSizeY) {
        this(offsetX, offsetY, moduleList, staticModules, backdrop, screenSizeX, screenSizeY, 16, 16, 0, 0);
    }

    public ModuleContainerPan(int offsetX, int offsetY, List<ModuleBase> moduleList, List<ModuleBase> staticModules, ResourceLocation backdrop, int screenSizeX, int screenSizeY, int paddingX, int paddingY) {
        this(offsetX, offsetY, moduleList, staticModules, backdrop, screenSizeX, screenSizeY, paddingX, paddingY, 0, 0);
    }

    public ModuleContainerPan(int offsetX, int offsetY, List<ModuleBase> moduleList, List<ModuleBase> staticModules, ResourceLocation backdrop, int screenSizeX, int screenSizeY, int paddingX, int paddingY, int containerSizeX, int containerSizeY) {
        super(offsetX, offsetY);
        this.moduleList = moduleList;
        this.staticModuleList = staticModules;
        this.outofBounds = true;
        this.screenSizeX = screenSizeX;
        this.screenSizeY = screenSizeY;
        this.buttonList = new LinkedList<GuiButton>();
        this.staticButtonList = new LinkedList<GuiButton>();
        this.slotList = new LinkedList<Slot>();
        this.backdrop = backdrop;
        if (containerSizeX == 0 || containerSizeY == 0) {
            int maxX = 0;
            int maxY = 0;
            for (ModuleBase module : moduleList) {
                if (module.offsetX > maxX) {
                    maxX = module.offsetX;
                }
                if (module.offsetY <= maxY) continue;
                maxY = module.offsetY;
            }
            this.containerSizeX = maxX + paddingX;
            this.containerSizeY = maxY + paddingY;
        } else {
            this.containerSizeX = containerSizeX;
            this.containerSizeY = containerSizeY;
        }
        if (moduleList != null) {
            for (ModuleBase module : this.moduleList) {
                module.offsetX += offsetX;
                module.offsetY += offsetY;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiButton> addButtons(int x, int y) {
        this.buttonList.clear();
        this.staticButtonList.clear();
        for (ModuleBase module : this.moduleList) {
            this.buttonList.addAll(module.addButtons(x, y));
        }
        for (ModuleBase module : this.staticModuleList) {
            this.staticButtonList.addAll(module.addButtons(x, y));
        }
        return new LinkedList<GuiButton>();
    }

    public void setOffset(int x, int y) {
        this.internalOffsetX = x + this.screenSizeX;
        this.internalOffsetY = y + this.screenSizeY;
    }

    public void setOffset2(int x, int y) {
        int deltaX = -x - this.currentPosX;
        int deltaY = -y - this.currentPosY;
        this.currentPosX += deltaX;
        this.currentPosY += deltaY;
        for (Slot slot : this.slotList) {
            slot.field_75223_e += deltaX;
            slot.field_75221_f += deltaX;
        }
        for (GuiButton button2 : this.buttonList) {
            button2.field_146128_h += deltaX;
            button2.field_146129_i += deltaY;
        }
        for (ModuleBase module : this.moduleList) {
            module.offsetX += deltaX;
            module.offsetY += deltaY;
        }
    }

    public int getScrollX() {
        return this.currentPosX;
    }

    public int getScrollY() {
        return this.currentPosY;
    }

    @Override
    public List<Slot> getSlots(Container container) {
        LinkedList<Slot> list = new LinkedList<Slot>();
        for (ModuleBase module : this.moduleList) {
            list.addAll(module.getSlots(container));
        }
        for (ModuleBase module : this.staticModuleList) {
            list.addAll(module.getSlots(container));
        }
        this.slotList = list;
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionPerform(GuiButton button) {
        for (ModuleBase module : this.moduleList) {
            module.actionPerform(button);
        }
        for (ModuleBase module : this.staticModuleList) {
            module.actionPerform(button);
        }
    }

    public void onScroll(int dwheel) {
        if (dwheel < 0) {
            this.moveContainerInterior(0, -20);
        } else if (dwheel > 0) {
            this.moveContainerInterior(0, 20);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderForeground(int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, GuiContainer gui, FontRenderer font) {
        int d;
        if (this.isMouseInBounds(0, 0, mouseX, mouseY) && (d = Mouse.getDWheel()) != 0) {
            this.onScroll(d);
        }
        GL11.glEnable((int)3089);
        this.setUpScissor(gui, this.offsetX + guiOffsetX, guiOffsetY + this.offsetY, this.offsetX + this.screenSizeX, this.offsetY + this.screenSizeY);
        for (ModuleBase module : this.moduleList) {
            module.renderForeground(guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        }
        for (ModuleBase module : this.staticModuleList) {
            module.renderForeground(guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        }
        GL11.glDisable((int)3089);
    }

    @SideOnly(value=Side.CLIENT)
    protected void setUpScissor(GuiContainer gui, int screenOffsetX, int screenOffsetY, int screenSizeX, int screenSizeY) {
        float multiplierX = (float)gui.field_146297_k.field_71443_c / (float)gui.field_146294_l;
        float multiplierY = (float)gui.field_146297_k.field_71440_d / (float)gui.field_146295_m;
        GL11.glScissor((int)((int)((float)screenOffsetX * multiplierX)), (int)(gui.field_146297_k.field_71440_d - (int)((float)(screenOffsetY + screenSizeY) * multiplierY)), (int)((int)((float)screenSizeX * multiplierX)), (int)((int)((float)screenSizeY * multiplierY)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMouseClicked(GuiModular gui, int x, int y, int button) {
        super.onMouseClicked(gui, x, y, button);
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        int scaledX = Mouse.getX() * i / Minecraft.func_71410_x().field_71443_c;
        int scaledY = j - Mouse.getY() * j / Minecraft.func_71410_x().field_71440_d - 1;
        this.mouseLastX = scaledX;
        this.mouseLastY = scaledY;
        if (button == 0 && this.isMouseInBounds(0, 0, x, y)) {
            LinkedList<GuiButton> fullButtonList = new LinkedList<GuiButton>();
            fullButtonList.addAll(this.buttonList);
            fullButtonList.addAll(this.staticButtonList);
            for (GuiButton button2 : fullButtonList) {
                if (!button2.func_146116_c(Minecraft.func_71410_x(), scaledX, scaledY)) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)gui, button2, this.buttonList);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                event.button.func_146113_a(gui.field_146297_k.func_147118_V());
                gui.func_146284_a(event.button);
                if (!((Object)((Object)gui)).equals(gui.field_146297_k.field_71462_r)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)gui, event.button, this.buttonList));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isMouseInBounds(int x, int y, int mouseX, int mouseY) {
        int transformedMouseX = mouseX - x - this.offsetX;
        int transformedMouseY = mouseY - y - this.offsetY;
        return transformedMouseX > 0 && transformedMouseX < this.screenSizeX + this.offsetX && transformedMouseY > 0 && transformedMouseY < this.screenSizeY + this.offsetY;
    }

    protected void moveContainerInterior(int deltaX, int deltaY) {
        if (deltaX > 0) {
            deltaX = Math.min(deltaX, -this.currentPosX);
        } else if (deltaX < 0) {
            deltaX = Math.max(deltaX, -this.containerSizeX - this.currentPosX);
        }
        if (deltaY > 0) {
            deltaY = Math.min(deltaY, -this.currentPosY);
        } else if (deltaY < 0) {
            deltaY = Math.max(deltaY, -this.containerSizeY - this.currentPosY);
        }
        this.currentPosX += deltaX;
        this.currentPosY += deltaY;
        for (Slot slot : this.slotList) {
            slot.field_75223_e += deltaX;
            slot.field_75221_f += deltaX;
        }
        for (GuiButton button2 : this.buttonList) {
            button2.field_146128_h += deltaX;
            button2.field_146129_i += deltaY;
        }
        for (ModuleBase module : this.moduleList) {
            module.offsetX += deltaX;
            module.offsetY += deltaY;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMouseClickedAndDragged(int x, int y, int button, long timeSinceLastClick) {
        if (this.isMouseInBounds(0, 0, x, y)) {
            ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            int i = scaledresolution.func_78326_a();
            int j = scaledresolution.func_78328_b();
            int k = Mouse.getX() * i / Minecraft.func_71410_x().field_71443_c;
            int l = j - Mouse.getY() * j / Minecraft.func_71410_x().field_71440_d - 1;
            if (this.outofBounds) {
                this.mouseLastX = k;
                this.mouseLastY = l;
                this.outofBounds = false;
            } else if (this.mouseLastX != x && this.mouseLastY != y) {
                int deltaX = k - this.mouseLastX;
                int deltaY = l - this.mouseLastY;
                this.moveContainerInterior(deltaX, deltaY);
                this.mouseLastX = k;
                this.mouseLastY = l;
            }
        } else {
            this.outofBounds = true;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBackground(GuiContainer gui, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        GL11.glEnable((int)3089);
        this.setUpScissor(gui, x + this.offsetX, y + this.offsetY, this.screenSizeX + this.offsetX, this.screenSizeY + this.offsetY);
        if (this.backdrop != null) {
            gui.field_146297_k.func_110434_K().func_110577_a(this.backdrop);
            gui.func_73729_b(x + this.offsetX, y + this.offsetY, (int)(-0.1 * (double)this.currentPosX), (int)(-0.1 * (double)this.currentPosY), this.offsetX + this.screenSizeX, this.offsetY + this.screenSizeY);
        }
        for (GuiButton button : this.buttonList) {
            button.func_146112_a(gui.field_146297_k, mouseX, mouseY);
        }
        for (GuiButton button : this.staticButtonList) {
            button.func_146112_a(gui.field_146297_k, mouseX, mouseY);
        }
        for (ModuleBase module : this.moduleList) {
            module.renderBackground(gui, x, y, mouseX, mouseY, font);
        }
        for (ModuleBase module : this.staticModuleList) {
            module.renderBackground(gui, x, y, mouseX, mouseY, font);
        }
        GL11.glDisable((int)3089);
    }

    @Override
    public void setEnabled(boolean state) {
        if (state && !this.isEnabled()) {
            this.moveContainerInterior(10000, 0);
        } else if (!state && this.isEnabled()) {
            this.moveContainerInterior(-10000, 0);
        }
        super.setEnabled(state);
    }
}

