/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.util.ResourceLocation;
import zmaster587.libVulpes.gui.GuiImageButton;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;

public class ModuleButton
extends ModuleBase {
    @SideOnly(value=Side.CLIENT)
    public GuiImageButton button;
    IButtonInventory tile;
    boolean prevState;
    public int buttonId;
    protected int color;
    protected int bgColor;
    String text;
    String tooltipText;
    ResourceLocation[] buttonImages;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected String sound;

    public ModuleButton(int offsetX, int offsetY, int buttonId, String text, IButtonInventory tile, ResourceLocation[] buttonImages) {
        super(offsetX, offsetY);
        this.tile = tile;
        this.buttonImages = buttonImages;
        this.text = text;
        this.buttonId = buttonId;
        this.sound = "";
        this.sizeX = 52;
        this.sizeY = 16;
        this.bgColor = -1;
        this.color = -14483678;
    }

    public ModuleButton(int offsetX, int offsetY, int buttonId, String text, IButtonInventory tile, ResourceLocation[] buttonImages, String tooltipText) {
        this(offsetX, offsetY, buttonId, text, tile, buttonImages);
        this.tooltipText = tooltipText;
    }

    public ModuleButton(int offsetX, int offsetY, int buttonId, String text, IButtonInventory tile, ResourceLocation[] buttonImages, int sizeX, int sizeY) {
        this(offsetX, offsetY, buttonId, text, tile, buttonImages);
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    public ModuleButton(int offsetX, int offsetY, int buttonId, String text, IButtonInventory tile, ResourceLocation[] buttonImages, String tooltipText, int sizeX, int sizeY) {
        this(offsetX, offsetY, buttonId, text, tile, buttonImages, sizeX, sizeY);
        this.tooltipText = tooltipText;
    }

    public void setImage(ResourceLocation[] images) {
        this.button.setButtonTexture(images);
    }

    public void setSound(String str) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            if (this.button == null) {
                this.sound = str;
            } else {
                this.button.setSound(str);
            }
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public void setBGColor(int color) {
        this.bgColor = color;
        if (this.button != null) {
            this.button.setBackgroundColor(color);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.button != null) {
            this.button.field_146125_m = visible;
        }
    }

    public boolean isVisible() {
        return this.button.field_146125_m;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.button != null) {
            this.enabled = this.button.field_146124_l = enabled;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiButton> addButtons(int x, int y) {
        LinkedList<GuiButton> list = new LinkedList<GuiButton>();
        this.button = new GuiImageButton(this.buttonId, x + this.offsetX, y + this.offsetY, this.sizeX, this.sizeY, this.buttonImages);
        this.button.field_146125_m = this.visible;
        if (!this.sound.isEmpty()) {
            this.button.setSound(this.sound);
            this.sound = "";
        }
        this.button.setBackgroundColor(this.bgColor);
        list.add(this.button);
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionPerform(GuiButton button) {
        if (this.enabled && button == this.button) {
            this.tile.onInventoryButtonPressed(this.buttonId);
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        int relativeX = mouseX - this.offsetX;
        int relativeY = mouseY - this.offsetY;
        return this.enabled && relativeX > 0 && relativeX < this.sizeX && relativeY > 0 && relativeY < this.sizeY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderForeground(int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, GuiContainer gui, FontRenderer font) {
        gui.func_73732_a(font, this.text, this.offsetX + this.sizeX / 2, this.offsetY + this.sizeY / 2 - font.field_78288_b / 2, this.color);
        if (this.tooltipText != null && this.isMouseOver(mouseX, mouseY)) {
            LinkedList<String> list = new LinkedList<String>();
            for (String str : this.tooltipText.split("\n")) {
                list.add(str);
            }
            this.drawTooltip(gui, list, mouseX, mouseY, zLevel, font);
        }
    }

    public void setToolTipText(String string) {
        this.tooltipText = string;
    }
}

