/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.util.BlockDirectionFunction;

public class ModuleBlockSideSelector
extends ModuleBase
implements IButtonInventory {
    private IGuiCallback callback;
    private ModuleButton[] buttons;
    private BlockDirectionFunction bdf;
    private String[] text;
    private static final String[] directions = new String[]{"Bottom: ", "Top: ", "North: ", "South ", "West: ", "East: "};
    private static final int[] colors = new int[]{56576, 0xDD0000, 221, 0xDDDD00, 0xDD00DD, 56797};

    public ModuleBlockSideSelector(int offsetX, int offsetY, IGuiCallback callback, String ... stateNames) {
        super(offsetX, offsetY);
        this.callback = callback;
        this.bdf = new BlockDirectionFunction(stateNames.length);
        this.text = stateNames;
        this.buttons = new ModuleButton[]{new ModuleButton(offsetX + 42, offsetY + 42, 0, "", this, TextureResources.buttonSquare, directions[0] + stateNames[0], 16, 16), new ModuleButton(offsetX + 21, offsetY + 21, 1, "", this, TextureResources.buttonSquare, directions[1] + stateNames[0], 16, 16), new ModuleButton(offsetX + 21, offsetY, 2, "", this, TextureResources.buttonSquare, directions[2] + stateNames[0], 16, 16), new ModuleButton(offsetX + 21, offsetY + 42, 3, "", this, TextureResources.buttonSquare, directions[3] + stateNames[0], 16, 16), new ModuleButton(offsetX, offsetY + 21, 4, "", this, TextureResources.buttonSquare, directions[4] + stateNames[0], 16, 16), new ModuleButton(offsetX + 42, offsetY + 21, 5, "", this, TextureResources.buttonSquare, directions[5] + stateNames[0], 16, 16)};
        if (FMLCommonHandler.instance().getSide().isClient()) {
            for (ModuleButton button : this.buttons) {
                button.setBGColor(colors[0]);
            }
        }
    }

    @Override
    public void actionPerform(GuiButton button) {
        for (ModuleButton button2 : this.buttons) {
            button2.actionPerform(button);
        }
    }

    @Override
    public List<GuiButton> addButtons(int x, int y) {
        List<GuiButton> list = super.addButtons(x, y);
        for (int i = 0; i < 6; ++i) {
            list.addAll(this.buttons[i].addButtons(x, y));
        }
        return list;
    }

    @Override
    public void renderBackground(GuiContainer gui, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        super.renderBackground(gui, x, y, mouseX, mouseY, font);
        for (ModuleButton button : this.buttons) {
            button.renderBackground(gui, x, y, mouseX, mouseY, font);
        }
    }

    @Override
    public void renderForeground(int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, GuiContainer gui, FontRenderer font) {
        super.renderForeground(guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        for (ModuleButton button : this.buttons) {
            ((ModuleBase)button).renderForeground(guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        }
    }

    public int getStateForSide(ForgeDirection side) {
        return this.getStateForSide(side.ordinal());
    }

    public int getStateForSide(int side) {
        return this.bdf.getState(side);
    }

    public void setStateForSide(EnumFacing side, int state) {
        this.setStateForSide(side.ordinal(), state);
    }

    public void setStateForSide(int sideNum, int state) {
        this.bdf.setState(sideNum, state);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.buttons[sideNum].setBGColor(colors[this.bdf.getState(sideNum) % colors.length]);
            this.buttons[sideNum].setToolTipText(directions[sideNum] + this.text[this.bdf.getState(sideNum)]);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.bdf.writeToNBT(nbt);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.bdf.readFromNBT(nbt);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].setBGColor(colors[this.bdf.getState(i) % colors.length]);
                this.buttons[i].setToolTipText(directions[i] + this.text[this.bdf.getState(i)]);
            }
        }
    }

    @Override
    public void onInventoryButtonPressed(int buttonId) {
        this.bdf.advanceState(buttonId);
        this.buttons[buttonId].setBGColor(colors[this.bdf.getState(buttonId) % colors.length]);
        this.buttons[buttonId].setToolTipText(directions[buttonId] + this.text[this.bdf.getState(buttonId)]);
        this.callback.onModuleUpdated(this);
    }
}

