/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.client.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class ProgressBarImage {
    protected ResourceLocation image;
    protected int backOffsetX;
    protected int backOffsetY;
    protected int foreOffsetX;
    protected int foreOffsetY;
    protected int backWidth;
    protected int backHeight;
    protected int foreWidth;
    protected int foreHeight;
    protected int insetX;
    protected int insetY;
    ForgeDirection direction;

    public ProgressBarImage(int backOffsetX, int backOffsetY, int backWidth, int backHeight, int foreOffsetX, int foreOffsetY, int foreWidth, int foreHeight, int insetX, int insetY, ForgeDirection direction, ResourceLocation image) {
        this.backOffsetX = backOffsetX;
        this.backOffsetY = backOffsetY;
        this.backWidth = backWidth;
        this.backHeight = backHeight;
        this.foreOffsetX = foreOffsetX;
        this.foreOffsetY = foreOffsetY;
        this.foreHeight = foreHeight;
        this.foreWidth = foreWidth;
        this.insetX = insetX;
        this.insetY = insetY;
        this.direction = direction;
        this.image = image;
    }

    public ProgressBarImage(int backOffsetX, int backOffsetY, int backWidth, int backHeight, int foreOffsetX, int foreOffsetY, int foreWidth, int foreHeight, ForgeDirection direction, ResourceLocation image) {
        this(backOffsetX, backOffsetY, backWidth, backHeight, foreOffsetX, foreOffsetY, foreWidth, foreHeight, 0, 0, direction, image);
    }

    public ProgressBarImage(int backOffsetX, int backOffsetY, int backWidth, int backHeight, int foreOffsetX, int foreOffsetY, ForgeDirection direction, ResourceLocation image) {
        this(backOffsetX, backOffsetY, backWidth, backHeight, foreOffsetX, foreOffsetY, backWidth, backHeight, 0, 0, direction, image);
    }

    public int getBackOffsetX() {
        return this.backOffsetX;
    }

    public int getBackOffsetY() {
        return this.backOffsetY;
    }

    public int getForeOffsetX() {
        return this.foreOffsetX;
    }

    public int getForeOffsetY() {
        return this.foreOffsetY;
    }

    public int getBackWidth() {
        return this.backWidth;
    }

    public int getBackHeight() {
        return this.backHeight;
    }

    public int getForeWidth() {
        return this.foreWidth;
    }

    public int getForeHeight() {
        return this.foreHeight;
    }

    public int getInsetX() {
        return this.insetX;
    }

    public int getInsetY() {
        return this.insetY;
    }

    public ForgeDirection getDirection() {
        return this.direction;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderProgressBarPartial(int x, int y, float center, float variation, Gui gui) {
        float change;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.image);
        gui.func_73729_b(x, y, this.backOffsetX, this.backOffsetY, this.backWidth, this.backHeight);
        if (center - variation / 2.0f < 0.0f) {
            change = center - variation / 2.0f;
            center -= change / 2.0f;
            variation += change;
        }
        if (center + variation / 2.0f > 1.0f) {
            change = 1.0f - center - variation / 2.0f;
            center += change / 2.0f;
            variation -= change;
        }
        if (this.direction == ForgeDirection.EAST) {
            gui.func_73729_b(x + this.insetX + (int)((float)this.foreWidth * (1.0f - center - variation / 2.0f)), y + this.insetY, this.foreOffsetX + (int)((1.0f - variation / 2.0f - center) * (float)this.foreWidth), this.foreOffsetY, (int)(variation * (float)this.foreWidth), this.foreHeight);
        } else if (this.direction == ForgeDirection.UP) {
            gui.func_73729_b(x + this.insetX, y + this.insetY + this.foreHeight - (int)(variation * (float)this.foreHeight), this.foreOffsetX, this.foreOffsetY + this.foreHeight - (int)(variation * (float)this.foreHeight), this.foreWidth, (int)(variation * (float)this.foreHeight));
        } else if (this.direction == ForgeDirection.DOWN) {
            gui.func_73729_b(x + this.insetX, y + this.insetY, this.foreOffsetX, this.foreOffsetY, this.foreWidth, (int)(variation * (float)this.foreHeight));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderProgressBar(int x, int y, float percent, Gui gui) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.image);
        gui.func_73729_b(x, y, this.backOffsetX, this.backOffsetY, this.backWidth, this.backHeight);
        if (this.direction == ForgeDirection.EAST) {
            gui.func_73729_b(x + this.insetX, y + this.insetY, this.foreOffsetX, this.foreOffsetY, (int)(percent * (float)this.foreWidth), this.foreHeight);
        } else if (this.direction == ForgeDirection.WEST) {
            gui.func_73729_b(x + this.insetX + this.foreWidth - (int)(percent * (float)this.foreWidth), y + this.insetY, this.foreOffsetX + this.foreWidth - (int)(percent * (float)this.foreWidth), this.foreOffsetY, (int)(percent * (float)this.foreWidth), this.foreHeight);
        } else if (this.direction == ForgeDirection.UP) {
            gui.func_73729_b(x + this.insetX, y + this.insetY + this.foreHeight - (int)(percent * (float)this.foreHeight), this.foreOffsetX, this.foreOffsetY + this.foreHeight - (int)(percent * (float)this.foreHeight), this.foreWidth, (int)(percent * (float)this.foreHeight));
        } else if (this.direction == ForgeDirection.DOWN) {
            gui.func_73729_b(x + this.insetX, y + this.insetY, this.foreOffsetX, this.foreOffsetY, this.foreWidth, (int)(percent * (float)this.foreHeight));
        }
    }
}

