/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.util.IAdjBlockUpdate;

public class BlockTile
extends RotatableBlock {
    protected IIcon sides_active;
    protected IIcon front_active;
    protected IIcon rear_active;
    protected IIcon bottom_active;
    protected IIcon top_active;
    protected Class<? extends TileEntity> tileClass;
    protected String textureSideName;
    protected String textureFrontName;
    protected String textureTopName;
    protected String textureBottomName;
    protected String textureRearName;
    protected String textureSideName_active;
    protected String textureFrontName_active;
    protected String textureTopName_active;
    protected String textureBottomName_active;
    protected String textureRearName_active;
    protected int guiId;

    public BlockTile(Class<? extends TileEntity> tileClass, int guiId2) {
        super(Material.field_151576_e);
        this.tileClass = tileClass;
        this.guiId = guiId2;
        this.func_149658_d("libvulpes:machineGeneric");
    }

    public Block setBlockTextureName(String texture1, String textureActive) {
        this.func_149658_d(texture1);
        this.textureBottomName_active = this.textureRearName_active = textureActive;
        this.textureTopName_active = this.textureRearName_active;
        this.textureFrontName_active = this.textureRearName_active;
        this.textureSideName_active = this.textureRearName_active;
        return this;
    }

    public Block setSideTexture(String textureName) {
        this.textureSideName = textureName;
        return this;
    }

    public Block setSideTexture(String textureName, String textureNameActive) {
        this.textureSideName = textureName;
        this.textureSideName_active = textureNameActive;
        return this;
    }

    public Block setFrontTexture(String textureName) {
        this.textureFrontName = textureName;
        return this;
    }

    public Block setFrontTexture(String textureName, String textureNameActive) {
        this.textureFrontName = textureName;
        this.textureFrontName_active = textureNameActive;
        return this;
    }

    public Block setTopTexture(String textureName) {
        this.textureTopName = textureName;
        return this;
    }

    public Block setTopTexture(String textureName, String textureNameActive) {
        this.textureTopName = textureName;
        this.textureTopName_active = textureNameActive;
        return this;
    }

    public Block setBottomTexture(String textureName) {
        this.textureBottomName = textureName;
        return this;
    }

    public Block setBottomTexture(String textureName, String textureNameActive) {
        this.textureBottomName = textureName;
        this.textureBottomName_active = textureNameActive;
        return this;
    }

    public Block setRearTexture(String textureName) {
        this.textureRearName = textureName;
        return this;
    }

    public Block setRearTexture(String textureName, String textureNameActive) {
        this.textureRearName = textureName;
        this.textureRearName_active = textureNameActive;
        return this;
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        try {
            return this.tileClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (!world.field_72995_K) {
            player.openGui((Object)LibVulpes.instance, this.guiId, world, x, y, z);
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IAdjBlockUpdate) {
            ((IAdjBlockUpdate)tile).onAdjacentBlockUpdated();
        }
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister icons) {
        this.field_149761_L = icons.func_94245_a(this.func_149641_N());
        this.sides = this.textureSideName == null ? this.field_149761_L : icons.func_94245_a(this.textureSideName);
        this.sides_active = this.textureSideName_active != null ? icons.func_94245_a(this.textureSideName_active) : this.sides;
        this.top = this.textureTopName != null ? icons.func_94245_a(this.textureTopName) : this.sides;
        this.top_active = this.textureTopName_active != null ? icons.func_94245_a(this.textureTopName_active) : this.top;
        this.front = this.textureFrontName == null ? this.sides : icons.func_94245_a(this.textureFrontName);
        this.front_active = this.textureFrontName_active == null ? (this.front != this.sides ? this.front : this.sides_active) : icons.func_94245_a(this.textureFrontName_active);
        this.rear = this.textureRearName == null ? this.sides : icons.func_94245_a(this.textureRearName);
        this.rear_active = this.textureRearName_active == null ? this.sides_active : icons.func_94245_a(this.textureRearName_active);
        this.bottom = this.textureBottomName == null ? this.top : icons.func_94245_a(this.textureBottomName);
        this.bottom_active = this.textureBottomName_active == null ? this.sides_active : icons.func_94245_a(this.textureBottomName_active);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        ForgeDirection dir = BlockTile.getRelativeSide(side, meta);
        if ((meta & 8) == 8) {
            if (dir == ForgeDirection.UP) {
                return this.top_active;
            }
            if (dir == ForgeDirection.DOWN) {
                return this.bottom_active;
            }
            if (dir == ForgeDirection.NORTH) {
                return this.front_active;
            }
            if (dir == ForgeDirection.EAST) {
                return this.sides_active;
            }
            if (dir == ForgeDirection.SOUTH) {
                return this.rear_active;
            }
            if (dir == ForgeDirection.WEST) {
                return this.sides_active;
            }
        } else {
            return super.func_149691_a(side, meta);
        }
        return this.field_149761_L;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            for (int i1 = 0; i1 < inventory.func_70302_i_(); ++i1) {
                ItemStack itemstack = inventory.func_70301_a(i1);
                if (itemstack == null) continue;
                float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = world.field_73012_v.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)entityitem);
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }
}

