/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.api.material;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.libVulpes.api.material.AllowedProducts;
import zmaster587.libVulpes.api.material.Material;
import zmaster587.libVulpes.api.material.MixedMaterial;
import zmaster587.libVulpes.block.BlockCoil;
import zmaster587.libVulpes.block.BlockMetalBlock;
import zmaster587.libVulpes.block.BlockOre;
import zmaster587.libVulpes.items.ItemOre;
import zmaster587.libVulpes.items.ItemOreProduct;
import zmaster587.libVulpes.util.ItemStackMapping;

public class MaterialRegistry {
    static HashMap<Object, MixedMaterial> mixedMaterialList = new HashMap();
    static HashMap<AllowedProducts, List<Block>> productBlockListMapping;
    static List<MaterialRegistry> registries;
    public HashMap<String, Material> strToMaterial = new HashMap();
    public List<Material> materialList = new LinkedList<Material>();
    public Item[] oreProducts;

    public MaterialRegistry() {
        productBlockListMapping = new HashMap();
        registries.add(this);
    }

    public void registerMaterial(Material material) {
        this.strToMaterial.put(material.getUnlocalizedName(), material);
        material.setIndex(this.materialList.size());
        material.registry = this;
        this.materialList.add(material);
    }

    public void registerOres(CreativeTabs tab, String nameSpace) {
        int len = this.materialList.size();
        int numberOfOreBlocks = len / 16 + 1;
        List<AllowedProducts> allAllowedProducts = AllowedProducts.getAllAllowedProducts();
        this.oreProducts = new ItemOreProduct[allAllowedProducts.size()];
        for (int i = 0; i < allAllowedProducts.size(); ++i) {
            if (allAllowedProducts.get(i).isBlock()) continue;
            this.oreProducts[i] = new ItemOreProduct(allAllowedProducts.get(i).name().toLowerCase(Locale.ENGLISH)).func_77637_a(tab);
            GameRegistry.registerItem((Item)this.oreProducts[i], (String)(nameSpace + "product" + allAllowedProducts.get(i).getName().toLowerCase(Locale.ENGLISH)));
        }
        boolean oreAllowed = false;
        boolean blockAllowed = false;
        boolean coilAllowed = false;
        for (Material mat : this.materialList) {
            if (!oreAllowed) {
                oreAllowed = AllowedProducts.getProductByName("ORE").isOfType(mat.getAllowedProducts());
            }
            if (!blockAllowed) {
                blockAllowed = AllowedProducts.getProductByName("BLOCK").isOfType(mat.getAllowedProducts());
            }
            if (coilAllowed) continue;
            coilAllowed = AllowedProducts.getProductByName("COIL").isOfType(mat.getAllowedProducts());
        }
        for (int i = 0; i < numberOfOreBlocks; ++i) {
            String name = "ore";
            String metalBlockName = "metal";
            String coilName = "coil";
            BlockMetalBlock metalBlocks = new BlockMetalBlock(net.minecraft.block.material.Material.field_151576_e);
            metalBlocks.func_149663_c(metalBlockName).func_149647_a(tab).func_149711_c(4.0f).func_149658_d("block");
            metalBlocks.numBlocks = (byte)Math.min(len - 16 * i, 16);
            metalBlocks.product = AllowedProducts.getProductByName("BLOCK");
            BlockOre ores = new BlockOre(net.minecraft.block.material.Material.field_151576_e);
            ores.func_149663_c(name).func_149647_a(tab).func_149711_c(4.0f).func_149658_d("ore");
            ores.numBlocks = (byte)Math.min(len - 16 * i, 16);
            ores.product = AllowedProducts.getProductByName("ORE");
            BlockCoil coilBlocks = new BlockCoil(net.minecraft.block.material.Material.field_151576_e, "libvulpes:coilSide", "libvulpes:coilPole");
            coilBlocks.func_149663_c(coilName).func_149647_a(tab).func_149711_c(4.0f).func_149658_d("coil");
            coilBlocks.numBlocks = (byte)Math.min(len - 16 * i, 16);
            coilBlocks.product = AllowedProducts.getProductByName("COIL");
            if (oreAllowed) {
                GameRegistry.registerBlock((Block)ores, ItemOre.class, (String)(nameSpace + name + i));
            }
            if (blockAllowed) {
                GameRegistry.registerBlock((Block)metalBlocks, ItemOre.class, (String)(nameSpace + metalBlockName + i));
            }
            if (coilAllowed) {
                GameRegistry.registerBlock((Block)coilBlocks, ItemOre.class, (String)(nameSpace + coilName + i));
            }
            for (int j = 0; j < 16 && j < 16 * i + len % 16; ++j) {
                Material ore;
                int index = i * 16 + j;
                ores.ores[j] = ore = this.materialList.get(index);
                ores.setHarvestLevel(ore.getTool(), ore.getHarvestLevel(), j);
                metalBlocks.ores[j] = ore;
                metalBlocks.setHarvestLevel(ore.getTool(), ore.getHarvestLevel(), j);
                coilBlocks.ores[j] = ore;
                coilBlocks.setHarvestLevel(ore.getTool(), ore.getHarvestLevel(), j);
                for (AllowedProducts product : allAllowedProducts) {
                    if (product.isBlock() || !product.isOfType(ore.getAllowedProducts())) continue;
                    ((ItemOreProduct)this.oreProducts[product.ordinal()]).registerItem(index, ore);
                }
                for (String str : ore.getOreDictNames()) {
                    if (AllowedProducts.getProductByName("ORE").isOfType(ore.getAllowedProducts())) {
                        OreDictionary.registerOre((String)("ore" + str), (ItemStack)new ItemStack((Block)ores, 1, j));
                    }
                    if (AllowedProducts.getProductByName("BLOCK").isOfType(ore.getAllowedProducts())) {
                        OreDictionary.registerOre((String)("block" + str), (ItemStack)new ItemStack((Block)metalBlocks, 1, j));
                    }
                    if (!AllowedProducts.getProductByName("COIL").isOfType(ore.getAllowedProducts())) continue;
                    OreDictionary.registerOre((String)("coil" + str), (ItemStack)new ItemStack((Block)coilBlocks, 1, j));
                    OreDictionary.registerOre((String)"blockCoil", (ItemStack)new ItemStack((Block)coilBlocks, 1, j));
                }
            }
            this.getBlockListForProduct(AllowedProducts.getProductByName("BLOCK")).add(metalBlocks);
            this.getBlockListForProduct(AllowedProducts.getProductByName("COIL")).add(coilBlocks);
            this.getBlockListForProduct(AllowedProducts.getProductByName("ORE")).add(ores);
        }
    }

    public List<Block> getBlockListForProduct(AllowedProducts product) {
        return productBlockListMapping.get(product);
    }

    public Block getBlockForProduct(AllowedProducts product, Material material, int index) {
        for (Block block : productBlockListMapping.get(product)) {
            if (((BlockOre)block).ores[index] != material) continue;
            return block;
        }
        return null;
    }

    public static Material getMaterialFromItemStack(ItemStack stack) {
        Item item = stack.func_77973_b();
        for (MaterialRegistry registry : registries) {
            for (Item i : registry.oreProducts) {
                if (item != i || i == null) continue;
                return registry.materialList.get(stack.func_77960_j());
            }
            int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
            for (Material ore : registry.materialList) {
                for (String str : ore.getOreDictNames()) {
                    for (int i : ids) {
                        if (!OreDictionary.getOreName((int)i).contains(str)) continue;
                        return ore;
                    }
                }
            }
        }
        return null;
    }

    public static ItemStack getItemStackFromMaterialAndType(String material, AllowedProducts product) {
        return MaterialRegistry.getItemStackFromMaterialAndType(material, product, 1);
    }

    public static ItemStack getItemStackFromMaterialAndType(String ore, AllowedProducts product, int amount) {
        for (MaterialRegistry registry : registries) {
            Material ore2 = registry.strToMaterial.get(ore);
            if (ore2 == null || product == null) continue;
            return new ItemStack(registry.oreProducts[product.ordinal()], amount, ore2.index);
        }
        return null;
    }

    public static void registerMixedMaterial(MixedMaterial material) {
        if (material.getInput() instanceof ItemStack) {
            mixedMaterialList.put(new ItemStackMapping((ItemStack)material.getInput()), material);
        } else {
            mixedMaterialList.put(material.getInput(), material);
        }
    }

    public MixedMaterial getMixedMaterial(ItemStack stack) {
        return mixedMaterialList.get(new ItemStackMapping(stack));
    }

    public MixedMaterial getMixedMaterial(String str) {
        return mixedMaterialList.get(str);
    }

    public static int getColorFromItemMaterial(ItemStack stack) {
        Material material = MaterialRegistry.getMaterialFromItemStack(stack);
        if (material == null) {
            return 0x7A7A7A;
        }
        return material.getColor();
    }

    public static Collection<MixedMaterial> getMixedMaterialList() {
        return mixedMaterialList.values();
    }

    public static Material getMaterialFromName(String string) {
        for (MaterialRegistry registry : registries) {
            Material material = registry.strToMaterial.get(string);
            if (material == null) continue;
            return material;
        }
        return null;
    }

    public static List<Material> getAllMaterials() {
        LinkedList<Material> list = new LinkedList<Material>();
        for (MaterialRegistry registry : registries) {
            list.addAll(registry.materialList);
        }
        return list;
    }

    static {
        registries = new LinkedList<MaterialRegistry>();
    }
}

