/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import com.google.common.base.Objects;

public class BlockPool {
    static final BlockPool pool = new BlockPool(false);
    BlockNode head;
    BlockNode tail;
    private int size;
    private transient int mask;
    private transient Entry[] hashTable;
    private final boolean _noDupe;

    private static int hash(BlockNode blockNode) {
        int n = blockNode.hashCode();
        return n;
    }

    public BlockPool(boolean bl) {
        this._noDupe = bl;
        if (this._noDupe) {
            this.hashTable = new Entry[16];
            this.mask = 15;
        }
    }

    public BlockPool() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockNode getNext(int n, int n2, int n3) {
        BlockNode blockNode;
        BlockPool blockPool = pool;
        synchronized (blockPool) {
            if (BlockPool.pool.head == null) {
                BlockNode blockNode2 = new BlockNode(pool, n, n2, n3);
                return blockNode2;
            }
            blockNode = pool.shift();
        }
        blockNode.reset(n, n2, n3);
        blockNode.next = null;
        blockNode.prev = null;
        return blockNode;
    }

    public void push(BlockNode blockNode) {
        if (this._noDupe) {
            int n = BlockPool.hash(blockNode);
            if (this.seek(blockNode, n) != null) {
                blockNode.free();
                return;
            }
            this.insert(new Entry(blockNode, n));
            this.rehashIfNecessary();
        }
        blockNode.prev = this.tail;
        blockNode.next = null;
        if (this.tail != null) {
            this.tail.next = blockNode;
        } else {
            this.head = blockNode;
        }
        this.tail = blockNode;
    }

    public BlockNode pop() {
        BlockNode blockNode = this.tail;
        if (blockNode != null) {
            if (this._noDupe) {
                this.delete(this.seek(blockNode, BlockPool.hash(blockNode)));
            }
            this.tail = blockNode.prev;
            blockNode.prev = null;
            if (this.tail != null) {
                this.tail.next = null;
            } else {
                this.head = null;
            }
        }
        return blockNode;
    }

    public BlockNode peek() {
        return this.tail;
    }

    public BlockNode poke() {
        return this.head;
    }

    public void unshift(BlockNode blockNode) {
        if (this._noDupe) {
            int n = BlockPool.hash(blockNode);
            if (this.seek(blockNode, n) != null) {
                blockNode.free();
                return;
            }
            this.insert(new Entry(blockNode, n));
            this.rehashIfNecessary();
        }
        blockNode.next = this.head;
        blockNode.prev = null;
        if (this.head != null) {
            this.head.prev = blockNode;
        } else {
            this.tail = blockNode;
        }
        this.head = blockNode;
    }

    public BlockNode shift() {
        BlockNode blockNode = this.head;
        if (blockNode != null) {
            if (this._noDupe) {
                this.delete(this.seek(blockNode, BlockPool.hash(blockNode)));
            }
            this.head = blockNode.next;
            blockNode.next = null;
            if (this.head != null) {
                this.head.prev = null;
            } else {
                this.tail = null;
            }
        }
        return blockNode;
    }

    public int size() {
        return this.size;
    }

    private Entry seek(BlockNode blockNode, int n) {
        Entry entry = this.hashTable[n & this.mask];
        while (entry != null) {
            if (n == entry.hash && Objects.equal((Object)blockNode, (Object)entry.key)) {
                return entry;
            }
            entry = entry.nextInBucket;
        }
        return null;
    }

    public boolean contains(BlockNode blockNode) {
        return this.seek(blockNode, BlockPool.hash(blockNode)) != null;
    }

    private void insert(Entry entry) {
        int n = entry.hash & this.mask;
        entry.nextInBucket = this.hashTable[n];
        this.hashTable[n] = entry;
        ++this.size;
    }

    private void delete(Entry entry) {
        block3: {
            int n = entry.hash & this.mask;
            Entry entry2 = null;
            Entry entry3 = this.hashTable[n];
            if (entry3 != entry) {
                while (true) {
                    if (entry3 == entry) {
                        entry2.nextInBucket = entry.nextInBucket;
                        break block3;
                    }
                    entry2 = entry3;
                    entry3 = entry3.nextInBucket;
                }
            }
            this.hashTable[n] = entry3.nextInBucket;
        }
        --this.size;
    }

    private void rehashIfNecessary() {
        Entry[] entryArray = this.hashTable;
        if (this.size > entryArray.length * 2 && entryArray.length < 0x40000000) {
            int n = entryArray.length * 2;
            int n2 = n - 1;
            this.hashTable = new Entry[n];
            Entry[] entryArray2 = this.hashTable;
            this.mask = n2;
            int n3 = entryArray.length;
            while (n3-- > 0) {
                Entry entry = entryArray[n3];
                while (entry != null) {
                    Entry entry2 = entry.nextInBucket;
                    int n4 = entry.hash & n2;
                    entry.nextInBucket = entryArray2[n4];
                    entryArray2[n4] = entry;
                    entry = entry2;
                }
            }
        }
    }

    private static final class Entry {
        final BlockNode key;
        final int hash;
        Entry nextInBucket;

        Entry(BlockNode blockNode, int n) {
            this.key = blockNode;
            this.hash = n;
        }
    }

    public static final class BlockNode {
        public int x;
        public int y;
        public int z;
        public BlockNode next;
        public BlockNode prev;
        BlockPool pool;
        private static final int HASH_A = 1664525;
        private static final int HASH_C = 1013904223;

        public BlockNode(BlockPool blockPool, int n, int n2, int n3) {
            this.reset(n, n2, n3);
            this.pool = blockPool;
        }

        void reset(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.z = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void free() {
            BlockPool blockPool = this.pool;
            synchronized (blockPool) {
                this.pool.unshift(this);
            }
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != BlockNode.class) {
                return false;
            }
            BlockNode blockNode = (BlockNode)object;
            return blockNode.x == this.x && blockNode.y == this.y && blockNode.z == this.z && blockNode.pool == this.pool;
        }

        public String toString() {
            return "BlockNode[(" + this.x + "," + this.y + "," + this.z + ");" + this.pool + "]";
        }

        public int hashCode() {
            int n = 1664525 * (this.x ^ 0x5DDE) + 1013904223;
            int n2 = 1664525 * (this.z ^ 0x3ED) + 1013904223;
            int n3 = 1664525 * (this.y ^ 0x6FA) + 1013904223;
            return n ^ n2 ^ n3;
        }
    }
}

