/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.inventory;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class PlayerSlot {
    private final int slot;
    private final EnumInvCategory category;

    public PlayerSlot(int slot, EnumInvCategory category) {
        this.slot = slot;
        this.category = category;
    }

    public static PlayerSlot fromBuff(ByteBuf buf) {
        EnumInvCategory category = EnumInvCategory.fromIndex(buf.readByte());
        byte slot = buf.readByte();
        return new PlayerSlot(slot, category);
    }

    public static PlayerSlot getHand(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            return new PlayerSlot(player.field_71071_by.field_70461_c, EnumInvCategory.MAIN);
        }
        return new PlayerSlot(0, EnumInvCategory.OFF_HAND);
    }

    public void toBuff(ByteBuf buf) {
        buf.writeByte(this.category.getIndex());
        buf.writeByte(this.slot);
    }

    public int getSlotIndex() {
        return this.slot;
    }

    public int getCatIndex() {
        return this.category.getIndex();
    }

    public String toString() {
        return this.category.getIndex() + ":" + this.slot;
    }

    public ItemStack getStackInSlot(EntityPlayer player) {
        if (this.category == EnumInvCategory.ARMOR) {
            return (ItemStack)player.field_71071_by.field_70460_b.get(this.slot);
        }
        if (this.category == EnumInvCategory.MAIN) {
            return (ItemStack)player.field_71071_by.field_70462_a.get(this.slot);
        }
        if (this.category == EnumInvCategory.OFF_HAND) {
            return (ItemStack)player.field_71071_by.field_184439_c.get(this.slot);
        }
        return ItemStack.field_190927_a;
    }

    public static enum EnumInvCategory {
        MAIN(0),
        ARMOR(1),
        OFF_HAND(2);

        private static EnumInvCategory[] indexMap;
        private int index;

        private EnumInvCategory(int index) {
            this.index = index;
        }

        public static EnumInvCategory fromIndex(int index) {
            if (index > 2 || index < 0) {
                return indexMap[0];
            }
            return indexMap[index];
        }

        public int getIndex() {
            return this.index;
        }

        static {
            indexMap = new EnumInvCategory[3];
            EnumInvCategory.indexMap[0] = MAIN;
            EnumInvCategory.indexMap[1] = ARMOR;
            EnumInvCategory.indexMap[2] = OFF_HAND;
        }
    }
}

