/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.init;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import p455w0rd.danknull.DankNull;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.client.gui.GuiDankNull;
import p455w0rd.danknull.container.ContainerDankNullDock;
import p455w0rd.danknull.container.ContainerDankNullItem;
import p455w0rd.danknull.inventory.PlayerSlot;
import p455w0rd.danknull.items.ItemDankNull;

public class ModGuiHandler
implements IGuiHandler {
    public static void init() {
        DankNull.LOGGER.info("Registering GUI Handler");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)"danknull", (IGuiHandler)new ModGuiHandler());
    }

    public static void launchGui(GUIType type, EntityPlayer player, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            player.openGui((Object)DankNull.INSTANCE, type.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    private static PlayerSlot getDankNullSlot(EntityPlayer player) {
        InventoryPlayer playerInv = player.field_71071_by;
        ItemStack mainHand = player.func_184614_ca();
        ItemStack offHand = player.func_184592_cb();
        if (mainHand.func_77973_b() instanceof ItemDankNull) {
            return new PlayerSlot(playerInv.field_70461_c, PlayerSlot.EnumInvCategory.MAIN);
        }
        if (offHand.func_77973_b() instanceof ItemDankNull) {
            return new PlayerSlot(0, PlayerSlot.EnumInvCategory.OFF_HAND);
        }
        for (int i = 0; i < playerInv.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)playerInv.field_70462_a.get(i);
            if (!(stack.func_77973_b() instanceof ItemDankNull)) continue;
            return new PlayerSlot(i, PlayerSlot.EnumInvCategory.MAIN);
        }
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (GUIType.VALUES[id]) {
            case DANKNULL: {
                PlayerSlot dankNull = ModGuiHandler.getDankNullSlot(player);
                if (dankNull == null) {
                    return null;
                }
                return new ContainerDankNullItem(player, dankNull);
            }
            case DANKNULL_TE: {
                TileDankNullDock dankDock;
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (!(te instanceof TileDankNullDock) || (dankDock = (TileDankNullDock)te).getDankNull().func_190926_b()) break;
                return new ContainerDankNullDock(player, dankDock);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (GUIType.VALUES[id]) {
            case DANKNULL_TE: {
                TileDankNullDock dankDock;
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (te instanceof TileDankNullDock && !(dankDock = (TileDankNullDock)te).getDankNull().func_190926_b()) {
                    return new GuiDankNull(new ContainerDankNullDock(player, dankDock));
                }
            }
            case DANKNULL: {
                PlayerSlot dankNull = ModGuiHandler.getDankNullSlot(player);
                if (dankNull == null) {
                    return null;
                }
                return new GuiDankNull(new ContainerDankNullItem(player, dankNull));
            }
        }
        return null;
    }

    public static enum GUIType {
        DANKNULL,
        DANKNULL_TE;

        public static final GUIType[] VALUES;

        static {
            VALUES = GUIType.values();
        }
    }
}

