/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.api;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandlerModifiable;
import p455w0rd.danknull.api.DankNullItemModes;
import p455w0rd.danknull.init.ModGlobals;

public interface IDankNullHandler
extends IItemHandlerModifiable {
    public NonNullList<ItemStack> getStackList();

    @Nonnull
    default public ItemStack extractItemIngoreExtractionMode(int slot, int amount, boolean simulate) {
        return this.extractItem(slot, amount, simulate);
    }

    @Nonnull
    default public ItemStack getStackInSlot(int slot) {
        this.validateSlot(slot);
        return (ItemStack)this.getStackList().get(slot);
    }

    @Nonnull
    public ItemStack getExtractableStackInSlot(int var1);

    @Nonnull
    public ItemStack getFullStackInSlot(int var1);

    @Nonnull
    public ItemStack getRenderableStackForSlot(int var1);

    public boolean isOreDictFiltered(ItemStack var1);

    public boolean containsItemStack(@Nonnull ItemStack var1);

    public int findItemStack(@Nonnull ItemStack var1);

    public ImmutableList<Integer> findItemStacks(@Nonnull ItemStack var1);

    public int stackCount();

    @Nonnull
    public ModGlobals.DankNullTier getTier();

    public int getSelected();

    public void setSelected(int var1);

    public void cycleSelected(boolean var1);

    public boolean isLocked();

    public void setLocked(boolean var1);

    public boolean isLockingSupported();

    public void setOre(@Nonnull ItemStack var1, boolean var2);

    public boolean isOre(@Nonnull ItemStack var1);

    public boolean isOreSupported(@Nonnull ItemStack var1);

    @Nonnull
    public Map<ItemStack, Boolean> getOres();

    public void setExtractionMode(@Nonnull ItemStack var1, @Nonnull DankNullItemModes.ItemExtractionMode var2);

    public void cycleExtractionMode(@Nonnull ItemStack var1, boolean var2);

    @Nonnull
    public DankNullItemModes.ItemExtractionMode getExtractionMode(@Nonnull ItemStack var1);

    @Nonnull
    public Map<ItemStack, DankNullItemModes.ItemExtractionMode> getExtractionModes();

    public void setPlacementMode(@Nonnull ItemStack var1, @Nonnull DankNullItemModes.ItemPlacementMode var2);

    public void cyclePlacementMode(@Nonnull ItemStack var1, boolean var2);

    @Nonnull
    public DankNullItemModes.ItemPlacementMode getPlacementMode(@Nonnull ItemStack var1);

    public Map<ItemStack, DankNullItemModes.ItemPlacementMode> getPlacementMode();

    default public void validateSlot(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }
}

