/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.api.multipart;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.container.IMultipartContainerBlock;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.multipart.MultipartCapabilityHelper;
import mcmultipart.api.ref.MCMPCapabilities;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.world.IMultipartBlockAccess;
import mcmultipart.api.world.IMultipartWorld;
import mcmultipart.network.MultipartNetworkHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class MultipartHelper {
    private static BiFunction<World, BlockPos, IMultipartContainer> createTileFromWorldInfo;
    private static BiFunction<World, BlockPos, IMultipartContainer> createTile;
    private static Function<Block, IMultipart> getPart;

    private MultipartHelper() {
    }

    public static boolean addPart(World world, BlockPos pos, IPartSlot slot, IBlockState state, boolean simulated) {
        IMultipart part = getPart.apply(state.func_177230_c());
        Preconditions.checkState((part != null ? 1 : 0) != 0, (Object)("The blockstate " + state + " could not be converted to a multipart!"));
        IMultipartTile tile = part.createMultipartTile(world, slot, state);
        Optional<IMultipartContainer> containerOpt = MultipartHelper.getOrConvertContainer(world, pos);
        if (!containerOpt.isPresent() || containerOpt.get().getParts().isEmpty()) {
            return false;
        }
        IMultipartContainer container = containerOpt.orElseGet(() -> createTile.apply(world, pos));
        if (container.canAddPart(slot, state, tile)) {
            if (!simulated && !world.field_72995_K) {
                container.addPart(slot, state, tile);
                MultipartNetworkHandler.flushChanges(world, pos);
            }
            return true;
        }
        return false;
    }

    public static Optional<IPartInfo> getInfo(IBlockAccess world, BlockPos pos, IPartSlot slot) {
        return MultipartHelper.getContainer(world, pos).map(c -> c.get(slot)).orElseGet(() -> {
            IBlockState state;
            IMultipart part;
            if (world instanceof World && (part = getPart.apply((state = world.func_180495_p(pos)).func_177230_c())) != null && part.getSlotFromWorld(world, pos, state) == slot) {
                return Optional.of(new DummyPartInfo((World)world, pos, slot, state, part));
            }
            return Optional.empty();
        });
    }

    public static Optional<IMultipart> getPart(IBlockAccess world, BlockPos pos, IPartSlot slot) {
        return MultipartHelper.getContainer(world, pos).map(c -> c.getPart(slot)).orElseGet(() -> Optional.ofNullable(getPart.apply(world.func_180495_p(pos).func_177230_c())));
    }

    public static Optional<IMultipartTile> getPartTile(IBlockAccess world, BlockPos pos, IPartSlot slot) {
        return MultipartHelper.getContainer(world, pos).map(c -> c.getPartTile(slot)).orElseGet(() -> {
            TileEntity te;
            IMultipart part = getPart.apply(world.func_180495_p(pos).func_177230_c());
            if (part != null && (te = world.func_175625_s(pos)) != null) {
                return Optional.of(part.convertToMultipartTile(te));
            }
            return Optional.empty();
        });
    }

    public static Optional<IBlockState> getPartState(IBlockAccess world, BlockPos pos, IPartSlot slot) {
        return MultipartHelper.getContainer(world, pos).map(c -> c.getState(slot)).orElseGet(() -> Optional.of(world.func_180495_p(pos)));
    }

    public static Optional<IMultipartContainer> getContainer(IBlockAccess world, BlockPos pos) {
        IBlockState state;
        IMultipart part;
        if (world.func_180495_p(pos).func_177230_c() instanceof IMultipartContainerBlock) {
            TileEntity te = world.func_175625_s(pos);
            if (te != null) {
                return MultipartCapabilityHelper.optional(te, MCMPCapabilities.MULTIPART_CONTAINER, null);
            }
        } else if (world instanceof World && (part = getPart.apply((state = world.func_180495_p(pos)).func_177230_c())) != null) {
            return Optional.of(new DummyPartInfo((World)world, pos, part.getSlotFromWorld(world, pos, state), state, part));
        }
        return Optional.empty();
    }

    public static Optional<IMultipartContainer> getOrConvertContainer(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IMultipartContainerBlock) {
            TileEntity te = world.func_175625_s(pos);
            if (te != null) {
                return MultipartCapabilityHelper.optional(te, MCMPCapabilities.MULTIPART_CONTAINER, null);
            }
        } else {
            IMultipart part = getPart.apply(state.func_177230_c());
            if (part != null) {
                return Optional.of(createTileFromWorldInfo.apply(world, pos));
            }
        }
        return Optional.empty();
    }

    public static World unwrapWorld(World world) {
        if (world instanceof IMultipartWorld) {
            return ((IMultipartWorld)world).getActualWorld();
        }
        return world;
    }

    public static IBlockAccess unwrapBlockAccess(IBlockAccess world) {
        if (world instanceof IMultipartBlockAccess) {
            return ((IMultipartBlockAccess)world).getActualWorld();
        }
        return world;
    }

    private static final class DummyPartInfo
    implements IPartInfo,
    IMultipartContainer {
        private final World world;
        private final BlockPos pos;
        private final IPartSlot slot;
        private final IBlockState state;
        private final IMultipart part;
        private final Supplier<IMultipartTile> tile;
        private final Supplier<Map<IPartSlot, ? extends IPartInfo>> parts;

        public DummyPartInfo(World world, BlockPos pos, IPartSlot slot, IBlockState state, IMultipart part) {
            this.world = world;
            this.pos = pos;
            this.slot = slot;
            this.state = state;
            this.part = part;
            this.tile = Suppliers.memoize(() -> {
                TileEntity te = world.func_175625_s(pos);
                if (te != null) {
                    return this.part.convertToMultipartTile(te);
                }
                return null;
            });
            this.parts = Suppliers.memoize(() -> Collections.singletonMap(this.slot, this));
        }

        @Override
        public World getPartWorld() {
            return this.world;
        }

        @Override
        public BlockPos getPartPos() {
            return this.pos;
        }

        @Override
        public IMultipartContainer getContainer() {
            return this;
        }

        @Override
        public IPartSlot getSlot() {
            return this.slot;
        }

        @Override
        public IMultipart getPart() {
            return this.part;
        }

        @Override
        public IBlockState getState() {
            return this.state;
        }

        @Override
        public IMultipartTile getTile() {
            return (IMultipartTile)this.tile.get();
        }

        @Override
        public Optional<IPartInfo> get(IPartSlot slot) {
            return slot == this.slot ? Optional.of(this) : Optional.empty();
        }

        @Override
        public Map<IPartSlot, ? extends IPartInfo> getParts() {
            return (Map)this.parts.get();
        }

        @Override
        public boolean canAddPart(IPartSlot slot, IBlockState state, IMultipartTile tile) {
            return MultipartHelper.addPart(this.world, this.pos, slot, state, true);
        }

        @Override
        public void addPart(IPartSlot slot, IBlockState state, IMultipartTile tile) {
            MultipartHelper.addPart(this.world, this.pos, slot, state, false);
        }

        @Override
        public void removePart(IPartSlot slot) {
            if (slot == this.slot) {
                this.world.func_175698_g(this.pos);
            }
        }
    }
}

