/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.api.microblock;

import java.util.Optional;
import javax.annotation.Nullable;
import mcmultipart.api.microblock.IMicroMaterialDelegate;
import mcmultipart.api.microblock.MicroMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class MicroMaterialBlock
extends MicroMaterial {
    private final IBlockState state;
    private final Item item;
    private final float hardness;

    public MicroMaterialBlock(IBlockState state) {
        this(state, ((Float)ReflectionHelper.getPrivateValue(Block.class, (Object)state.func_177230_c(), (String[])new String[]{"field_149782_v", "blockHardness"})).floatValue());
    }

    public MicroMaterialBlock(IBlockState state, float hardness) {
        this(state, Item.func_150898_a((Block)state.func_177230_c()), hardness);
    }

    public MicroMaterialBlock(IBlockState state, Item item, float hardness) {
        super(false);
        this.state = state;
        this.item = item;
        this.hardness = hardness;
        this.delegate = this instanceof IMicroMaterialDelegate ? Optional.of((IMicroMaterialDelegate)((Object)this)) : (state instanceof IMicroMaterialDelegate ? Optional.of((IMicroMaterialDelegate)state) : (state.func_177230_c() instanceof IMicroMaterialDelegate ? Optional.of((IMicroMaterialDelegate)state.func_177230_c()) : Optional.empty()));
        ResourceLocation blockName = state.func_177230_c().getRegistryName();
        this.setRegistryName(new ResourceLocation(blockName.func_110624_b(), blockName.func_110623_a() + "." + state.func_177230_c().func_176201_c(state)));
    }

    @Override
    public String getLocalizedName() {
        return this.item != null ? this.item.func_77653_i(new ItemStack(this.item, 1, this.state.func_177230_c().func_180651_a(this.state))) : this.state.func_177230_c().func_149732_F();
    }

    @Override
    public boolean isSolid() {
        return this.state.func_185913_b();
    }

    @Override
    public int getLightValue() {
        return this.state.func_185906_d();
    }

    @Override
    public float getHardness() {
        return this.hardness;
    }

    @Override
    public int getCuttingStrength() {
        return Math.max(0, this.state.func_177230_c().getHarvestLevel(this.state));
    }

    @Override
    public ItemStack getStack() {
        return new ItemStack(this.item, 1, this.state.func_177230_c().func_180651_a(this.state));
    }

    @Override
    public SoundType getSound(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return state.func_177230_c().getSoundType(state, world, pos, entity);
    }

    @Override
    public IBlockState getDefaultState() {
        return this.state;
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityLivingBase placer, EnumHand hand) {
        return this.state.func_177230_c().getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, this.state.func_177230_c().func_176201_c(this.state), placer, hand);
    }

    @Override
    public IBlockState getActualState(IBlockAccess world, BlockPos pos, IBlockState state) {
        return state.func_185899_b(world, pos);
    }

    @Override
    public IBlockState getExtendedState(IBlockAccess world, BlockPos pos, IBlockState state) {
        return state.func_177230_c().getExtendedState(state, world, pos);
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return state.func_177230_c().canRenderInLayer(state, layer);
    }
}

