/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.core.command.CommandClearBlock;
import cofh.core.command.CommandCountBlock;
import cofh.core.command.CommandEnchant;
import cofh.core.command.CommandFriend;
import cofh.core.command.CommandHand;
import cofh.core.command.CommandHelp;
import cofh.core.command.CommandKillAll;
import cofh.core.command.CommandReplaceBlock;
import cofh.core.command.CommandSyntax;
import cofh.core.command.CommandTPS;
import cofh.core.command.CommandTPX;
import cofh.core.command.CommandUnloadChunk;
import cofh.core.command.CommandVersion;
import cofh.core.command.ISubCommand;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandHandler
extends CommandBase {
    public static final CommandHandler INSTANCE = new CommandHandler();
    private static Map<String, ISubCommand> commands = new Object2ObjectOpenHashMap();
    private static DummyCommand dummy = new DummyCommand();

    public static void initialize() {
        CommandHandler.registerSubCommand(CommandFriend.INSTANCE);
        CommandHandler.registerSubCommand(CommandHelp.INSTANCE);
        CommandHandler.registerSubCommand(CommandSyntax.INSTANCE);
        CommandHandler.registerSubCommand(CommandVersion.INSTANCE);
        CommandHandler.registerSubCommand(CommandClearBlock.INSTANCE);
        CommandHandler.registerSubCommand(CommandCountBlock.INSTANCE);
        CommandHandler.registerSubCommand(CommandEnchant.INSTANCE);
        CommandHandler.registerSubCommand(CommandHand.INSTANCE);
        CommandHandler.registerSubCommand(CommandKillAll.INSTANCE);
        CommandHandler.registerSubCommand(CommandReplaceBlock.INSTANCE);
        CommandHandler.registerSubCommand(CommandTPS.INSTANCE);
        CommandHandler.registerSubCommand(CommandTPX.INSTANCE);
        CommandHandler.registerSubCommand(CommandUnloadChunk.INSTANCE);
        CommandClearBlock.config();
        CommandCountBlock.config();
        CommandEnchant.config();
        CommandHand.config();
        CommandKillAll.config();
        CommandReplaceBlock.config();
        CommandTPS.config();
        CommandTPX.config();
        CommandUnloadChunk.config();
    }

    public static boolean registerSubCommand(ISubCommand subCommand) {
        if (!commands.containsKey(subCommand.getCommandName())) {
            commands.put(subCommand.getCommandName(), subCommand);
            return true;
        }
        return false;
    }

    public static Set<String> getCommandList() {
        return commands.keySet();
    }

    public static int getCommandPermission(String command) {
        return CommandHandler.getCommandExists(command) ? commands.get(command).getPermissionLevel() : Integer.MAX_VALUE;
    }

    public static boolean getCommandExists(String command) {
        return commands.containsKey(command);
    }

    public static boolean canUseCommand(ICommandSender sender, int permission, String name) {
        return CommandHandler.getCommandExists(name) && (sender.func_70003_b(permission, "cofh " + name) || sender instanceof EntityPlayerMP && permission <= 0);
    }

    public int func_82362_a() {
        return -1;
    }

    public static void logAdminCommand(ICommandSender sender, ISubCommand command, String info, Object ... data) {
        dummy.setFromCommand(command);
        int e = data.length;
        for (int i = 0; i < e; ++i) {
            float f;
            Number d;
            int a;
            Object entry = data[i];
            if (!(entry instanceof Number) || (float)(a = (d = (Number)entry).intValue()) == (f = d.floatValue())) continue;
            data[i] = String.format("%.2f", Float.valueOf(f));
        }
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)dummy, (String)info, (Object[])data);
    }

    public String func_71517_b() {
        return "cofh";
    }

    public List<String> func_71514_a() {
        return new ArrayList<String>();
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " help";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer minecraftServer, ICommandSender sender, String[] arguments) throws CommandException {
        ISubCommand command;
        if (arguments.length < 1) {
            arguments = new String[]{"help"};
        }
        if ((command = commands.get(arguments[0])) != null) {
            if (CommandHandler.canUseCommand(sender, command.getPermissionLevel(), command.getCommandName())) {
                command.handleCommand(minecraftServer, sender, arguments);
                return;
            }
            throw new CommandException("commands.generic.permission", new Object[0]);
        }
        throw new CommandNotFoundException("chat.cofh.command.notFound", new Object[0]);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandHandler.func_175762_a((String[])args, commands.keySet());
        }
        if (commands.containsKey(args[0])) {
            return commands.get(args[0]).addTabCompletionOptions(server, sender, args);
        }
        return null;
    }

    private static class DummyCommand
    extends CommandBase {
        private int perm = 4;
        private String name = "";

        private DummyCommand() {
        }

        public void setFromCommand(ISubCommand command) {
            this.name = command.getCommandName();
            this.perm = command.getPermissionLevel();
        }

        public String func_71517_b() {
            return "cofh " + this.name;
        }

        public int func_82362_a() {
            return this.perm;
        }

        public String func_71518_a(ICommandSender sender) {
            return "";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        }
    }
}

