/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class FakePlayerUtil {
    private static GameProfile IE_PROFILE = new GameProfile(UUID.fromString("99562b85-bd1a-4ded-bb1a-c307bf0c0133"), "[ImmersiveEngineering]");
    private static Map<World, WeakReference<FakePlayer>> fakePlayerInstances = new WeakHashMap<World, WeakReference<FakePlayer>>();

    public static FakePlayer getAnyFakePlayer() {
        if (fakePlayerInstances.isEmpty()) {
            return null;
        }
        Iterator<WeakReference<FakePlayer>> it = fakePlayerInstances.values().iterator();
        while (it.hasNext()) {
            FakePlayer player = (FakePlayer)it.next().get();
            if (player == null) {
                it.remove();
                continue;
            }
            return player;
        }
        return null;
    }

    public static FakePlayer getFakePlayer(World w) {
        return (FakePlayer)fakePlayerInstances.get(w).get();
    }

    @SubscribeEvent
    public static void onLoad(WorldEvent.Load ev) {
        World world = ev.getWorld();
        if (world instanceof WorldServer) {
            fakePlayerInstances.put(world, new WeakReference<FakePlayer>(FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)IE_PROFILE)));
        }
    }

    @SubscribeEvent
    public static void onUnload(WorldEvent.Unload ev) {
        World world = ev.getWorld();
        if (world instanceof WorldServer) {
            fakePlayerInstances.remove(world);
        }
    }
}

