/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderCaseDrill;
import blusunrize.immersiveengineering.api.shader.ShaderCaseItem;
import blusunrize.immersiveengineering.api.shader.ShaderCaseMinecart;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.cloth.BlockTypes_ClothDevice;
import blusunrize.immersiveengineering.common.blocks.cloth.TileEntityShaderBanner;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.lib.manual.ManualUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ItemShader
extends ItemIEBase
implements IShaderItem,
IEItemInterfaces.ITextureOverride {
    public ItemShader() {
        super("shader", 1, new String[0]);
        this.setDefaultTextureBounds(new ResourceLocation("immersiveengineering:revolvers/shaders/revolver_whitestripe"), 0.0, 0.0, 0.25, 0.25);
        this.setDefaultTextureBounds(new ResourceLocation("immersiveengineering:items/shaders/drill_diesel_whitestripe"), 0.0, 0.34375, 0.5, 0.84375);
        ItemShader.addShader("Rosequartz", 0, EnumRarity.COMMON, -12508381, -1657676, -995891, -1657676).setInfo(null, null, "rosequartz");
        ItemShader.addShader("Argo", 2, EnumRarity.COMMON, -13816531, -2302756, -2328541, -3618616).setInfo(null, null, "argo");
        ItemShader.addShader("Sunstrike", 5, EnumRarity.RARE, -9211021, -3315456, -1177077248, -1177077248).setInfo(null, null, "sunstrike");
        ItemShader.addShader("Locus", 2, EnumRarity.COMMON, -16119286, -11908534, -8087988, -11908534).setInfo("Mercenaries", "Red vs Blue", "locus");
        ItemShader.addShader("Felix", 1, EnumRarity.COMMON, -16119286, -11908534, -1013757, -11908534).setInfo("Mercenaries", "Red vs Blue", "felix");
        ItemShader.addShader("Sharkface", 2, EnumRarity.UNCOMMON, -16119286, -11908534, -7274488, -11908534, "shark", true, -1).setInfo("Mercenaries", "Red vs Blue", "sharkface");
        ItemShader.addShader("Dragon's Breath", 1, EnumRarity.UNCOMMON, -15132391, -13418709, -7697782, -7697782, "shark", true, -1).setInfo(null, "Destiny", "dragonsbreath");
        ItemShader.addShader("Hawk", 3, EnumRarity.COMMON, -10001557, -725269, -13816531, -725269).setInfo(null, "Destiny", "hawk");
        ItemShader.addShader("Eyas", 3, EnumRarity.COMMON, -11381938, -8771064, -13816531, -725269).setInfo(null, "Destiny", "eyas");
        ItemShader.addShader("Magnum", 1, EnumRarity.COMMON, -11126740, -2302756, -6250336, -2302756).setInfo(null, null, "magnum");
        ItemShader.addShader("Fox", 2, EnumRarity.UNCOMMON, -13816531, -2851279, -1381654, -1381654).setInfo(null, null, "fox");
        ItemShader.addShader("Vault-Tec", 0, EnumRarity.COMMON, -11126740, -15054971, -4150704, -5592406).setInfo(null, "Fallout", "vaulttec");
        ShaderRegistry.ShaderRegistryEntry entry = ItemShader.addShader("Sponsor", 0, EnumRarity.EPIC, -15132391, -582876, -1, -5592406, "sponsor", false, -1).setInfo(null, "Fallout", "sponsor");
        ((ShaderCaseMinecart)entry.getCase((String)"immersiveengineering:minecart")).mirrorSideForPass[2] = false;
        entry.getCase("immersiveengineering:revolver").getLayers()[4].setTextureBounds(0.0, 0.0, 0.25, 0.25);
        entry.getCase("immersiveengineering:drill").getLayers()[3].setTextureBounds(0.15625, 0.53125, 0.40625, 0.78125);
        entry.getCase("immersiveengineering:chemthrower").getLayers()[3].setTextureBounds(0.09375, 0.25, 0.34375, 0.5);
        entry.getCase("immersiveengineering:shield").getLayers()[2].setTextureBounds(0.0, 0.28125, 0.4375, 0.78125).setCutoutBounds(0.0625, 0.0, 0.9375, 1.0);
        ItemShader.addShader("Mass Fusion", 3, EnumRarity.RARE, -9545161, -13023440, -11250604, -5592406, "fusion", true, -1).setInfo(null, "Fallout", "massfusion");
        ItemShader.addShader("StormFlower", 1, EnumRarity.COMMON, -14207961, -14127312, -11824555, -14127312).setInfo(null, "RWBY", "stormflower");
        ItemShader.addShader("Mil\u00f3", 2, EnumRarity.UNCOMMON, -12903664, -10027004, -3244528, -10027004).setInfo(null, "RWBY", "milo");
        ItemShader.addShader("Trident", 2, EnumRarity.UNCOMMON, -11447983, -5723992, -14035969, -5263441).setInfo(null, "RWBY", "trident");
        ItemShader.addShader("Chloris", 4, EnumRarity.RARE, -13094358, -13094358, -7800130, -3618616).setInfo(null, "RWBY", "chloris");
        ItemShader.addShader("Crescent Rose", 2, EnumRarity.COMMON, -15461356, -7274488, -16250872, -5987164).setInfo(null, "RWBY", "crescentrose");
        ItemShader.addShader("Qrow", 2, EnumRarity.UNCOMMON, -9626607, -2566192, -13552064, -9240568).setInfo(null, "RWBY", "qrow");
        entry = ItemShader.addShader("Lusus Naturae", 0, EnumRarity.EPIC, -15460071, -15460071, -5393217, -5393217).setInfo(null, "RWBY", "lususnaturae");
        ItemShader.addBlockScaledLayer(entry, "minecraft:blocks/destroy_stage_8", -1147925492);
        ItemShader.addLayer(entry, "1_4", -5393217);
        ItemShader.addShader("Vanguard", 3, EnumRarity.UNCOMMON, -13158601, -15525054, -4690924, -2302756).setInfo(null, "Destiny", "vanguard");
        ItemShader.addShader("Regal", 4, EnumRarity.UNCOMMON, -2566959, -12379107, -2566959, -2566959).setInfo(null, "Destiny", "regal");
        ItemShader.addShader("Harrowed", 4, EnumRarity.RARE, -15330527, -12379107, -15330527, -15330527).setInfo(null, "Destiny", "harrowed");
        ItemShader.addShader("Taken", 5, EnumRarity.EPIC, -15655898, -15655898, -4532259, -15655898, null, false, -1).setInfo(null, "Destiny", "taken");
        entry = ItemShader.addShader("IKELOS", 2, Lib.RARITY_Masterwork, -9148835, -12434616, -12434616, -13553359).setInfo(null, "Destiny", "ikelos");
        ItemShader.addDynamicLayer(entry, "circuit", -1072873, (layer, superColour) -> ClientUtils.pulseRGBAlpha(superColour, 40, 0.15f, 1.0f), (pre, partialTick) -> {
            if (pre.booleanValue()) {
                GlStateManager.func_179123_a();
                GL11.glLight((int)16385, (int)4609, (FloatBuffer)RenderHelper.func_74521_a((float)0.5f, (float)0.2f, (float)0.0f, (float)0.5f));
                ClientUtils.toggleLightmap(true, true);
            } else {
                ClientUtils.toggleLightmap(false, true);
                GlStateManager.func_179099_b();
            }
        });
        ItemShader.addLayer(entry, "1_4", -10525590);
        entry.setEffectFunction((world, shader, item, shaderType, pos, dir, scale) -> {
            ImmersiveEngineering.proxy.spawnFractalFX(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, dir != null ? dir : new Vec3d(0.0, 1.0, 0.0), scale, 2, null);
            ImmersiveEngineering.proxy.spawnFractalFX(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, dir != null ? dir : new Vec3d(0.0, 0.0, 1.0), scale, 2, null);
            ImmersiveEngineering.proxy.spawnFractalFX(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, dir != null ? dir : new Vec3d(1.0, 0.0, 0.0), scale, 2, null);
        });
        ItemShader.addShader("Angel's Thesis", 2, EnumRarity.EPIC, -14803426, -9091433, -8931011, -11513776, null, false, -1).setInfo("Mecha", "Neon Genesis Evangelion", "angelsthesis");
        ItemShader.addShader("Sutherland", 0, EnumRarity.RARE, -12304305, -9740626, -9427143, -12304305, "whitestripe", true, -9428940).setInfo("Mecha", "Code Geass", "sutherland");
        ItemShader.addShader("Exia", 8, EnumRarity.RARE, -5103092, -11177518, -1251359, -4129337, "whitestripe", true, -4157390).setInfo("Mecha", "Gundam 00", "exia");
        ItemShader.addShader("Crimson Lotus", 3, Lib.RARITY_Masterwork, -2608583, -2608583, -11645101, -13635209, "whitestripe", true, -738991).setInfo("Mecha", "Gurren Lagann", "gurrenlagann");
        ItemShader.addShader("Dominator", 1, EnumRarity.UNCOMMON, -11783905, -14013386, -10747909, -14013386, "1_3", true, -14013386).setInfo(null, "Psycho-Pass", "dominator");
        ItemShader.addShader("Warbird", 7, EnumRarity.UNCOMMON, -13552064, -2566192, -1332224, -2566192).setInfo(null, null, "warbird");
        ItemShader.addShader("Matrix", 7, EnumRarity.RARE, -16433348, -1973761, -2818049, -1, "pipes", true, -8069672).setInfo(null, null, "matrix");
        ItemShader.addShader("Twili", 5, EnumRarity.EPIC, -11182736, -15065557, -14538951, -14830194, "circuit", false, -14830194).setInfo(null, "The Legend of Zelda: Twilight Princess", "twili");
        ItemShader.addShader("Usurper", 3, EnumRarity.EPIC, -12706274, -10722986, -15658992, -9209236, "circuit", false, -3526856).setInfo(null, "The Legend of Zelda: Twilight Princess", "usurper");
        entry = ItemShader.addShader("Ancient", 6, Lib.RARITY_Masterwork, -6538707, -11450296, -610742, -8323854).setInfo(null, "The Legend of Zelda: Breath of the Wild", "ancient");
        ItemShader.addDynamicLayer(entry, "1_6", -1426394361, (layer, superColour) -> ClientUtils.pulseRGBAlpha(-8323854, 60, 0.05f, 0.5f), (pre, partialTick) -> ClientUtils.toggleLightmap(pre, true));
        ItemShader.addLayer(entry, "circuit", -1715694729);
        ((ShaderCaseDrill)entry.getCase("immersiveengineering:drill")).addHeadLayers(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering", "items/drill_iron"), -8323854));
        ItemShader.addShader("Glacis", 6, EnumRarity.RARE, -11953214, 863424761, 868089853, 868089853).setInfo(null, null, "glacis");
        ItemShader.addShader("Phoenix", 5, EnumRarity.RARE, -9109504, -3145728, -33024, -33024).setInfo(null, null, "phoenix");
        ItemShader.addShader("Radiant", 3, EnumRarity.UNCOMMON, -6066517, -468036, -3695951, -2565917, "pipes", true, -931554).setInfo(null, "Kingdom Hearts", "radiant");
        ItemShader.addShader("Hollow", 4, EnumRarity.UNCOMMON, -11260644, -1128987, -3372672, -3890774, "pipes", true, -3893192).setInfo(null, "Kingdom Hearts", "hollow");
        ItemShader.addShader("Microshark", 8, EnumRarity.RARE, -8957868, -526641, -7118233, -7118233, "shark", true, -1).setInfo(null, "Terraria", "microshark");
        ItemShader.addShader("N7", 2, EnumRarity.EPIC, -15526117, -11383478, -2090727, -7698812, "whitestripe", false, -1).setInfo(null, "Mass Effect", "n7");
        ItemShader.addShader("Normandy", 8, EnumRarity.RARE, -1, -15066598, -1, -1, "whitestripe", true, -13286274).setInfo(null, "Mass Effect", "normandy");
        ItemShader.addShader("OmniTool", 2, EnumRarity.RARE, 1090491692, 822056236, 1090491692, 553620780).setInfo(null, "Mass Effect", "omnitool");
        entry = ItemShader.addShader("The Kindled", 5, EnumRarity.EPIC, -13953525, -12961222, -2134944737, -11579569).setInfo(null, "Dark Souls", "kindled");
        ItemShader.addBlockScaledLayer(entry, "minecraft:blocks/fire_layer_0", -2130706433);
        entry = ItemShader.addShader("Dark Fire", 5, EnumRarity.EPIC, -14806245, -14608845, -13432814, -12506779).setInfo(null, "Kingdom Hearts", "darkfire");
        ItemShader.addBlockScaledLayer(entry, "immersiveengineering:blocks/shaders/greyscale_fire", -6388757);
        entry = ItemShader.addShader("Erruption", 5, EnumRarity.RARE, -13953525, -10992849, -2134953953, -10992849).setInfo(null, null, "erruption");
        ItemShader.addBlockScaledLayer(entry, "minecraft:blocks/destroy_stage_8", -40172);
        ItemShader.addShader("WAAAGH!", 5, EnumRarity.RARE, -15790321, -2185454, -4105463, -13684945, "1_7", true, -13684945).setInfo(null, "Warhammer 40k", "waaagh");
    }

    @Override
    public ShaderCase getShaderCase(ItemStack shader, ItemStack item, String shaderType) {
        String name = this.getShaderName(shader);
        return ShaderRegistry.getShader(name, shaderType);
    }

    public static ShaderRegistry.ShaderRegistryEntry addShader(String name, int overlayType, EnumRarity rarity, int colourBackground, int colourPrimary, int colourSecondary, int colourBlade) {
        return ItemShader.addShader(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, colourBlade, null, true, -1);
    }

    public static ShaderRegistry.ShaderRegistryEntry addShader(String name, int overlayType, EnumRarity rarity, int colourBackground, int colourPrimary, int colourSecondary, int colourBlade, String additionalTexture, boolean loot, int colourOverlay) {
        return ShaderRegistry.registerShader(name, Integer.toString(overlayType), rarity, colourPrimary, colourSecondary, colourBackground, colourBlade, additionalTexture, colourOverlay, loot, true);
    }

    private static void addBlockScaledLayer(ShaderRegistry.ShaderRegistryEntry entry, String texture, int colour) {
        entry.getCase("immersiveengineering:revolver").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.0, 0.0, 0.25, 0.1875));
        entry.getCase("immersiveengineering:drill").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.15625, 0.53125, 0.40625, 0.78125).setCutoutBounds(0.1875, 0.0, 0.8125, 0.75));
        entry.getCase("immersiveengineering:chemthrower").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.09375, 0.25, 0.34375, 0.375).setCutoutBounds(0.0, 0.0, 1.0, 0.5));
        entry.getCase("immersiveengineering:railgun").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.859375, 0.75, 1.0, 0.90625).setCutoutBounds(0.25, 0.125, 0.75, 0.6875));
        entry.getCase("immersiveengineering:shield").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.0, 0.28125, 0.4375, 0.8125).setCutoutBounds(0.0625, 0.0, 0.9375, 1.0));
        entry.getCase("immersiveengineering:balloon").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.0, 0.375, 0.75, 0.875).setCutoutBounds(0.125, 0.0, 0.875, 0.5));
        entry.getCase("immersiveengineering:banner").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.015625, 0.328125, 0.328125, 0.640625));
    }

    private static void addLayer(ShaderRegistry.ShaderRegistryEntry entry, String texture, int colour) {
        entry.getCase("immersiveengineering:revolver").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:revolvers/shaders/revolver_" + texture), colour));
        entry.getCase("immersiveengineering:drill").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/drill_diesel_" + texture), colour));
        entry.getCase("immersiveengineering:chemthrower").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/chemthrower_" + texture), colour));
        entry.getCase("immersiveengineering:railgun").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/railgun_" + texture), colour));
        entry.getCase("immersiveengineering:shield").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/shield_" + texture), colour));
        entry.getCase("immersiveengineering:minecart").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:textures/models/shaders/minecart_" + texture + ".png"), colour));
        entry.getCase("immersiveengineering:balloon").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:blocks/shaders/balloon_" + texture), colour));
        entry.getCase("immersiveengineering:banner").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:blocks/shaders/banner_" + texture), colour));
    }

    private static void addDynamicLayer(ShaderRegistry.ShaderRegistryEntry entry, String texture, int colour, BiFunction<ShaderCase.ShaderLayer, Integer, Integer> func_getColour, BiConsumer<Boolean, Float> func_modifyRender) {
        entry.getCase("immersiveengineering:revolver").addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:revolvers/shaders/revolver_" + texture), colour, func_getColour, func_modifyRender));
        entry.getCase("immersiveengineering:drill").addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/drill_diesel_" + texture), colour, func_getColour, func_modifyRender));
        entry.getCase("immersiveengineering:chemthrower").addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/chemthrower_" + texture), colour, func_getColour, func_modifyRender));
        entry.getCase("immersiveengineering:railgun").addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/railgun_" + texture), colour, func_getColour, func_modifyRender));
        entry.getCase("immersiveengineering:shield").addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/shield_" + texture), colour, func_getColour, func_modifyRender));
        entry.getCase("immersiveengineering:minecart").addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:textures/models/shaders/minecart_" + texture + ".png"), colour, func_getColour, func_modifyRender));
        entry.getCase("immersiveengineering:balloon").addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:blocks/shaders/balloon_" + texture), colour, func_getColour, func_modifyRender));
        entry.getCase("immersiveengineering:banner").addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:blocks/shaders/banner_" + texture), colour, func_getColour, func_modifyRender));
    }

    public void setDefaultTextureBounds(ResourceLocation rl, double ... bounds) {
        ShaderRegistry.defaultLayerBounds.put(rl, bounds);
    }

    @Override
    public String getShaderName(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "shader_name")) {
            String name = ItemNBTHelper.getString(stack, "shader_name");
            if (ShaderRegistry.shaderRegistry.containsKey(ItemNBTHelper.getString(stack, "shader_name"))) {
                return name;
            }
            Set<String> keys = ShaderRegistry.shaderRegistry.keySet();
            ArrayList<String> corrected = ManualUtils.getPrimitiveSpellingCorrections(name, keys.toArray(new String[keys.size()]), 4);
            if (!corrected.isEmpty()) {
                IELogger.info("SHADER UPDATE: Fixing " + name + " to " + corrected.get(0));
                IELogger.info("Others: " + corrected);
                ItemNBTHelper.setString(stack, "shader_name", corrected.get(0));
                return corrected.get(0);
            }
        }
        return "";
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        String name = this.getShaderName(player.func_184586_b(hand));
        if (ShaderRegistry.shaderRegistry.containsKey(name)) {
            IBlockState blockState = world.func_180495_p(pos);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityBanner) {
                ShaderCase sCase = ShaderRegistry.shaderRegistry.get(name).getCase("immersiveengineering:banner");
                if (sCase != null) {
                    boolean wall = blockState.func_177230_c() == Blocks.field_180394_cL;
                    int orientation = wall ? ((EnumFacing)blockState.func_177229_b((IProperty)BlockBanner.field_176449_a)).func_176745_a() : ((Integer)blockState.func_177229_b((IProperty)BlockBanner.field_176448_b)).intValue();
                    world.func_175656_a(pos, IEContent.blockClothDevice.func_176203_a(BlockTypes_ClothDevice.SHADER_BANNER.getMeta()).func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)EnumFacing.SOUTH));
                    tile = world.func_175625_s(pos);
                    if (tile instanceof TileEntityShaderBanner) {
                        ((TileEntityShaderBanner)tile).wall = wall;
                        ((TileEntityShaderBanner)tile).orientation = (byte)orientation;
                        ((TileEntityShaderBanner)tile).shader.setShaderItem(Utils.copyStackWithAmount(player.func_184586_b(hand), 1));
                        tile.func_70296_d();
                        return EnumActionResult.SUCCESS;
                    }
                }
            } else if (tile instanceof TileEntityShaderBanner) {
                ItemStack current = ((TileEntityShaderBanner)tile).shader.getShaderItem();
                if (!(current.func_190926_b() || world.field_72995_K || player.field_71075_bZ.field_75098_d)) {
                    double dx = (double)pos.func_177958_n() + 0.5 + (double)side.func_82601_c();
                    double dy = (double)pos.func_177956_o() + 0.5 + (double)side.func_96559_d();
                    double dz = (double)pos.func_177952_p() + 0.5 + (double)side.func_82599_e();
                    EntityItem entityitem = new EntityItem(world, dx, dy, dz, current.func_77946_l());
                    entityitem.func_174869_p();
                    world.func_72838_d((Entity)entityitem);
                }
                ((TileEntityShaderBanner)tile).shader.setShaderItem(Utils.copyStackWithAmount(player.func_184586_b(hand), 1));
                tile.func_70296_d();
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        list.add(I18n.func_135052_a((String)("Level: " + this.func_77613_e((ItemStack)stack).field_77937_e + this.func_77613_e((ItemStack)stack).field_77934_f), (Object[])new Object[0]));
        if (!GuiScreen.func_146272_n()) {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.shader.applyTo", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"desc.immersiveengineering.info.holdShift", (Object[])new Object[0]));
        } else {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.shader.applyTo", (Object[])new Object[0]));
            String name = this.getShaderName(stack);
            if (name != null && !name.isEmpty()) {
                List<ShaderCase> array = ShaderRegistry.shaderRegistry.get(name).getCases();
                for (ShaderCase sCase : array) {
                    if (sCase instanceof ShaderCaseItem) continue;
                    list.add(TextFormatting.DARK_GRAY + " " + I18n.func_135052_a((String)("desc.immersiveengineering.info.shader." + sCase.getShaderType()), (Object[])new Object[0]));
                }
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        String s = this.getShaderName(stack);
        return super.func_77653_i(stack) + (s != null && !s.isEmpty() ? ": " + s : "");
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        String s = this.getShaderName(stack);
        return ShaderRegistry.shaderRegistry.containsKey(s) ? ShaderRegistry.shaderRegistry.get(s).getRarity() : EnumRarity.COMMON;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (String key : ShaderRegistry.shaderRegistry.keySet()) {
                ItemStack s = new ItemStack((Item)this);
                ItemNBTHelper.setString(s, "shader_name", key);
                list.add((Object)s);
            }
        }
    }

    @Override
    public boolean hasCustomItemColours() {
        return true;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        ShaderCase sCase;
        String name = this.getShaderName(stack);
        if (ShaderRegistry.shaderRegistry.containsKey(name) && (sCase = ShaderRegistry.shaderRegistry.get(name).getCase("immersiveengineering:item")) != null) {
            ShaderCase.ShaderLayer[] layers = sCase.getLayers();
            if (pass < layers.length && layers[pass] != null) {
                return layers[pass].getColour();
            }
            return -1;
        }
        return super.getColourForIEItem(stack, pass);
    }

    @Override
    public String getModelCacheKey(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "shader_name")) {
            return ItemNBTHelper.getString(stack, "shader_name");
        }
        return null;
    }

    @Override
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        ShaderCase sCase;
        String name = this.getShaderName(stack);
        if (ShaderRegistry.shaderRegistry.containsKey(name) && (sCase = ShaderRegistry.shaderRegistry.get(name).getCase("immersiveengineering:item")) != null) {
            ShaderCase.ShaderLayer[] layers = sCase.getLayers();
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(layers.length);
            for (ShaderCase.ShaderLayer layer : layers) {
                list.add(layer.getTexture());
            }
            return list;
        }
        return Arrays.asList(new ResourceLocation("immersiveengineering:items/shader_0"), new ResourceLocation("immersiveengineering:items/shader_1"), new ResourceLocation("immersiveengineering:items/shader_2"));
    }

    private static class InternalDynamicShaderLayer
    extends ShaderCase.DynamicShaderLayer {
        private final BiFunction<ShaderCase.ShaderLayer, Integer, Integer> func_getColour;
        private final BiConsumer<Boolean, Float> func_modifyRender;

        public InternalDynamicShaderLayer(ResourceLocation texture, int colour, BiFunction<ShaderCase.ShaderLayer, Integer, Integer> func_getColour, BiConsumer<Boolean, Float> func_modifyRender) {
            super(texture, colour);
            this.func_getColour = func_getColour;
            this.func_modifyRender = func_modifyRender;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int getColour() {
            if (this.func_getColour != null) {
                return this.func_getColour.apply(this, super.getColour());
            }
            return super.getColour();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void modifyRender(boolean pre, float partialTick) {
            if (this.func_modifyRender != null) {
                this.func_modifyRender.accept(pre, Float.valueOf(partialTick));
            }
        }
    }
}

